/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.EncodableDigest;
import org.bouncycastle.crypto.digests.GeneralDigest;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public class SHA1Digest
extends GeneralDigest
implements EncodableDigest {
    private static final int DIGEST_LENGTH = 20;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int[] X = new int[80];
    private int xOff;
    private static final int Y1 = 1518500249;
    private static final int Y2 = 1859775393;
    private static final int Y3 = -1894007588;
    private static final int Y4 = -899497514;

    public SHA1Digest() {
        this.reset();
    }

    public SHA1Digest(SHA1Digest sHA1Digest) {
        super(sHA1Digest);
        this.copyIn(sHA1Digest);
    }

    public SHA1Digest(byte[] byArray) {
        super(byArray);
        this.H1 = Pack.bigEndianToInt(byArray, 16);
        this.H2 = Pack.bigEndianToInt(byArray, 20);
        this.H3 = Pack.bigEndianToInt(byArray, 24);
        this.H4 = Pack.bigEndianToInt(byArray, 28);
        this.H5 = Pack.bigEndianToInt(byArray, 32);
        this.xOff = Pack.bigEndianToInt(byArray, 36);
        for (int i4 = 0; i4 != this.xOff; ++i4) {
            this.X[i4] = Pack.bigEndianToInt(byArray, 40 + i4 * 4);
        }
    }

    private void copyIn(SHA1Digest sHA1Digest) {
        this.H1 = sHA1Digest.H1;
        this.H2 = sHA1Digest.H2;
        this.H3 = sHA1Digest.H3;
        this.H4 = sHA1Digest.H4;
        this.H5 = sHA1Digest.H5;
        System.arraycopy(sHA1Digest.X, 0, this.X, 0, sHA1Digest.X.length);
        this.xOff = sHA1Digest.xOff;
    }

    public String getAlgorithmName() {
        return "SHA-1";
    }

    public int getDigestSize() {
        return 20;
    }

    protected void processWord(byte[] byArray, int n4) {
        int n5 = byArray[n4] << 24;
        n5 |= (byArray[++n4] & 0xFF) << 16;
        n5 |= (byArray[++n4] & 0xFF) << 8;
        this.X[this.xOff] = n5 |= byArray[++n4] & 0xFF;
        if (++this.xOff == 16) {
            this.processBlock();
        }
    }

    protected void processLength(long l4) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)(l4 >>> 32);
        this.X[15] = (int)(l4 & 0xFFFFFFFFFFFFFFFFL);
    }

    public int doFinal(byte[] byArray, int n4) {
        this.finish();
        Pack.intToBigEndian(this.H1, byArray, n4);
        Pack.intToBigEndian(this.H2, byArray, n4 + 4);
        Pack.intToBigEndian(this.H3, byArray, n4 + 8);
        Pack.intToBigEndian(this.H4, byArray, n4 + 12);
        Pack.intToBigEndian(this.H5, byArray, n4 + 16);
        this.reset();
        return 20;
    }

    public void reset() {
        super.reset();
        this.H1 = 1732584193;
        this.H2 = -271733879;
        this.H3 = -1732584194;
        this.H4 = 271733878;
        this.H5 = -1009589776;
        this.xOff = 0;
        for (int i4 = 0; i4 != this.X.length; ++i4) {
            this.X[i4] = 0;
        }
    }

    private int f(int n4, int n5, int n6) {
        return n4 & n5 | ~n4 & n6;
    }

    private int h(int n4, int n5, int n6) {
        return n4 ^ n5 ^ n6;
    }

    private int g(int n4, int n5, int n6) {
        return n4 & n5 | n4 & n6 | n5 & n6;
    }

    protected void processBlock() {
        int n4;
        int n5;
        int n6;
        for (n6 = 16; n6 < 80; ++n6) {
            n5 = this.X[n6 - 3] ^ this.X[n6 - 8] ^ this.X[n6 - 14] ^ this.X[n6 - 16];
            this.X[n6] = n5 << 1 | n5 >>> 31;
        }
        n6 = this.H1;
        n5 = this.H2;
        int n7 = this.H3;
        int n8 = this.H4;
        int n9 = this.H5;
        int n10 = 0;
        for (n4 = 0; n4 < 4; ++n4) {
            n9 += (n6 << 5 | n6 >>> 27) + this.f(n5, n7, n8) + this.X[n10++] + 1518500249;
            n5 = n5 << 30 | n5 >>> 2;
            n8 += (n9 << 5 | n9 >>> 27) + this.f(n6, n5, n7) + this.X[n10++] + 1518500249;
            n6 = n6 << 30 | n6 >>> 2;
            n7 += (n8 << 5 | n8 >>> 27) + this.f(n9, n6, n5) + this.X[n10++] + 1518500249;
            n9 = n9 << 30 | n9 >>> 2;
            n5 += (n7 << 5 | n7 >>> 27) + this.f(n8, n9, n6) + this.X[n10++] + 1518500249;
            n8 = n8 << 30 | n8 >>> 2;
            n6 += (n5 << 5 | n5 >>> 27) + this.f(n7, n8, n9) + this.X[n10++] + 1518500249;
            n7 = n7 << 30 | n7 >>> 2;
        }
        for (n4 = 0; n4 < 4; ++n4) {
            n9 += (n6 << 5 | n6 >>> 27) + this.h(n5, n7, n8) + this.X[n10++] + 1859775393;
            n5 = n5 << 30 | n5 >>> 2;
            n8 += (n9 << 5 | n9 >>> 27) + this.h(n6, n5, n7) + this.X[n10++] + 1859775393;
            n6 = n6 << 30 | n6 >>> 2;
            n7 += (n8 << 5 | n8 >>> 27) + this.h(n9, n6, n5) + this.X[n10++] + 1859775393;
            n9 = n9 << 30 | n9 >>> 2;
            n5 += (n7 << 5 | n7 >>> 27) + this.h(n8, n9, n6) + this.X[n10++] + 1859775393;
            n8 = n8 << 30 | n8 >>> 2;
            n6 += (n5 << 5 | n5 >>> 27) + this.h(n7, n8, n9) + this.X[n10++] + 1859775393;
            n7 = n7 << 30 | n7 >>> 2;
        }
        for (n4 = 0; n4 < 4; ++n4) {
            n9 += (n6 << 5 | n6 >>> 27) + this.g(n5, n7, n8) + this.X[n10++] + -1894007588;
            n5 = n5 << 30 | n5 >>> 2;
            n8 += (n9 << 5 | n9 >>> 27) + this.g(n6, n5, n7) + this.X[n10++] + -1894007588;
            n6 = n6 << 30 | n6 >>> 2;
            n7 += (n8 << 5 | n8 >>> 27) + this.g(n9, n6, n5) + this.X[n10++] + -1894007588;
            n9 = n9 << 30 | n9 >>> 2;
            n5 += (n7 << 5 | n7 >>> 27) + this.g(n8, n9, n6) + this.X[n10++] + -1894007588;
            n8 = n8 << 30 | n8 >>> 2;
            n6 += (n5 << 5 | n5 >>> 27) + this.g(n7, n8, n9) + this.X[n10++] + -1894007588;
            n7 = n7 << 30 | n7 >>> 2;
        }
        for (n4 = 0; n4 <= 3; ++n4) {
            n9 += (n6 << 5 | n6 >>> 27) + this.h(n5, n7, n8) + this.X[n10++] + -899497514;
            n5 = n5 << 30 | n5 >>> 2;
            n8 += (n9 << 5 | n9 >>> 27) + this.h(n6, n5, n7) + this.X[n10++] + -899497514;
            n6 = n6 << 30 | n6 >>> 2;
            n7 += (n8 << 5 | n8 >>> 27) + this.h(n9, n6, n5) + this.X[n10++] + -899497514;
            n9 = n9 << 30 | n9 >>> 2;
            n5 += (n7 << 5 | n7 >>> 27) + this.h(n8, n9, n6) + this.X[n10++] + -899497514;
            n8 = n8 << 30 | n8 >>> 2;
            n6 += (n5 << 5 | n5 >>> 27) + this.h(n7, n8, n9) + this.X[n10++] + -899497514;
            n7 = n7 << 30 | n7 >>> 2;
        }
        this.H1 += n6;
        this.H2 += n5;
        this.H3 += n7;
        this.H4 += n8;
        this.H5 += n9;
        this.xOff = 0;
        for (n4 = 0; n4 < 16; ++n4) {
            this.X[n4] = 0;
        }
    }

    public Memoable copy() {
        return new SHA1Digest(this);
    }

    public void reset(Memoable memoable) {
        SHA1Digest sHA1Digest = (SHA1Digest)memoable;
        super.copyIn(sHA1Digest);
        this.copyIn(sHA1Digest);
    }

    public byte[] getEncodedState() {
        byte[] byArray = new byte[40 + this.xOff * 4];
        super.populateState(byArray);
        Pack.intToBigEndian(this.H1, byArray, 16);
        Pack.intToBigEndian(this.H2, byArray, 20);
        Pack.intToBigEndian(this.H3, byArray, 24);
        Pack.intToBigEndian(this.H4, byArray, 28);
        Pack.intToBigEndian(this.H5, byArray, 32);
        Pack.intToBigEndian(this.xOff, byArray, 36);
        for (int i4 = 0; i4 != this.xOff; ++i4) {
            Pack.intToBigEndian(this.X[i4], byArray, 40 + i4 * 4);
        }
        return byArray;
    }
}

