/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.util.Pack;

public class ChaChaEngine
extends Salsa20Engine {
    public ChaChaEngine() {
    }

    public ChaChaEngine(int n4) {
        super(n4);
    }

    public String getAlgorithmName() {
        return "ChaCha" + this.rounds;
    }

    protected void advanceCounter(long l4) {
        int n4 = (int)(l4 >>> 32);
        int n5 = (int)l4;
        if (n4 > 0) {
            this.engineState[13] = this.engineState[13] + n4;
        }
        int n6 = this.engineState[12];
        this.engineState[12] = this.engineState[12] + n5;
        if (n6 != 0 && this.engineState[12] < n6) {
            this.engineState[13] = this.engineState[13] + 1;
        }
    }

    protected void advanceCounter() {
        this.engineState[12] = this.engineState[12] + 1;
        if (this.engineState[12] == 0) {
            this.engineState[13] = this.engineState[13] + 1;
        }
    }

    protected void retreatCounter(long l4) {
        int n4 = (int)(l4 >>> 32);
        int n5 = (int)l4;
        if (n4 != 0) {
            if (((long)this.engineState[13] & 0xFFFFFFFFL) >= ((long)n4 & 0xFFFFFFFFL)) {
                this.engineState[13] = this.engineState[13] - n4;
            } else {
                throw new IllegalStateException("attempt to reduce counter past zero.");
            }
        }
        if (((long)this.engineState[12] & 0xFFFFFFFFL) >= ((long)n5 & 0xFFFFFFFFL)) {
            this.engineState[12] = this.engineState[12] - n5;
        } else if (this.engineState[13] != 0) {
            this.engineState[13] = this.engineState[13] - 1;
            this.engineState[12] = this.engineState[12] - n5;
        } else {
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
    }

    protected void retreatCounter() {
        if (this.engineState[12] == 0 && this.engineState[13] == 0) {
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
        this.engineState[12] = this.engineState[12] - 1;
        if (this.engineState[12] == -1) {
            this.engineState[13] = this.engineState[13] - 1;
        }
    }

    protected long getCounter() {
        return (long)this.engineState[13] << 32 | (long)this.engineState[12] & 0xFFFFFFFFL;
    }

    protected void resetCounter() {
        this.engineState[13] = 0;
        this.engineState[12] = 0;
    }

    protected void setKey(byte[] byArray, byte[] byArray2) {
        if (byArray != null) {
            if (byArray.length != 16 && byArray.length != 32) {
                throw new IllegalArgumentException(this.getAlgorithmName() + " requires 128 bit or 256 bit key");
            }
            this.packTauOrSigma(byArray.length, this.engineState, 0);
            Pack.littleEndianToInt(byArray, 0, this.engineState, 4, 4);
            Pack.littleEndianToInt(byArray, byArray.length - 16, this.engineState, 8, 4);
        }
        Pack.littleEndianToInt(byArray2, 0, this.engineState, 14, 2);
    }

    protected void generateKeyStream(byte[] byArray) {
        ChaChaEngine.chachaCore(this.rounds, this.engineState, this.x);
        Pack.intToLittleEndian(this.x, byArray, 0);
    }

    public static void chachaCore(int n4, int[] nArray, int[] nArray2) {
        if (nArray.length != 16) {
            throw new IllegalArgumentException();
        }
        if (nArray2.length != 16) {
            throw new IllegalArgumentException();
        }
        if (n4 % 2 != 0) {
            throw new IllegalArgumentException("Number of rounds must be even");
        }
        int n5 = nArray[0];
        int n6 = nArray[1];
        int n7 = nArray[2];
        int n8 = nArray[3];
        int n9 = nArray[4];
        int n10 = nArray[5];
        int n11 = nArray[6];
        int n12 = nArray[7];
        int n13 = nArray[8];
        int n14 = nArray[9];
        int n15 = nArray[10];
        int n16 = nArray[11];
        int n17 = nArray[12];
        int n18 = nArray[13];
        int n19 = nArray[14];
        int n20 = nArray[15];
        for (int i4 = n4; i4 > 0; i4 -= 2) {
            n17 = ChaChaEngine.rotl(n17 ^ (n5 += n9), 16);
            n9 = ChaChaEngine.rotl(n9 ^ (n13 += n17), 12);
            n17 = ChaChaEngine.rotl(n17 ^ (n5 += n9), 8);
            n9 = ChaChaEngine.rotl(n9 ^ (n13 += n17), 7);
            n18 = ChaChaEngine.rotl(n18 ^ (n6 += n10), 16);
            n10 = ChaChaEngine.rotl(n10 ^ (n14 += n18), 12);
            n18 = ChaChaEngine.rotl(n18 ^ (n6 += n10), 8);
            n10 = ChaChaEngine.rotl(n10 ^ (n14 += n18), 7);
            n19 = ChaChaEngine.rotl(n19 ^ (n7 += n11), 16);
            n11 = ChaChaEngine.rotl(n11 ^ (n15 += n19), 12);
            n19 = ChaChaEngine.rotl(n19 ^ (n7 += n11), 8);
            n11 = ChaChaEngine.rotl(n11 ^ (n15 += n19), 7);
            n20 = ChaChaEngine.rotl(n20 ^ (n8 += n12), 16);
            n12 = ChaChaEngine.rotl(n12 ^ (n16 += n20), 12);
            n20 = ChaChaEngine.rotl(n20 ^ (n8 += n12), 8);
            n12 = ChaChaEngine.rotl(n12 ^ (n16 += n20), 7);
            n20 = ChaChaEngine.rotl(n20 ^ (n5 += n10), 16);
            n10 = ChaChaEngine.rotl(n10 ^ (n15 += n20), 12);
            n20 = ChaChaEngine.rotl(n20 ^ (n5 += n10), 8);
            n10 = ChaChaEngine.rotl(n10 ^ (n15 += n20), 7);
            n17 = ChaChaEngine.rotl(n17 ^ (n6 += n11), 16);
            n11 = ChaChaEngine.rotl(n11 ^ (n16 += n17), 12);
            n17 = ChaChaEngine.rotl(n17 ^ (n6 += n11), 8);
            n11 = ChaChaEngine.rotl(n11 ^ (n16 += n17), 7);
            n18 = ChaChaEngine.rotl(n18 ^ (n7 += n12), 16);
            n12 = ChaChaEngine.rotl(n12 ^ (n13 += n18), 12);
            n18 = ChaChaEngine.rotl(n18 ^ (n7 += n12), 8);
            n12 = ChaChaEngine.rotl(n12 ^ (n13 += n18), 7);
            n19 = ChaChaEngine.rotl(n19 ^ (n8 += n9), 16);
            n9 = ChaChaEngine.rotl(n9 ^ (n14 += n19), 12);
            n19 = ChaChaEngine.rotl(n19 ^ (n8 += n9), 8);
            n9 = ChaChaEngine.rotl(n9 ^ (n14 += n19), 7);
        }
        nArray2[0] = n5 + nArray[0];
        nArray2[1] = n6 + nArray[1];
        nArray2[2] = n7 + nArray[2];
        nArray2[3] = n8 + nArray[3];
        nArray2[4] = n9 + nArray[4];
        nArray2[5] = n10 + nArray[5];
        nArray2[6] = n11 + nArray[6];
        nArray2[7] = n12 + nArray[7];
        nArray2[8] = n13 + nArray[8];
        nArray2[9] = n14 + nArray[9];
        nArray2[10] = n15 + nArray[10];
        nArray2[11] = n16 + nArray[11];
        nArray2[12] = n17 + nArray[12];
        nArray2[13] = n18 + nArray[13];
        nArray2[14] = n19 + nArray[14];
        nArray2[15] = n20 + nArray[15];
    }
}

