/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;

public class RC4Engine
implements StreamCipher {
    private static final int STATE_LENGTH = 256;
    private byte[] engineState = null;
    private int x = 0;
    private int y = 0;
    private byte[] workingKey = null;

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.workingKey = ((KeyParameter)cipherParameters).getKey();
            this.setKey(this.workingKey);
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to RC4 init - " + cipherParameters.getClass().getName());
    }

    public String getAlgorithmName() {
        return "RC4";
    }

    public byte returnByte(byte by) {
        this.x = this.x + 1 & 0xFF;
        this.y = this.engineState[this.x] + this.y & 0xFF;
        byte by2 = this.engineState[this.x];
        this.engineState[this.x] = this.engineState[this.y];
        this.engineState[this.y] = by2;
        return (byte)(by ^ this.engineState[this.engineState[this.x] + this.engineState[this.y] & 0xFF]);
    }

    public int processBytes(byte[] byArray, int n4, int n5, byte[] byArray2, int n6) {
        if (n4 + n5 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n6 + n5 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i4 = 0; i4 < n5; ++i4) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.engineState[this.x] + this.y & 0xFF;
            byte by = this.engineState[this.x];
            this.engineState[this.x] = this.engineState[this.y];
            this.engineState[this.y] = by;
            byArray2[i4 + n6] = (byte)(byArray[i4 + n4] ^ this.engineState[this.engineState[this.x] + this.engineState[this.y] & 0xFF]);
        }
        return n5;
    }

    public void reset() {
        this.setKey(this.workingKey);
    }

    private void setKey(byte[] byArray) {
        int n4;
        this.workingKey = byArray;
        this.x = 0;
        this.y = 0;
        if (this.engineState == null) {
            this.engineState = new byte[256];
        }
        for (n4 = 0; n4 < 256; ++n4) {
            this.engineState[n4] = (byte)n4;
        }
        n4 = 0;
        int n5 = 0;
        for (int i4 = 0; i4 < 256; ++i4) {
            n5 = (byArray[n4] & 0xFF) + this.engineState[i4] + n5 & 0xFF;
            byte by = this.engineState[i4];
            this.engineState[i4] = this.engineState[n5];
            this.engineState[n5] = by;
            n4 = (n4 + 1) % byArray.length;
        }
    }
}

