/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.MGFParameters;

public class MGF1BytesGenerator
implements DerivationFunction {
    private Digest digest;
    private byte[] seed;
    private int hLen;

    public MGF1BytesGenerator(Digest digest) {
        this.digest = digest;
        this.hLen = digest.getDigestSize();
    }

    public void init(DerivationParameters derivationParameters) {
        if (!(derivationParameters instanceof MGFParameters)) {
            throw new IllegalArgumentException("MGF parameters required for MGF1Generator");
        }
        MGFParameters mGFParameters = (MGFParameters)derivationParameters;
        this.seed = mGFParameters.getSeed();
    }

    public Digest getDigest() {
        return this.digest;
    }

    private void ItoOSP(int n4, byte[] byArray) {
        byArray[0] = (byte)(n4 >>> 24);
        byArray[1] = (byte)(n4 >>> 16);
        byArray[2] = (byte)(n4 >>> 8);
        byArray[3] = (byte)(n4 >>> 0);
    }

    public int generateBytes(byte[] byArray, int n4, int n5) throws DataLengthException, IllegalArgumentException {
        if (byArray.length - n5 < n4) {
            throw new DataLengthException("output buffer too small");
        }
        byte[] byArray2 = new byte[this.hLen];
        byte[] byArray3 = new byte[4];
        int n6 = 0;
        this.digest.reset();
        if (n5 > this.hLen) {
            do {
                this.ItoOSP(n6, byArray3);
                this.digest.update(this.seed, 0, this.seed.length);
                this.digest.update(byArray3, 0, byArray3.length);
                this.digest.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n4 + n6 * this.hLen, this.hLen);
            } while (++n6 < n5 / this.hLen);
        }
        if (n6 * this.hLen < n5) {
            this.ItoOSP(n6, byArray3);
            this.digest.update(this.seed, 0, this.seed.length);
            this.digest.update(byArray3, 0, byArray3.length);
            this.digest.doFinal(byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n4 + n6 * this.hLen, n5 - n6 * this.hLen);
        }
        return n5;
    }
}

