/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class PGPCFBBlockCipher
implements BlockCipher {
    private byte[] IV;
    private byte[] FR;
    private byte[] FRE;
    private byte[] tmp;
    private BlockCipher cipher;
    private int count;
    private int blockSize;
    private boolean forEncryption;
    private boolean inlineIv;

    public PGPCFBBlockCipher(BlockCipher blockCipher, boolean bl) {
        this.cipher = blockCipher;
        this.inlineIv = bl;
        this.blockSize = blockCipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.FR = new byte[this.blockSize];
        this.FRE = new byte[this.blockSize];
        this.tmp = new byte[this.blockSize];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public String getAlgorithmName() {
        if (this.inlineIv) {
            return this.cipher.getAlgorithmName() + "/PGPCFBwithIV";
        }
        return this.cipher.getAlgorithmName() + "/PGPCFB";
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public int processBlock(byte[] byArray, int n4, byte[] byArray2, int n5) throws DataLengthException, IllegalStateException {
        if (this.inlineIv) {
            return this.forEncryption ? this.encryptBlockWithIV(byArray, n4, byArray2, n5) : this.decryptBlockWithIV(byArray, n4, byArray2, n5);
        }
        return this.forEncryption ? this.encryptBlock(byArray, n4, byArray2, n5) : this.decryptBlock(byArray, n4, byArray2, n5);
    }

    public void reset() {
        this.count = 0;
        for (int i4 = 0; i4 != this.FR.length; ++i4) {
            this.FR[i4] = this.inlineIv ? (byte)0 : this.IV[i4];
        }
        this.cipher.reset();
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.forEncryption = bl;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.IV.length) {
                System.arraycopy(byArray, 0, this.IV, this.IV.length - byArray.length, byArray.length);
                for (int i4 = 0; i4 < this.IV.length - byArray.length; ++i4) {
                    this.IV[i4] = 0;
                }
            } else {
                System.arraycopy(byArray, 0, this.IV, 0, this.IV.length);
            }
            this.reset();
            this.cipher.init(true, parametersWithIV.getParameters());
        } else {
            this.reset();
            this.cipher.init(true, cipherParameters);
        }
    }

    private byte encryptByte(byte by, int n4) {
        return (byte)(this.FRE[n4] ^ by);
    }

    private int encryptBlockWithIV(byte[] byArray, int n4, byte[] byArray2, int n5) throws DataLengthException, IllegalStateException {
        if (n4 + this.blockSize > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (this.count == 0) {
            int n6;
            if (n5 + 2 * this.blockSize + 2 > byArray2.length) {
                throw new DataLengthException("output buffer too short");
            }
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            for (n6 = 0; n6 < this.blockSize; ++n6) {
                byArray2[n5 + n6] = this.encryptByte(this.IV[n6], n6);
            }
            System.arraycopy(byArray2, n5, this.FR, 0, this.blockSize);
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            byArray2[n5 + this.blockSize] = this.encryptByte(this.IV[this.blockSize - 2], 0);
            byArray2[n5 + this.blockSize + 1] = this.encryptByte(this.IV[this.blockSize - 1], 1);
            System.arraycopy(byArray2, n5 + 2, this.FR, 0, this.blockSize);
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            for (n6 = 0; n6 < this.blockSize; ++n6) {
                byArray2[n5 + this.blockSize + 2 + n6] = this.encryptByte(byArray[n4 + n6], n6);
            }
            System.arraycopy(byArray2, n5 + this.blockSize + 2, this.FR, 0, this.blockSize);
            this.count += 2 * this.blockSize + 2;
            return 2 * this.blockSize + 2;
        }
        if (this.count >= this.blockSize + 2) {
            if (n5 + this.blockSize > byArray2.length) {
                throw new DataLengthException("output buffer too short");
            }
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            for (int i4 = 0; i4 < this.blockSize; ++i4) {
                byArray2[n5 + i4] = this.encryptByte(byArray[n4 + i4], i4);
            }
            System.arraycopy(byArray2, n5, this.FR, 0, this.blockSize);
        }
        return this.blockSize;
    }

    private int decryptBlockWithIV(byte[] byArray, int n4, byte[] byArray2, int n5) throws DataLengthException, IllegalStateException {
        if (n4 + this.blockSize > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n5 + this.blockSize > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this.count == 0) {
            for (int i4 = 0; i4 < this.blockSize; ++i4) {
                this.FR[i4] = byArray[n4 + i4];
            }
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            this.count += this.blockSize;
            return 0;
        }
        if (this.count == this.blockSize) {
            System.arraycopy(byArray, n4, this.tmp, 0, this.blockSize);
            System.arraycopy(this.FR, 2, this.FR, 0, this.blockSize - 2);
            this.FR[this.blockSize - 2] = this.tmp[0];
            this.FR[this.blockSize - 1] = this.tmp[1];
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            for (int i5 = 0; i5 < this.blockSize - 2; ++i5) {
                byArray2[n5 + i5] = this.encryptByte(this.tmp[i5 + 2], i5);
            }
            System.arraycopy(this.tmp, 2, this.FR, 0, this.blockSize - 2);
            this.count += 2;
            return this.blockSize - 2;
        }
        if (this.count >= this.blockSize + 2) {
            System.arraycopy(byArray, n4, this.tmp, 0, this.blockSize);
            byArray2[n5 + 0] = this.encryptByte(this.tmp[0], this.blockSize - 2);
            byArray2[n5 + 1] = this.encryptByte(this.tmp[1], this.blockSize - 1);
            System.arraycopy(this.tmp, 0, this.FR, this.blockSize - 2, 2);
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            for (int i6 = 0; i6 < this.blockSize - 2; ++i6) {
                byArray2[n5 + i6 + 2] = this.encryptByte(this.tmp[i6 + 2], i6);
            }
            System.arraycopy(this.tmp, 2, this.FR, 0, this.blockSize - 2);
        }
        return this.blockSize;
    }

    private int encryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) throws DataLengthException, IllegalStateException {
        int n6;
        if (n4 + this.blockSize > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n5 + this.blockSize > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        this.cipher.processBlock(this.FR, 0, this.FRE, 0);
        for (n6 = 0; n6 < this.blockSize; ++n6) {
            byArray2[n5 + n6] = this.encryptByte(byArray[n4 + n6], n6);
        }
        for (n6 = 0; n6 < this.blockSize; ++n6) {
            this.FR[n6] = byArray2[n5 + n6];
        }
        return this.blockSize;
    }

    private int decryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) throws DataLengthException, IllegalStateException {
        int n6;
        if (n4 + this.blockSize > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n5 + this.blockSize > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        this.cipher.processBlock(this.FR, 0, this.FRE, 0);
        for (n6 = 0; n6 < this.blockSize; ++n6) {
            byArray2[n5 + n6] = this.encryptByte(byArray[n4 + n6], n6);
        }
        for (n6 = 0; n6 < this.blockSize; ++n6) {
            this.FR[n6] = byArray[n4 + n6];
        }
        return this.blockSize;
    }
}

