/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.paddings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;

public class ISO7816d4Padding
implements BlockCipherPadding {
    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
    }

    public String getPaddingName() {
        return "ISO7816-4";
    }

    public int addPadding(byte[] byArray, int n4) {
        int n5 = byArray.length - n4;
        byArray[n4] = -128;
        ++n4;
        while (n4 < byArray.length) {
            byArray[n4] = 0;
            ++n4;
        }
        return n5;
    }

    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        int n4;
        for (n4 = byArray.length - 1; n4 > 0 && byArray[n4] == 0; --n4) {
        }
        if (byArray[n4] != -128) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return byArray.length - n4;
    }
}

