/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.paddings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;

public class X923Padding
implements BlockCipherPadding {
    SecureRandom random = null;

    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
        this.random = secureRandom;
    }

    public String getPaddingName() {
        return "X9.23";
    }

    public int addPadding(byte[] byArray, int n4) {
        byte by = (byte)(byArray.length - n4);
        while (n4 < byArray.length - 1) {
            byArray[n4] = this.random == null ? (byte)0 : (byte)this.random.nextInt();
            ++n4;
        }
        byArray[n4] = by;
        return by;
    }

    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        int n4 = byArray[byArray.length - 1] & 0xFF;
        if (n4 > byArray.length) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return n4;
    }
}

