/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.prng.drbg;

import java.util.Hashtable;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.util.Integers;

class Utils {
    static final Hashtable maxSecurityStrengths = new Hashtable();

    Utils() {
    }

    static int getMaxSecurityStrength(Digest digest) {
        return (Integer)maxSecurityStrengths.get(digest.getAlgorithmName());
    }

    static int getMaxSecurityStrength(Mac mac) {
        String string = mac.getAlgorithmName();
        return (Integer)maxSecurityStrengths.get(string.substring(0, string.indexOf("/")));
    }

    static byte[] hash_df(Digest digest, byte[] byArray, int n4) {
        int n5;
        int n6;
        byte[] byArray2 = new byte[(n4 + 7) / 8];
        int n7 = byArray2.length / digest.getDigestSize();
        int n8 = 1;
        byte[] byArray3 = new byte[digest.getDigestSize()];
        for (n6 = 0; n6 <= n7; ++n6) {
            digest.update((byte)n8);
            digest.update((byte)(n4 >> 24));
            digest.update((byte)(n4 >> 16));
            digest.update((byte)(n4 >> 8));
            digest.update((byte)n4);
            digest.update(byArray, 0, byArray.length);
            digest.doFinal(byArray3, 0);
            n5 = byArray2.length - n6 * byArray3.length > byArray3.length ? byArray3.length : byArray2.length - n6 * byArray3.length;
            System.arraycopy(byArray3, 0, byArray2, n6 * byArray3.length, n5);
            ++n8;
        }
        if (n4 % 8 != 0) {
            n6 = 8 - n4 % 8;
            n5 = 0;
            for (int i4 = 0; i4 != byArray2.length; ++i4) {
                int n9 = byArray2[i4] & 0xFF;
                byArray2[i4] = (byte)(n9 >>> n6 | n5 << 8 - n6);
                n5 = n9;
            }
        }
        return byArray2;
    }

    static boolean isTooLarge(byte[] byArray, int n4) {
        return byArray != null && byArray.length > n4;
    }

    static {
        maxSecurityStrengths.put("SHA-1", Integers.valueOf(128));
        maxSecurityStrengths.put("SHA-224", Integers.valueOf(192));
        maxSecurityStrengths.put("SHA-256", Integers.valueOf(256));
        maxSecurityStrengths.put("SHA-384", Integers.valueOf(256));
        maxSecurityStrengths.put("SHA-512", Integers.valueOf(256));
        maxSecurityStrengths.put("SHA-512/224", Integers.valueOf(192));
        maxSecurityStrengths.put("SHA-512/256", Integers.valueOf(256));
    }
}

