/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.tls.SSL3Mac;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsHandshakeHash;
import org.bouncycastle.crypto.tls.TlsUtils;

class CombinedHash
implements TlsHandshakeHash {
    protected TlsContext context;
    protected Digest md5;
    protected Digest sha1;

    CombinedHash() {
        this.md5 = TlsUtils.createHash((short)1);
        this.sha1 = TlsUtils.createHash((short)2);
    }

    CombinedHash(CombinedHash combinedHash) {
        this.context = combinedHash.context;
        this.md5 = TlsUtils.cloneHash((short)1, combinedHash.md5);
        this.sha1 = TlsUtils.cloneHash((short)2, combinedHash.sha1);
    }

    public void init(TlsContext tlsContext) {
        this.context = tlsContext;
    }

    public TlsHandshakeHash notifyPRFDetermined() {
        return this;
    }

    public void trackHashAlgorithm(short s4) {
        throw new IllegalStateException("CombinedHash only supports calculating the legacy PRF for handshake hash");
    }

    public void sealHashAlgorithms() {
    }

    public TlsHandshakeHash stopTracking() {
        return new CombinedHash(this);
    }

    public Digest forkPRFHash() {
        return new CombinedHash(this);
    }

    public byte[] getFinalHash(short s4) {
        throw new IllegalStateException("CombinedHash doesn't support multiple hashes");
    }

    public String getAlgorithmName() {
        return this.md5.getAlgorithmName() + " and " + this.sha1.getAlgorithmName();
    }

    public int getDigestSize() {
        return this.md5.getDigestSize() + this.sha1.getDigestSize();
    }

    public void update(byte by) {
        this.md5.update(by);
        this.sha1.update(by);
    }

    public void update(byte[] byArray, int n4, int n5) {
        this.md5.update(byArray, n4, n5);
        this.sha1.update(byArray, n4, n5);
    }

    public int doFinal(byte[] byArray, int n4) {
        if (this.context != null && TlsUtils.isSSL(this.context)) {
            this.ssl3Complete(this.md5, SSL3Mac.IPAD, SSL3Mac.OPAD, 48);
            this.ssl3Complete(this.sha1, SSL3Mac.IPAD, SSL3Mac.OPAD, 40);
        }
        int n5 = this.md5.doFinal(byArray, n4);
        int n6 = this.sha1.doFinal(byArray, n4 + n5);
        return n5 + n6;
    }

    public void reset() {
        this.md5.reset();
        this.sha1.reset();
    }

    protected void ssl3Complete(Digest digest, byte[] byArray, byte[] byArray2, int n4) {
        byte[] byArray3 = this.context.getSecurityParameters().masterSecret;
        digest.update(byArray3, 0, byArray3.length);
        digest.update(byArray, 0, n4);
        byte[] byArray4 = new byte[digest.getDigestSize()];
        digest.doFinal(byArray4, 0);
        digest.update(byArray3, 0, byArray3.length);
        digest.update(byArray2, 0, n4);
        digest.update(byArray4, 0, byArray4.length);
    }
}

