/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.KDFParameters;

public class BrokenKDF2BytesGenerator
implements DerivationFunction {
    private Digest digest;
    private byte[] shared;
    private byte[] iv;

    public BrokenKDF2BytesGenerator(Digest digest) {
        this.digest = digest;
    }

    public void init(DerivationParameters derivationParameters) {
        if (!(derivationParameters instanceof KDFParameters)) {
            throw new IllegalArgumentException("KDF parameters required for generator");
        }
        KDFParameters kDFParameters = (KDFParameters)derivationParameters;
        this.shared = kDFParameters.getSharedSecret();
        this.iv = kDFParameters.getIV();
    }

    public Digest getDigest() {
        return this.digest;
    }

    public int generateBytes(byte[] byArray, int n4, int n5) throws DataLengthException, IllegalArgumentException {
        if (byArray.length - n5 < n4) {
            throw new DataLengthException("output buffer too small");
        }
        long l4 = n5 * 8;
        if (l4 > (long)(this.digest.getDigestSize() * 8) * 29L) {
            new IllegalArgumentException("Output length to large");
        }
        int n6 = (int)(l4 / (long)this.digest.getDigestSize());
        byte[] byArray2 = null;
        byArray2 = new byte[this.digest.getDigestSize()];
        for (int i4 = 1; i4 <= n6; ++i4) {
            this.digest.update(this.shared, 0, this.shared.length);
            this.digest.update((byte)(i4 & 0xFF));
            this.digest.update((byte)(i4 >> 8 & 0xFF));
            this.digest.update((byte)(i4 >> 16 & 0xFF));
            this.digest.update((byte)(i4 >> 24 & 0xFF));
            this.digest.update(this.iv, 0, this.iv.length);
            this.digest.doFinal(byArray2, 0);
            if (n5 - n4 > byArray2.length) {
                System.arraycopy(byArray2, 0, byArray, n4, byArray2.length);
                n4 += byArray2.length;
                continue;
            }
            System.arraycopy(byArray2, 0, byArray, n4, n5 - n4);
        }
        this.digest.reset();
        return n5;
    }
}

