/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.tools;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.util.Integers;

public class TraceOptimizer {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final SecureRandom R = new SecureRandom();

    public static void main(String[] stringArray) {
        TreeSet treeSet = new TreeSet(TraceOptimizer.enumToList(ECNamedCurveTable.getNames()));
        treeSet.addAll(TraceOptimizer.enumToList(CustomNamedCurves.getNames()));
        for (String string : treeSet) {
            X9ECParameters x9ECParameters = CustomNamedCurves.getByName(string);
            if (x9ECParameters == null) {
                x9ECParameters = ECNamedCurveTable.getByName(string);
            }
            if (x9ECParameters == null || !ECAlgorithms.isF2mCurve(x9ECParameters.getCurve())) continue;
            System.out.print(string + ":");
            TraceOptimizer.implPrintNonZeroTraceBits(x9ECParameters);
        }
    }

    public static void printNonZeroTraceBits(X9ECParameters x9ECParameters) {
        if (!ECAlgorithms.isF2mCurve(x9ECParameters.getCurve())) {
            throw new IllegalArgumentException("Trace only defined over characteristic-2 fields");
        }
        TraceOptimizer.implPrintNonZeroTraceBits(x9ECParameters);
    }

    public static void implPrintNonZeroTraceBits(X9ECParameters x9ECParameters) {
        int n4;
        ECFieldElement eCFieldElement;
        BigInteger bigInteger;
        int n5;
        ECCurve eCCurve = x9ECParameters.getCurve();
        int n6 = eCCurve.getFieldSize();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n5 = 0; n5 < n6; ++n5) {
            bigInteger = ONE.shiftLeft(n5);
            eCFieldElement = eCCurve.fromBigInteger(bigInteger);
            n4 = TraceOptimizer.calculateTrace(eCFieldElement);
            if (n4 == 0) continue;
            arrayList.add(Integers.valueOf(n5));
            System.out.print(" " + n5);
        }
        System.out.println();
        for (n5 = 0; n5 < 1000; ++n5) {
            bigInteger = new BigInteger(n6, R);
            eCFieldElement = eCCurve.fromBigInteger(bigInteger);
            n4 = TraceOptimizer.calculateTrace(eCFieldElement);
            int n7 = 0;
            for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                int n8 = (Integer)arrayList.get(i4);
                if (!bigInteger.testBit(n8)) continue;
                n7 ^= 1;
            }
            if (n4 == n7) continue;
            throw new IllegalStateException("Optimized-trace sanity check failed");
        }
    }

    private static int calculateTrace(ECFieldElement eCFieldElement) {
        int n4 = eCFieldElement.getFieldSize();
        ECFieldElement eCFieldElement2 = eCFieldElement;
        for (int i4 = 1; i4 < n4; ++i4) {
            eCFieldElement = eCFieldElement.square();
            eCFieldElement2 = eCFieldElement2.add(eCFieldElement);
        }
        BigInteger bigInteger = eCFieldElement2.toBigInteger();
        if (bigInteger.bitLength() > 1) {
            throw new IllegalStateException();
        }
        return bigInteger.intValue();
    }

    private static ArrayList enumToList(Enumeration enumeration) {
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }
}

