/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.gmss.util;

public class GMSSUtil {
    public byte[] intToBytesLittleEndian(int n4) {
        byte[] byArray = new byte[]{(byte)(n4 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n4 >> 16 & 0xFF), (byte)(n4 >> 24 & 0xFF)};
        return byArray;
    }

    public int bytesToIntLittleEndian(byte[] byArray) {
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
    }

    public int bytesToIntLittleEndian(byte[] byArray, int n4) {
        return byArray[n4++] & 0xFF | (byArray[n4++] & 0xFF) << 8 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4] & 0xFF) << 24;
    }

    public byte[] concatenateArray(byte[][] byArray) {
        byte[] byArray2 = new byte[byArray.length * byArray[0].length];
        int n4 = 0;
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            System.arraycopy(byArray[i4], 0, byArray2, n4, byArray[i4].length);
            n4 += byArray[i4].length;
        }
        return byArray2;
    }

    public void printArray(String string, byte[][] byArray) {
        System.out.println(string);
        int n4 = 0;
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            for (int i5 = 0; i5 < byArray[0].length; ++i5) {
                System.out.println(n4 + "; " + byArray[i4][i5]);
                ++n4;
            }
        }
    }

    public void printArray(String string, byte[] byArray) {
        System.out.println(string);
        int n4 = 0;
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            System.out.println(n4 + "; " + byArray[i4]);
            ++n4;
        }
    }

    public boolean testPowerOfTwo(int n4) {
        int n5;
        for (n5 = 1; n5 < n4; n5 <<= 1) {
        }
        return n4 == n5;
    }

    public int getLog(int n4) {
        int n5 = 1;
        int n6 = 2;
        while (n6 < n4) {
            n6 <<= 1;
            ++n5;
        }
        return n5;
    }
}

