/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.math.BigInteger;

public final class BigIntUtils {
    private BigIntUtils() {
    }

    public static boolean equals(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        int n4 = 0;
        if (bigIntegerArray.length != bigIntegerArray2.length) {
            return false;
        }
        for (int i4 = 0; i4 < bigIntegerArray.length; ++i4) {
            n4 |= bigIntegerArray[i4].compareTo(bigIntegerArray2[i4]);
        }
        return n4 == 0;
    }

    public static void fill(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        for (int i4 = bigIntegerArray.length - 1; i4 >= 0; --i4) {
            bigIntegerArray[i4] = bigInteger;
        }
    }

    public static BigInteger[] subArray(BigInteger[] bigIntegerArray, int n4, int n5) {
        BigInteger[] bigIntegerArray2 = new BigInteger[n5 - n4];
        System.arraycopy(bigIntegerArray, n4, bigIntegerArray2, 0, n5 - n4);
        return bigIntegerArray2;
    }

    public static int[] toIntArray(BigInteger[] bigIntegerArray) {
        int[] nArray = new int[bigIntegerArray.length];
        for (int i4 = 0; i4 < bigIntegerArray.length; ++i4) {
            nArray[i4] = bigIntegerArray[i4].intValue();
        }
        return nArray;
    }

    public static int[] toIntArrayModQ(int n4, BigInteger[] bigIntegerArray) {
        BigInteger bigInteger = BigInteger.valueOf(n4);
        int[] nArray = new int[bigIntegerArray.length];
        for (int i4 = 0; i4 < bigIntegerArray.length; ++i4) {
            nArray[i4] = bigIntegerArray[i4].mod(bigInteger).intValue();
        }
        return nArray;
    }

    public static byte[] toMinimalByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == 1 || (bigInteger.bitLength() & 7) != 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[bigInteger.bitLength() >> 3];
        System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        return byArray2;
    }
}

