/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

public final class LittleEndianConversions {
    private LittleEndianConversions() {
    }

    public static int OS2IP(byte[] byArray) {
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
    }

    public static int OS2IP(byte[] byArray, int n4) {
        int n5 = byArray[n4++] & 0xFF;
        n5 |= (byArray[n4++] & 0xFF) << 8;
        n5 |= (byArray[n4++] & 0xFF) << 16;
        return n5 |= (byArray[n4] & 0xFF) << 24;
    }

    public static int OS2IP(byte[] byArray, int n4, int n5) {
        int n6 = 0;
        for (int i4 = n5 - 1; i4 >= 0; --i4) {
            n6 |= (byArray[n4 + i4] & 0xFF) << 8 * i4;
        }
        return n6;
    }

    public static long OS2LIP(byte[] byArray, int n4) {
        long l4 = byArray[n4++] & 0xFF;
        l4 |= (long)((byArray[n4++] & 0xFF) << 8);
        l4 |= (long)((byArray[n4++] & 0xFF) << 16);
        l4 |= ((long)byArray[n4++] & 0xFFL) << 24;
        l4 |= ((long)byArray[n4++] & 0xFFL) << 32;
        l4 |= ((long)byArray[n4++] & 0xFFL) << 40;
        l4 |= ((long)byArray[n4++] & 0xFFL) << 48;
        return l4 |= ((long)byArray[n4++] & 0xFFL) << 56;
    }

    public static byte[] I2OSP(int n4) {
        byte[] byArray = new byte[]{(byte)n4, (byte)(n4 >>> 8), (byte)(n4 >>> 16), (byte)(n4 >>> 24)};
        return byArray;
    }

    public static void I2OSP(int n4, byte[] byArray, int n5) {
        byArray[n5++] = (byte)n4;
        byArray[n5++] = (byte)(n4 >>> 8);
        byArray[n5++] = (byte)(n4 >>> 16);
        byArray[n5++] = (byte)(n4 >>> 24);
    }

    public static void I2OSP(int n4, byte[] byArray, int n5, int n6) {
        for (int i4 = n6 - 1; i4 >= 0; --i4) {
            byArray[n5 + i4] = (byte)(n4 >>> 8 * i4);
        }
    }

    public static byte[] I2OSP(long l4) {
        byte[] byArray = new byte[]{(byte)l4, (byte)(l4 >>> 8), (byte)(l4 >>> 16), (byte)(l4 >>> 24), (byte)(l4 >>> 32), (byte)(l4 >>> 40), (byte)(l4 >>> 48), (byte)(l4 >>> 56)};
        return byArray;
    }

    public static void I2OSP(long l4, byte[] byArray, int n4) {
        byArray[n4++] = (byte)l4;
        byArray[n4++] = (byte)(l4 >>> 8);
        byArray[n4++] = (byte)(l4 >>> 16);
        byArray[n4++] = (byte)(l4 >>> 24);
        byArray[n4++] = (byte)(l4 >>> 32);
        byArray[n4++] = (byte)(l4 >>> 40);
        byArray[n4++] = (byte)(l4 >>> 48);
        byArray[n4] = (byte)(l4 >>> 56);
    }

    public static byte[] toByteArray(int[] nArray, int n4) {
        int n5 = nArray.length;
        byte[] byArray = new byte[n4];
        int n6 = 0;
        int n7 = 0;
        while (n7 <= n5 - 2) {
            LittleEndianConversions.I2OSP(nArray[n7], byArray, n6);
            ++n7;
            n6 += 4;
        }
        LittleEndianConversions.I2OSP(nArray[n5 - 1], byArray, n6, n4 - n6);
        return byArray;
    }

    public static int[] toIntArray(byte[] byArray) {
        int n4 = (byArray.length + 3) / 4;
        int n5 = byArray.length & 3;
        int[] nArray = new int[n4];
        int n6 = 0;
        int n7 = 0;
        while (n7 <= n4 - 2) {
            nArray[n7] = LittleEndianConversions.OS2IP(byArray, n6);
            ++n7;
            n6 += 4;
        }
        nArray[n4 - 1] = n5 != 0 ? LittleEndianConversions.OS2IP(byArray, n6, n5) : LittleEndianConversions.OS2IP(byArray, n6);
        return nArray;
    }
}

