/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwe.kdf;

import java.io.ByteArrayOutputStream;
import javax.crypto.Mac;
import org.jose4j.keys.HmacKey;
import org.jose4j.lang.ByteUtil;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.UncheckedJoseException;
import org.jose4j.mac.MacUtil;

public class PasswordBasedKeyDerivationFunction2 {
    private String hmacAlgorithm;

    public PasswordBasedKeyDerivationFunction2(String hmacAlgorithm) {
        this.hmacAlgorithm = hmacAlgorithm;
    }

    public byte[] derive(byte[] password, byte[] salt, int iterationCount, int dkLen) throws JoseException {
        return this.derive(password, salt, iterationCount, dkLen, null);
    }

    public byte[] derive(byte[] password, byte[] salt, int iterationCount, int dkLen, String provider) throws JoseException {
        Mac prf = MacUtil.getInitializedMac(this.hmacAlgorithm, new HmacKey(password), provider);
        int hLen = prf.getMacLength();
        long maxDerivedKeyLength = 0xFFFFFFFFL;
        if ((long)dkLen > maxDerivedKeyLength) {
            throw new UncheckedJoseException("derived key too long " + dkLen);
        }
        int l4 = (int)Math.ceil((double)dkLen / (double)hLen);
        int r4 = dkLen - (l4 - 1) * hLen;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i4 = 0; i4 < l4; ++i4) {
            byte[] block = this.f(salt, iterationCount, i4 + 1, prf);
            if (i4 == l4 - 1) {
                block = ByteUtil.subArray(block, 0, r4);
            }
            byteArrayOutputStream.write(block, 0, block.length);
        }
        return byteArrayOutputStream.toByteArray();
    }

    byte[] f(byte[] salt, int iterationCount, int blockIndex, Mac prf) {
        byte[] lastU = null;
        byte[] xorU = null;
        for (int i4 = 1; i4 <= iterationCount; ++i4) {
            byte[] currentU;
            if (i4 == 1) {
                byte[] inputBytes = ByteUtil.concat(salt, ByteUtil.getBytes(blockIndex));
                xorU = currentU = prf.doFinal(inputBytes);
            } else {
                currentU = prf.doFinal(lastU);
                for (int j4 = 0; j4 < currentU.length; ++j4) {
                    xorU[j4] = (byte)(currentU[j4] ^ xorU[j4]);
                }
            }
            lastU = currentU;
        }
        return xorU;
    }
}

