#!/bin/bash

source /etc/profile

if ! [ -f ~/.gamerc ] ; then
   ################
   # Set manually #
   ################
   # Game Type (JS, DJ, FN, GD, ...)
   GAME_TYPE="DJ"
   
   # Country Code(ISO 3166-1, UPPER CASE)for example: "TW"
   COUNTRY_CODE="TW"
   
   # Set the $SET manually
   [ "$1" == "" ] && SET=1 || SET="$1"
   #SET="$(get_set $(awk -F/ '{print $5}' <<< $AUCTION_LOG_DIR))"
   
   # For old log rotate style, you will have to turn on relink with correct date
   RELINK_WITH_CORRECT_DATE="1"
   
   # Where is the MissionServer log files rotate to?
   MISSION_LOG_ROTATE_DIR="/home/DJ/Log/Set$SET/DB/"
   
   # If relink is on, where do you want to link to?
   RELINK_TO_DIRECTORY="/root/itemprice$SET/"
   
   # Data output directory
   DATA_OUTPUT_DIR="$HOME/CPI/$GAME_TYPE-$COUNTRY_CODE"

else

   #################################
   # Automatically if you use Ctrl #
   #################################
   source ~/.gamerc
   # Set the $SET manually
   [ "$1" == "" ] && SET=$(get_set $(awk -F_ '{print $1}' <<< $HOST_NAME)) || SET="$1"
   
   # Where is the MissionServer log files rotate to?
   MISSION_LOG_ROTATE_DIR="$WORKING_DIRECTORY/servers$SET/Log/*/"
   
   # Data output directory
   DATA_OUTPUT_DIR="$HOME/CPI/"
fi


###########################################################
# Constant for calculation(DO NOT CHANGE THESE VARIABLES) #
###########################################################
# Normalization percentage
NORMALIZATION_PERCENTAGE="10"

# Constant for price standard devation
CONSTANT_FOR_PRICE_STANDARD_DEVATION="1500"

# Constant for volume standard devation
CONSTANT_FOR_VOLUME_STANDARD_DEVATION="1500"


###############################
# Calculation start from here #
###############################
export LC_ALL=C
TODAY="$(date +%Y%m%d)"

if [ "$RELINK_WITH_CORRECT_DATE" == "1" ] ; then
   mkdir -p $RELINK_TO_DIRECTORY
   if [ -d $RELINK_TO_DIRECTORY ] ; then
	cd $MISSION_LOG_ROTATE_DIR
	for auction_log in $(find $PWD -type f|grep Auction.log);do 
		date="$(date -d @$(stat -c %Y $auction_log) +%Y%m%d)"
		filename="$(awk -F/ '{print $NF}' <<< "$auction_log")"
		mkdir -p $RELINK_TO_DIRECTORY/$date
		ln -s $auction_log $RELINK_TO_DIRECTORY/$date/$filename
	done
	DATA_SOURCE_DIR="$RELINK_TO_DIRECTORY"
   else
	exec echo "Error: $RELINK_TO_DIRECTORY does not exist."
   fi
else
   DATA_SOURCE_DIR="$MISSION_LOG_ROTATE_DIR"
fi

mkdir -p $DATA_OUTPUT_DIR
cd $DATA_OUTPUT_DIR


# AVERAGE PRICE/VOLUME
#
# Output Sample(Set, Date, ItemID, Volume, Average Price):
# 1,20120602,30045,210,4629
# 1,20120603,30045,394,4572
# 1,20120604,30045,6,3337
# 1,20120605,30045,22,11671
#
for AUCTION_LOG_DIR in $DATA_SOURCE_DIR/*;do
   DATE_FROM_LOG="$(xcat $AUCTION_LOG_DIR/Auction* 2> /dev/null|head -1000|tail -1|awk -F, '{print $2}')"
   [ "$DATE_FROM_LOG" == "" ] \
   && continue \
   || DATE="$(date -d "$DATE_FROM_LOG" +%Y%m%d)"

   [ "$DATE" == "" ] && continue
   [ "$DATE" == "$TODAY" ] && continue

   if [ -f $SET-$DATE-AVG_VOL.csv ] ; then
        echo "AVG_VOL: $SET-$DATE Existed."
   else
	echo -n "AVG_VOL: $SET-$DATE "
        (
	    xcat $AUCTION_LOG_DIR/Auction* 2> /dev/null|grep ,Buy,ItemID: 
	    sendscript set${SET}wz nosave nohostname <<< "xgrep -A1 -h IL,Vendor, ~/servers*/Log/$DATE/ZoneServer*/Item*"\
		|tr -d '\n'|LC_ALL=C sed 's/--/\n/g;s/[^\x20-\x7F\x0a]//g'\
		|awk -F"[:,]" '$12 == $73 && $57 == $78 {print ",,,,,,"$14",,,,"$22",,"$69}'
	)\
        |awk -F"[:,]" '{
                        if($7<0){
                                printf $7+65536","$11",%.0f\n",$13/$11
                        }else{
                                printf $7","$11",%.0f\n",$13/$11
                        }
                       }' \
        |awk -F, '{
			if(sum[$1]==0){
					high[$1]=$3
					low[$1]=$3
					first[$1]=$3
					last[$1]=0
					sum[$1]=$3
					count[$1]=1
			}

			if(high[$1]<$3)high[$1]=$3
			if(low[$1]>$3)low[$1]=$3

                        sum[$1]+=$3
                        volume[$1]+=$2
                        count[$1]++

			a[$3]++


			# print "3:"$3" sum:"real_sum[$1]" vol:"real_volume[$1]

#			if(real_sum[$1] > 0){
#				if($3/(real_sum[$1]/real_count[$1])<3){
#					sum[$1]+=$3
#					volume[$1]+=$2
#					count[$1]++
#				}
#			}

			last[$1]=$3
                  }END{

#			for(i in a) {
#				if(a[i] > freq) {
#					mode=i
#					freq=a[i]
#				}
#			}
#			print mode","freq

                       for(i in sum){
#				if(a[i] > freq) {
#					mode=i
#					freq=a[i]
#				}
#				print i","a[i]","mode","freq

#				printf "'$SET,$DATE,'"i","volume[i]",%.0f,"first[i]","high[i]","low[i]","last[i]"\n",mode

                                printf "'$SET,$DATE,'"i","volume[i]",%.0f,"first[i]","high[i]","low[i]","last[i]"\n",sum[i]/count[i]
                        }
                  }' \
        |sort -g -t , -k 3 > $SET-$DATE-AVG_VOL.csv
	echo OK
   fi
done


# VOLUME(SIGMA)
# (Overwrite anyway)
#
# Output Sample(ItemID, Total Volume, Trade Days, Average Volume Per Day, Sigma)
> $SET-VOL_SIGMA.csv
for itemid in $(cat $SET-*-AVG_VOL.csv|awk -F, '{print $3}'|sort|uniq|more);do
	echo -n "VOLUME(STANDARD DEVIATION): $SET-$itemid "
	grep -h "^[0-9]\+,[0-9]\+,$itemid," $SET-*-AVG_VOL.csv \
	| awk -F, '{
					OFS=","
					sum+=$4
					array[NR]=$4
					count[$4]++
				   } END {
					if(NR > 0){
						for(x=1;x<=NR;x++){
							sumsq+=((array[x]-(sum/NR))**2)
							total=array[x]+total
							c=x
						}
						printf "%d,%.0f,%d,%.5f,%.5f\n",'$itemid',total,c,total/c,sqrt(sumsq/NR)
				 	}
				   }' >> $SET-VOL_SIGMA.csv
	echo OK
done


# PRICE(STANDARD DEVIATION)
#
# Output Sample(Set, Date, ItemID, Sigma)
# 1,20120602,30045,4620
# 1,20120603,30045,4500
# 1,20120604,30045,3337
# 1,20120605,30045,11671
#
for AUCTION_LOG_DIR in $DATA_SOURCE_DIR/*;do
   DATE_FROM_LOG="$(xcat $AUCTION_LOG_DIR/Auction* 2> /dev/null|head -1000|tail -1|awk -F, '{print $2}')"
   [ "$DATE_FROM_LOG" == "" ] \
   && continue \
   || DATE="$(date -d "$DATE_FROM_LOG" +%Y%m%d)"

   [ "$DATE" == "" ] && continue
   [ "$DATE" == "$TODAY" ] && continue

   if [ -f $SET-$DATE-STANDARDDEVIATION.csv ] ; then
        echo "STANDARD DEVIATION: $SET-$DATE Existed."
   else
	echo -n "STANDARD DEVIATION: $SET-$DATE "
        (
	    xcat $AUCTION_LOG_DIR/Auction* 2> /dev/null|grep ,Buy,ItemID: 
	    sendscript set${SET}wz nosave nohostname <<< "xgrep -A1 -h IL,Vendor, ~/servers*/Log/$DATE/ZoneServer*/Item*"\
		|tr -d '\n'|LC_ALL=C sed 's/--/\n/g;s/[^\x20-\x7F\x0a]//g'\
		|awk -F"[:,]" '$12 == $73 && $57 == $78 {print ",,,,,,"$14",,,,"$22",,"$69}'
	)\
	|awk -F"[:,]" '{
				if($7<0){
					itemid=$7+65536
				} else {
					itemid=$7
				}
				for(i=1;i<=$11;i++)
					printf itemid",%.0f\n",$13/$11
			}' | sort -t , -k 2 -n > standarddeviation.temp

	COUNT=0
	for itemid in $(awk -F, '{print $1}' standarddeviation.temp|sort|uniq);do 
		grep "^$itemid," standarddeviation.temp \
		| awk -F, '{
				OFS=","
				sum+=$2
				array[NR]=$2
			 } END {
				if(NR > 0){
					for(x=1;x<=NR;x++){
						sumsq+=((array[x]-(sum/NR))**2)
					}
				#	print '"$SET,$DATE,$itemid,"'sum/NR, " ", sqrt(sumsq/NR)," ",2*(sqrt(sumsq/NR))" "NR
					print '"$SET,$DATE,$itemid,"'sqrt(sumsq/NR)
				}
		 }' >> $SET-$DATE-SIGMA.csv

		LINES=$(grep "^$itemid," standarddeviation.temp|wc -l)
		SIGMA=$(cat $SET-*-SIGMA.csv|grep "^$SET,$DATE,$itemid,"|awk -F, '{print $NF}'|grep "^[0-9.]\+$") || SIGMA=0
		VOLUME=$(cat $SET-$DATE-AVG_VOL.csv|awk -F, '$2 == '$DATE' && $3 == '$itemid' {print $4}')

		grep "^$itemid," standarddeviation.temp \
		| awk -F, 'NR > (100-'"$SIGMA"'/'"$CONSTANT_FOR_PRICE_STANDARD_DEVATION"')/2*'"$LINES"'/100 \
				&& NR < '"$LINES"'-((100-'"$SIGMA"'/'"$CONSTANT_FOR_PRICE_STANDARD_DEVATION"')/2*'"$LINES"'/100) {
						sum[$1]+=$2
						count[$1]++
					}END{
						for(i in sum){
							if(count[i] == 0){
								printf "%d,%d,%d,0,%.3f,%d\n",'$SET','$DATE','$itemid','$SIGMA','$VOLUME'
							} else {
								printf "%d,%d,%d,%d,%.3f,%d\n",'$SET','$DATE','$itemid',sum[i]/count[i],'$SIGMA','$VOLUME'
							}
						}
					}' >> $SET-$DATE-STANDARDDEVIATION.csv

		grep -q "^$SET,$DATE,$itemid," $SET-$DATE-STANDARDDEVIATION.csv \
		|| cat $SET-$DATE-AVG_VOL.csv|awk -F, '$2 == '$DATE' && $3 == '$itemid' { 
								printf "%d,%d,%d,%d,%.3f,%d\n",'$SET','$DATE','$itemid',$5,'$SIGMA','$VOLUME'
					}' >> $SET-$DATE-STANDARDDEVIATION.csv



#		for itemid in $(cat standarddeviation.temp|awk -F, '{print $1}'|sort|uniq);do 
#			grep "^$itemid," standarddeviation.temp \
##			|awk -F, '{
#					sum[$1]+=$2
#					count[$1]++
#				  }END{
#					for(i in sum){
#						total=sum[i]+total
#						c=c+count[i]
#					}
#					printf "%d,%d,%d,%.0f,%d\n",'$SET','$DATE','$itemid',total,c
#				  }'
#		done >> $SET-$DATE-TOTAL_VOLUME.csv

		

		COUNT=$(($COUNT+1))
		echo -n .
	done
	echo " ($COUNT items) OK"
   fi
done
for file in $SET-*-STANDARDDEVIATION.csv ; do cat $file ; done > $SET-ALL_STANDARDDEVIATION.csv


if false ; then 

# CHANGE(NORMALIZATION)
# (Overwrite anyway)
#
# Sample output FIXME:
# 1,20120519,49045,235
# 1,20120516,49046,262
# 1,20120827,49298,243
#
# (set, date, item id, avg. price(normalization), price change(reference the last data), price change(reference the base data)
for ITEM_ID in `awk -F, '{print $3}' $SET-ALL_STANDARDDEVIATION.csv|sort|uniq`;do
        echo -n "CHANGE(NORMALIZATION): $ITEM_ID "
        awk -F, '$3=='"$ITEM_ID"' {
                                        sum[$2]=$4
                                        itemid[$2]=$3
                                   }END{
                                        for(i in sum){
                                                if(last_price>0){
                                                                        printf "'$SET,'"i","itemid[i]","sum[i]","sum[i]/last_price","sum[i]/base_price"\n"
                                                                }
                                                                else
                                                                {
                                                                        base_price=sum[i]
                                                                }
                                                last_price=sum[i]
                                                }
                                   }' $SET-ALL_STANDARDDEVIATION.csv > $SET-$ITEM_ID-CHANGE_NORMALIZATION.csv
        echo OK
done


# CHANGE
# (Overwrite anyway)
#
# Sample output:
# 1,20120519,49045,3,235353,1.5,3,1.27556,0.941337
# 1,20120516,49046,3,199020,0.6,0.6,0.765992,0.765992
# 1,20120827,49298,5,225020,5,5,0.321448,0.321448
#
# (set, date, item id, volume, avg. price, volume change(reference the last data), volume change(reference the base data), price change(reference the last data), price change(reference the base data)
cat $SET-*-AVG_VOL.csv > $SET-ALL_AVG_VOL.csv
for ITEM_ID in `awk -F, '{print $3}' $SET-ALL_AVG_VOL.csv|sort|uniq`;do
	echo -n "CHANGE: $ITEM_ID "
	awk -F, '$3=='"$ITEM_ID"' {
					sum[$2]=$5
					itemid[$2]=$3
					volume[$2]=$4
				   }END{
					for(i in sum){
						if(last_price>0){
									printf "'$SET,'"i","itemid[i]","volume[i]","sum[i]","volume[i]/last_vol","volume[i]/base_vol","sum[i]/last_price","sum[i]/base_price"\n"
								}
								else
								{
									base_vol=volume[i]
									base_price=sum[i]
								}
						last_vol=volume[i]
						last_price=sum[i]
						}
				   }' $SET-ALL_AVG_VOL.csv > $SET-$ITEM_ID-CHANGE.csv
	echo OK
done


# CPI(multiple items from itemmall without weight)
# (Overwrite anyway)
#
# Sample output:
# 1,20120519,49045,3,235353,1.5,3,1.27556,0.941337
# 1,20120516,49046,3,199020,0.6,0.6,0.765992,0.765992
# 1,20120827,49298,5,225020,5,5,0.321448,0.321448
#
# (set, date, item id, volume, avg. price, volume change(reference the last data), volume change(reference the base data), price change(reference the last data), price change(reference the base data)
cat $SET-*-CHANGE.csv > $SET-ALL_CHANGE.csv
awk -F, '$3 >= 40000 {print}' $SET-ALL_CHANGE.csv  > $SET-ALL_CHANGE_ITEMMALL_ONLY.csv
for OUTPUT_DATE in `awk -F, '{print $2}' $SET-ALL_CHANGE_ITEMMALL_ONLY.csv|sort|uniq`;do 
	awk -F, '$2 == '"$OUTPUT_DATE"'{ 
					date[$1]=$2
					sum[$1]+=$9
					volume[$1]+=$7
					count[$1]++ 
				       }END{
					for(i in date){
						printf '"$SET"'","date[i]",%.3f,%.3f\n",volume[i]/count[i],sum[i]/count[i]
					}
				       }' $SET-ALL_CHANGE_ITEMMALL_ONLY.csv
done > $SET-CPI-ITEMMALL_ONLY.csv


# CPI((NORMALIZATION)multiple items from itemmall without weight)
# (Overwrite anyway)
#
# Sample output FIXME:
# 1,20120519,49045,3,235353,1.5,3,1.27556,0.941337
# 1,20120516,49046,3,199020,0.6,0.6,0.765992,0.765992
# 1,20120827,49298,5,225020,5,5,0.321448,0.321448
#
# (set, date, item id, volume, avg. price, volume change(reference the last data), volume change(reference the base data), price change(reference the last data), price change(reference the base data)
> $SET-ALL_CHANGE_NORMALIZATION.csv
for i in $SET-*-CHANGE_NORMALIZATION.csv ; do cat $i >> $SET-ALL_CHANGE_NORMALIZATION.csv;done
awk -F, '$3 >= 40000 {print}' $SET-ALL_CHANGE_NORMALIZATION.csv  > $SET-ALL_CHANGE_NORMALIZATION_ITEMMALL_ONLY.csv
for OUTPUT_DATE in `awk -F, '{print $2}' $SET-ALL_CHANGE_NORMALIZATION_ITEMMALL_ONLY.csv|sort|uniq`;do 
	awk -F, '$2 == '"$OUTPUT_DATE"'{ 
					date[$1]=$2
					sum[$1]+=$6
					count[$1]++ 
				       }END{
					for(i in date){
						printf '"$SET"'","date[i]",%.3f\n",sum[i]/count[i]
					}
				       }' $SET-ALL_CHANGE_NORMALIZATION_ITEMMALL_ONLY.csv
done > $SET-CPI-NORMALIZATION_ITEMMALL_ONLY.csv
fi


# Collect all the buy item count
for AUCTION_LOG_DIR in $DATA_SOURCE_DIR/*;do
   DATE_FROM_LOG="$(xcat $AUCTION_LOG_DIR/Auction* 2> /dev/null|head -1000|tail -1|awk -F, '{print $2}')"
   [ "$DATE_FROM_LOG" == "" ] \
   && continue \
   || DATE="$(date -d "$DATE_FROM_LOG" +%Y%m%d)"

   [ "$DATE" == "" ] && continue
   [ "$DATE" == "$TODAY" ] && continue

   echo -n "ALL ITEM COUNT: $SET-$DATE "
   xcat $AUCTION_LOG_DIR/Auction* 2> /dev/null|grep ,Buy,ItemID: \
   |awk -F"[:,]" '{
			if($7<0){
				itemid=$7+65536
			} else {
				itemid=$7
			}
			for(i=1;i<=$11;i++)
				printf itemid",%.0f\n",$13/$11
		}' | sort -t , -k 2 -n >> allbuy.temp
   echo OK
done
awk -F, '{print $1}' allbuy.temp | sort | uniq -c | awk '{print $2","$1}' | sort > $SET-ALL_ITEM_TOTAL_VOLUME.csv

# Remove temp files
rm -fv core.* *.temp


###################
# If you use Ctrl #
###################
if [ -f ~/.gamerc ] ; then
   # Create directories on test server
   ssh test "mkdir -p www/CPI/$GAME_TYPE-$COUNTRY_CODE/"

   # Copy the file to test server
   scp * test:~/www/CPI/$GAME_TYPE-$COUNTRY_CODE/
fi





