--
-- PostgreSQL database dump
--

-- Dumped from database version 11.4
-- Dumped by pg_dump version 11.4

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'LATIN1';
SET standard_conforming_strings = off;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET escape_string_warning = off;
SET row_security = off;

--
-- Name: buffid; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE public.buffid AS (
	buff integer,
	debuff integer
);


ALTER TYPE public.buffid OWNER TO postgres;

--
-- Name: res_set; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE public.res_set AS (
	pidnum integer,
	nret smallint
);


ALTER TYPE public.res_set OWNER TO postgres;

--
-- Name: account_login(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION public.account_login(character varying, character varying, character varying) RETURNS public.res_set
    LANGUAGE plpgsql
    AS $_$declare
ppAccountID ALIAS FOR $1;
pPassword ALIAS FOR $2;
pClientIP ALIAS FOR $3;
pAccountID varchar(20);
pcount int;
pPwd char(32) default null;
pBAuthority int2 default 0;
pGMIP varchar(15) default null;

res res_set;

BEGIN
pAccountID = lower(ppAccountID);
res.nRet=-1;

SELECT INTO pcount count(mid) FROM "tb_user" WHERE mid=pAccountID;
IF pcount =0 THEN --This Account is not exist
res.pIdNum= -1;
res.nRet = 2;
RETURN res;
END IF;

SELECT INTO pPwd,pBAuthority,res.pIdNum pwd,byAuthority,idnum FROM "tb_user" WHERE mid=pAccountID;

--IF pPwd IS null THEN
--res.nRet = 2;
--RETURN res;
--ELSEIF pPwd <> pPassword THEN
--res.nRet = 3;
--RETURN res;
--END IF;

IF pBAuthority = 255 THEN   --This Account was locked
res.nRet = 5;
RETURN res;
END IF;

--IF pBAuthority = 1 THEN   --gmAccount  Check ip (0-->User, 1-->GM, 255-->Locked)
--SELECT INTO pGMIP ip FROM gmip WHERE ip=pClientIP;
--IF pGMIP IS NULL THEN
--res.nRet = 4;
--RETURN res;
--END IF;
--END IF;

res.nRet = 1;
RETURN res;
END;
$_$;


ALTER FUNCTION public.account_login(character varying, character varying, character varying) OWNER TO spiritking;

--
-- Name: account_logoutx(character varying, character varying, character varying, character varying, integer); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION public.account_logoutx(character varying, character varying, character varying, character varying, integer) RETURNS smallint
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
pCharID_var ALIAS FOR $2;
pServerIP_var ALIAS FOR $3;
pClientIP_var ALIAS FOR $4;
pServerID_var ALIAS FOR $5;
pAccountID varchar(21);

-- update billing data when logout
pServerID int2;
pCharID integer;
pServerIP varchar(15);
pClientIP varchar(15);
pstrCharID varchar(32);
pPValue int2;
pExpireDate timestamp;
pBillingRule int2;
pFree bit;
pDeduction int2;
pAddTime int2;
pTimeFormat char(2);
pMID char(20);
pVPS int2;
pUnits real;

pTotalVPS int4 default 0;
pTimeLogin timestamp;
pDuring int4;
pTimeLogout timestamp;
pBrule int2;
pOriServerID int2;
pOriServerIP varchar(15);


integer_var integer;

BEGIN
pAccountID = ppAccountID;  
SELECT INTO pMID mid FROM tb_user where mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN

SELECT INTO pTimeLogin,  pServerID, pServerIP,pClientIP,pstrCharID,pCharID  logindate, serverid, serverip,clientip,strcharid,char_id FROM currentuser WHERE mid=pAccountID;


pDuring = CAST(EXTRACT(EPOCH FROM now()) - EXTRACT(EPOCH FROM pTimeLogin) as int4) / 60;

UPDATE tb_user SET status=0,clientip=pClientIP WHERE mid=pAccountID;

--


INSERT INTO game_log (mid,strcharid,logindate,logoutdate,nduring,serverid,serverip,clientip,char_id)
VALUES (pAccountID,pstrCharID,pTimeLogin,now(),pDuring,pServerID,pServerIP,pClientIP,pCharID);

DELETE FROM currentuser WHERE mid=pAccountID;

-- Update user_aggregate - dsell@aeriagames.com
--PERFORM age_createorupdate_accountactivity(pAccountID,CURRENT_TIMESTAMP);

return 1;
END IF;

return 1;
END;
$_$;


ALTER FUNCTION public.account_logoutx(character varying, character varying, character varying, character varying, integer) OWNER TO spiritking;

--
-- Name: age_create_gfaccount(character varying, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.age_create_gfaccount(p_name character varying, p_uid integer, p_passwd character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
BEGIN                                      

    INSERT INTO tb_user (mid, pwd, idnum, byauthority, regdate) VALUES
(lower(p_name), p_passwd, p_uid, 0, now());
    RETURN 0;

END; 
$$;


ALTER FUNCTION public.age_create_gfaccount(p_name character varying, p_uid integer, p_passwd character varying) OWNER TO postgres;

--
-- Name: age_createorupdate_accountactivity(character varying, timestamp with time zone); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION public.age_createorupdate_accountactivity(p_name character varying, p_logtime timestamp with time zone) RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE 
  v_uid INT;
  v_count INT;
BEGIN
  SELECT INTO v_uid idnum FROM tb_user WHERE mid = p_name;
  
  IF NOT FOUND THEN
    return 0;
  END IF;
  
  SELECT INTO v_count COUNT(*) FROM age_user_aggregate WHERE uid = v_uid;
  IF v_count = 0 THEN
    INSERT INTO age_user_aggregate (uid, first_activity, last_activity) VALUES (v_uid, p_logtime, p_logtime);
  ELSE
    UPDATE age_user_aggregate SET last_activity = p_logtime WHERE uid = v_uid AND p_logtime > last_activity;
  END IF;
  
  return 0;
END;
$$;


ALTER FUNCTION public.age_createorupdate_accountactivity(p_name character varying, p_logtime timestamp with time zone) OWNER TO spiritking;

--
-- Name: age_createorupdate_gfaccount(character varying, integer, character varying, timestamp without time zone); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.age_createorupdate_gfaccount(p_name character varying, p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE 
    v_curuid INT;
    v_curPasswd VARCHAR(32);
    v_curUpdateTime timestamp; 

BEGIN

    v_curuid := -1;

    SELECT INTO v_curuid, v_curPasswd, v_curUpdateTime idnum, pwd, updatetime
FROM tb_user WHERE idnum = p_uid;

    IF (v_curuid = -1 OR v_curuid IS NULL) THEN
        -- create the user
        RETURN age_Create_GFAccount (p_name, p_uid, p_passwd);
    END IF;

    IF (v_curuid IS NOT NULL AND v_curPasswd <> p_passwd AND v_curUpdateTime <
p_updateTime) THEN
        -- update the user
        RETURN age_Update_GFAccount (p_uid, p_passwd, p_updateTime);
    END IF;
    
    RETURN 0;
END;
$$;


ALTER FUNCTION public.age_createorupdate_gfaccount(p_name character varying, p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) OWNER TO postgres;

--
-- Name: age_update_gfaccount(integer, character varying, timestamp without time zone); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.age_update_gfaccount(p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) RETURNS integer
    LANGUAGE plpgsql
    AS $$
BEGIN      

    UPDATE tb_user SET pwd = TRIM(p_passwd), updatetime = p_updateTime WHERE
idnum = p_uid AND updatetime < p_updateTime;
    RETURN 0;

END; 
$$;


ALTER FUNCTION public.age_update_gfaccount(p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) OWNER TO postgres;

--
-- Name: char_login(character varying, integer, character varying, character varying, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.char_login(character varying, integer, character varying, character varying, integer, character varying) RETURNS smallint
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
nWorldID ALIAS FOR $2;
pServerIP  ALIAS FOR $3;
pClientIP  ALIAS FOR $4;
nCharID ALIAS FOR $5;
pCharName  ALIAS FOR $6;
v_uid INT;
pMID char(32);
pExpiredate timestamp;
pAccountID varchar(32);
integer_var integer;

BEGIN
--pAccountID = lower(ppAccountID);
pAccountID = ppAccountID;
DELETE FROM currentuser WHERE mid=pAccountID;
INSERT INTO currentuser (mid,serverid,serverip,clientip,char_id,strcharid) VALUES (pAccountID,nWorldID,pServerIP,pClientIP,nCharID,pCharName);
SELECT INTO pMID,pExpiredate mid,firstlogindate FROM tb_user WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN
        UPDATE tb_user SET Status=1, lastlogindate=now() Where mid=pAccountID;
        return 0;
ELSE
        SELECT INTO v_uid id FROM id_actname WHERE username = pAccountID;
        INSERT INTO tb_user (mid, idnum,firstlogindate, lastlogindate,clientip) VALUES (pAccountID,v_uid,now(),now(),pClientIP);
        return 0;
END IF;   
END;



$_$;


ALTER FUNCTION public.char_login(character varying, integer, character varying, character varying, integer, character varying) OWNER TO postgres;

--
-- Name: char_login_v4(character varying, integer, character varying, character varying, integer, character varying, character varying, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.char_login_v4(character varying, integer, character varying, character varying, integer, character varying, character varying, integer) RETURNS public.buffid
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
nWorldID ALIAS FOR $2;
pServerIP  ALIAS FOR $3;
pClientIP  ALIAS FOR $4;
nCharID ALIAS FOR $5;
pCharName  ALIAS FOR $6;
pMacAddress ALIAS FOR $7;
pGold ALIAS FOR $8;
v_uid INT;
pMID char(50);
pFirstLoginDate timestamp;
pAccountID varchar(50);
pidnum integer;
integer_var integer;
plastlogindate timestamp;
res_buff buffid;
BEGIN
--pAccountID = lower(ppAccountID);
pAccountID = ppAccountID;
DELETE FROM currentuser WHERE mid=pAccountID;
INSERT INTO currentuser (mid,serverid,serverip,clientip,char_id,strcharid,mac_address,gold) VALUES (pAccountID,nWorldID,pServerIP,pClientIP,nCharID,pCharName,pMacAddress,pGold);
SELECT INTO pMID,pFirstLoginDate,pidnum,plastlogindate mid,firstlogindate,idnum,lastlogindate FROM tb_user WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;
res_buff.buff=1;
res_buff.debuff=0;
IF(integer_var > 0) THEN
        IF pFirstLoginDate is null THEN
                -- insert item before CR
                -- insert into active_char (mid,idnum,logindate,worldid,charid,charname,clientip) values (pAccountID,pidnum,now(),nWorldID,nCharID,pCharName,pClientIP);
                UPDATE tb_user SET firstlogindate=now(),clientip=pClientIP Where mid=pAccountID;

        END IF;
        UPDATE tb_user SET Status=1, lastlogindate=now() Where mid=pAccountID;
        return res_buff;
ELSE
   -- SELECT INTO v_uid id FROM id_actname WHERE username = pAccountID;
   --     INSERT INTO tb_user (mid, idnum,firstlogindate, lastlogindate,clientip,sel_chk) VALUES (pAccountID,v_uid,now(),now(),pClientIP,1);
        return res_buff;
END IF;
END;



$_$;


ALTER FUNCTION public.char_login_v4(character varying, integer, character varying, character varying, integer, character varying, character varying, integer) OWNER TO postgres;

--
-- Name: char_logout(character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION public.char_logout(character varying, integer, integer) RETURNS smallint
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
nNodeID ALIAS FOR $2;
nLevel ALIAS FOR $3;

-- update billing data when logout
pAccountID varchar(32);

pTimeLogin timestamp;
pDuring integer;
pServerID int2;
pServerIP varchar(15);
pClientIP varchar(15);
pstrCharID varchar(32);
pCharID integer;


integer_var integer;
BEGIN
pAccountID = ppAccountID;
SELECT INTO pTimeLogin,  pServerID, pServerIP,pClientIP,pstrCharID,pCharID  logindate, serverid, serverip,clientip,strcharid,char_id FROM currentuser WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;
RAISE NOTICE 'Variable an_integer was changed. %  and  % and %' ,pAccountID,pServerID, pClientIP;
IF(integer_var > 0) THEN


pDuring = CAST(EXTRACT(EPOCH FROM now()) - EXTRACT(EPOCH FROM pTimeLogin) as int4) / 60;

UPDATE tb_user SET status=0,clientip=pClientIP WHERE mid=pAccountID;

-- 
INSERT INTO game_log (mid,strcharid,logindate,logoutdate,nduring,serverid,serverip,clientip,char_id,node_id,char_level)
VALUES (pAccountID,pstrCharID,pTimeLogin,now(),pDuring,pServerID,pServerIP,pClientIP,pCharID,nNodeID,nLevel);

--INSERT INTO game_log (mid,strcharid,logindate,logoutdate,nduring,serverid,serverip,clientip)
--VALUES (pAccountID,pstrCharID,pTimeLogin,now(),pDuring,pServerID,pServerIP,pClientIP);

DELETE FROM currentuser WHERE mid=pAccountID;

return 1;

END IF;

return 1;
END;

$_$;


ALTER FUNCTION public.char_logout(character varying, integer, integer) OWNER TO spiritking;

--
-- Name: char_logout_v4(character varying, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.char_logout_v4(character varying, integer, integer, integer) RETURNS smallint
    LANGUAGE plpgsql
    AS $_$DECLARE
pAccountID ALIAS FOR $1;
nNodeID ALIAS FOR $2;
nLevel ALIAS FOR $3;
nOutGold ALIAS FOR $4;
pTimeLogin timestamp;
pDuring integer;
pServerID int2;
pServerIP varchar(15);
pClientIP varchar(15);
pstrCharID text;
pCharID integer;
pgold integer;
pDifference integer;
integer_var integer;
BEGIN
SELECT INTO pTimeLogin,  pServerID, pServerIP,pClientIP,pstrCharID,pCharID,pgold  logindate, serverid, serverip,clientip,strcharid,char_id,gold FROM currentuser WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;
--RAISE NOTICE 'Variable an_integer was changed. %  and  % and %' ,pAccountID,pServerID, pClientIP;
pDifference=nOutGold-pgold;
IF(integer_var > 0) THEN
   pDuring = CAST(EXTRACT(EPOCH FROM now() AT TIME ZONE 'Asia/Hong_Kong') - EXTRACT(EPOCH FROM pTimeLogin) as int4) / 60;
   UPDATE tb_user SET status=0,clientip=pClientIP WHERE mid=pAccountID;
   INSERT INTO game_log (mid,strcharid,logindate,logoutdate,nduring,serverid,serverip,clientip,char_id,node_id,char_level,gold)
      VALUES (pAccountID,pstrCharID,pTimeLogin,now(),pDuring,pServerID,pServerIP,pClientIP,pCharID,nNodeID,nLevel,pgold);
   --
   DELETE FROM currentuser WHERE mid=pAccountID;
   --IF (nLevel>=30 and NOT EXISTS(SELECT * from level30_reward WHERE mid=pAccountID)) THEN
   --               PERFORM dblink_connect('dbname=LHAccount');
   --               PERFORM dblink_exec('INSERT INTO item_receivable (account_name,item_id,item_quantity) VALUES (\'' || pAccountID || '\', 40074, 5);') ;
   --               PERFORM dblink_disconnect();
   --               EXECUTE 'INSERT INTO level30_reward VALUES ($1,$2,now())'
   --               USING pAccountID,nLevel;
   --END IF;
   return 1;
END IF;

return 1;
END;

$_$;


ALTER FUNCTION public.char_logout_v4(character varying, integer, integer, integer) OWNER TO postgres;

--
-- Name: check_communicate_lock(character varying); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION public.check_communicate_lock(character varying) RETURNS smallint
    LANGUAGE plpgsql
    AS $$DECLARE
pAccountID varchar(32);

BEGIN
return 1;
END;$$;


ALTER FUNCTION public.check_communicate_lock(character varying) OWNER TO spiritking;

--
-- Name: datediff(character varying, date, date); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION public.datediff(p_interval character varying, p_datefrom date, p_dateto date) RETURNS integer
    LANGUAGE plpgsql
    AS $$




BEGIN
if p_Interval = 'm' then
return ((date_part('y',p_DateTo) * 12) + date_part('month',p_DateTo))
- ((date_part('y',p_DateFrom) * 12) + date_part('month',p_DateFrom));
elseif p_Interval = 'y' then
return date_part('y',p_DateTo) - date_part('y',p_DateFrom);
else
raise exception 'Datediff: Interval not supported';
return 0;
end if;
END;
$$;


ALTER FUNCTION public.datediff(p_interval character varying, p_datefrom date, p_dateto date) OWNER TO spiritking;

--
-- Name: game_login(character varying, integer, character varying); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION public.game_login(character varying, integer, character varying) RETURNS smallint
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
pServerID ALIAS FOR $2;
pServerIP ALIAS FOR $3;
pAccountID varchar(20);

pPValue int2;
pExpireDate timestamp;
pBillingRule int2;
pFree bit;
pDeduction int2;
pAddTime int2;
pTimeFormat char(2);
pMID char(20);
integer_var integer;
BEGIN
pAccountID = lower(ppAccountID);

DELETE FROM currentuser WHERE mid=pAccountID;

SELECT INTO pMID,pExpireDate mid,expiredate FROM tb_user WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN
INSERT INTO currentuser (mid,billingrule,serverid,serverip) VALUES (pAccountID,1,pServerID,pServerIP);
UPDATE tb_user SET Status=1, lastlogindate=now() Where mid=pAccountID;
   IF pExpireDate is null then 
          UPDATE tb_user SET expiredate=now() Where mid=pAccountID;
   END IF; 
-- Update user_aggregate - dsell@aeriagames.com
PERFORM age_createorupdate_accountactivity(pAccountID,CURRENT_TIMESTAMP);
return 1;   --ok
ELSE
return 4;
END IF;
END;
$_$;


ALTER FUNCTION public.game_login(character varying, integer, character varying) OWNER TO spiritking;

--
-- Name: get_point_info(character varying); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION public.get_point_info(character varying) RETURNS record
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
pAccountID varchar(20);
nPValues int;
nBonus int;
integer_var int;
nPoints record; --(nPValues,nBonus);
BEGIN
pAccountID = lower(ppAccountID);

SELECT INTO nPValues,nBonus pvalues,bonus FROM tb_user WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN
nPoints :=(nPValues,nBonus);
return nPoints;   --ok
ELSE
nPoints :=(0,0);
return nPoints; --false There is no Account.
END IF;
END;$_$;


ALTER FUNCTION public.get_point_info(character varying) OWNER TO spiritking;

--
-- Name: req_buy_item(character varying, character varying, integer, character varying, integer, character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION public.req_buy_item(character varying, character varying, integer, character varying, integer, character varying, integer, integer) RETURNS record
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
pServerIP ALIAS FOR $2;
pItemID ALIAS FOR $3;
pCharName ALIAS FOR $4;
pBuyPoint ALIAS FOR $5;
pClientIP ALIAS FOR $6;
pBuyType ALIAS FOR $7;
pAmount ALIAS FOR $8;
pAccountID varchar(20);
integer_var int;
BonusRate smallint;
nPValues int;
nBonus int;
nPoints record; --(nPValues,nBonus); input values only use two type.

BEGIN
pAccountID = lower(ppAccountID);
BonusRate=5;
SELECT INTO nPValues,nBonus pvalues,bonus FROM tb_user WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN
--Type 1 model
IF (pBuyType=1 and nPValues >= pBuyPoint) THEN
nBonus=nBonus+floor(pBuyPoint/BonusRate);
nPValues=nPValues-pBuyPoint;
INSERT INTO web_itemmall_log (straccountid,strcharid,serverno,itemid,itemcount,buyprice,clientip,buytype,bonus,buytotal) Values (pAccountID,pCharName,pServerIP,pItemID,pAmount,pBuyPoint,pClientIP,pBuyType,floor(pBuyPoint/BonusRate),pBuyPoint);

update tb_user set pvalues = nPValues, bonus= nBonus where mid=pAccountID;
nPoints :=(nPvalues,nBonus);
return nPoints;   --Type 1 ok
--Type 2 model
ElSEIF (pBuyType=2 and nBonus >= pBuyPoint) THEN
nBonus=nBonus-(pBuyPoint);
INSERT INTO web_itemmall_log (straccountid,strcharid,serverno,itemid,itemcount,buyprice,clientip,buytype,bonus,buytotal) Values (pAccountID,pCharName,pServerIP,pItemID,pAmount,pBuyPoint,pClientIP,pBuyType,0,pBuyPoint);

update tb_user set bonus = nBonus where mid=pAccountID;
nPoints :=(nPvalues,nBonus);
return nPoints;    --Type 2 ok
ELSE
nPValues= -103;
nBonus= -103;
nPoints :=(nPvalues,nBonus);
return nPoints; 
END IF;
END IF;
nPValues= -101;
nBonus= -101;
nPoints :=(nPvalues,nBonus);
return nPoints; 
END;

$_$;


ALTER FUNCTION public.req_buy_item(character varying, character varying, integer, character varying, integer, character varying, integer, integer) OWNER TO spiritking;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: age_user_aggregate; Type: TABLE; Schema: public; Owner: spiritking
--

CREATE TABLE public.age_user_aggregate (
    uid integer NOT NULL,
    first_activity timestamp with time zone DEFAULT now() NOT NULL,
    last_activity timestamp with time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.age_user_aggregate OWNER TO spiritking;

--
-- Name: currentuser; Type: TABLE; Schema: public; Owner: spiritking
--

CREATE TABLE public.currentuser (
    mid character varying(20) NOT NULL,
    strcharid character varying(32),
    serverip character varying(15),
    clientip character varying(15),
    logindate timestamp with time zone DEFAULT now() NOT NULL,
    billingrule smallint,
    nduring integer,
    vps integer,
    serverid smallint,
    char_id integer,
    mac_address text,
    gold integer
);


ALTER TABLE public.currentuser OWNER TO spiritking;

--
-- Name: game_log; Type: TABLE; Schema: public; Owner: spiritking
--

CREATE TABLE public.game_log (
    id integer NOT NULL,
    mid character varying(20) NOT NULL,
    strcharid character varying(32),
    logindate timestamp with time zone DEFAULT now(),
    logoutdate timestamp with time zone DEFAULT now(),
    nduring integer,
    vps integer,
    serverid smallint,
    clientip character varying(15),
    serverip character varying(15),
    char_id integer,
    node_id integer,
    char_level integer,
    gold integer DEFAULT 0
);


ALTER TABLE public.game_log OWNER TO spiritking;

--
-- Name: game_log_id_seq; Type: SEQUENCE; Schema: public; Owner: spiritking
--

CREATE SEQUENCE public.game_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.game_log_id_seq OWNER TO spiritking;

--
-- Name: game_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: spiritking
--

ALTER SEQUENCE public.game_log_id_seq OWNED BY public.game_log.id;


--
-- Name: gmip; Type: TABLE; Schema: public; Owner: spiritking
--

CREATE TABLE public.gmip (
    ip character varying(15) NOT NULL,
    description character varying(50)
);


ALTER TABLE public.gmip OWNER TO spiritking;

--
-- Name: gmtool_log; Type: TABLE; Schema: public; Owner: spiritking
--

CREATE TABLE public.gmtool_log (
    gameaccount character varying(32),
    gameserver character varying(32),
    itemid character varying(10),
    itemname character varying(50),
    itemcount integer,
    byuser character varying(20),
    regdate date DEFAULT now()
);


ALTER TABLE public.gmtool_log OWNER TO spiritking;

--
-- Name: powerupitem; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.powerupitem (
    item_id integer NOT NULL,
    cnname text DEFAULT ''::text,
    itemname text DEFAULT ''::text,
    stack_size integer
);


ALTER TABLE public.powerupitem OWNER TO postgres;

--
-- Name: pus_avg; Type: TABLE; Schema: public; Owner: spiritking
--

CREATE TABLE public.pus_avg (
    buydate date DEFAULT now() NOT NULL,
    buyprice integer DEFAULT 0,
    buynum integer DEFAULT 0,
    buyavg integer DEFAULT 0
);


ALTER TABLE public.pus_avg OWNER TO spiritking;

--
-- Name: tb_user; Type: TABLE; Schema: public; Owner: spiritking
--

CREATE TABLE public.tb_user (
    mid character varying(20) NOT NULL,
    password character varying(20),
    pwd character varying(32),
    idnum integer NOT NULL,
    byauthority smallint DEFAULT 0,
    pvalues integer DEFAULT 0,
    firstlogindate timestamp without time zone,
    billingrule smallint DEFAULT 0,
    status smallint DEFAULT 0,
    regdate timestamp with time zone DEFAULT now(),
    lastlogindate timestamp with time zone,
    memberid character varying(20),
    clientip character varying(20),
    updatetime timestamp without time zone DEFAULT now(),
    bonus integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.tb_user OWNER TO spiritking;

--
-- Name: tb_user_idnum_seq; Type: SEQUENCE; Schema: public; Owner: spiritking
--

CREATE SEQUENCE public.tb_user_idnum_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tb_user_idnum_seq OWNER TO spiritking;

--
-- Name: tb_user_idnum_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: spiritking
--

ALTER SEQUENCE public.tb_user_idnum_seq OWNED BY public.tb_user.idnum;


--
-- Name: web_itemmall_log; Type: TABLE; Schema: public; Owner: spiritking
--

CREATE TABLE public.web_itemmall_log (
    idx integer NOT NULL,
    straccountid character varying(32) NOT NULL,
    strcharid character varying(32),
    serverno character(16) NOT NULL,
    itemid integer NOT NULL,
    itemcount smallint DEFAULT 1,
    buytime timestamp with time zone DEFAULT now() NOT NULL,
    buyprice integer,
    clientip character(20),
    buytype smallint DEFAULT 1 NOT NULL,
    bonus integer DEFAULT 0 NOT NULL,
    serverid character varying,
    buytotal integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.web_itemmall_log OWNER TO spiritking;

--
-- Name: web_itemmall_log_idx_seq; Type: SEQUENCE; Schema: public; Owner: spiritking
--

CREATE SEQUENCE public.web_itemmall_log_idx_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.web_itemmall_log_idx_seq OWNER TO spiritking;

--
-- Name: web_itemmall_log_idx_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: spiritking
--

ALTER SEQUENCE public.web_itemmall_log_idx_seq OWNED BY public.web_itemmall_log.idx;


--
-- Name: game_log id; Type: DEFAULT; Schema: public; Owner: spiritking
--

ALTER TABLE ONLY public.game_log ALTER COLUMN id SET DEFAULT nextval('public.game_log_id_seq'::regclass);


--
-- Name: tb_user idnum; Type: DEFAULT; Schema: public; Owner: spiritking
--

ALTER TABLE ONLY public.tb_user ALTER COLUMN idnum SET DEFAULT nextval('public.tb_user_idnum_seq'::regclass);


--
-- Name: web_itemmall_log idx; Type: DEFAULT; Schema: public; Owner: spiritking
--

ALTER TABLE ONLY public.web_itemmall_log ALTER COLUMN idx SET DEFAULT nextval('public.web_itemmall_log_idx_seq'::regclass);


--
-- Name: currentuser ccu_mid_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking
--

ALTER TABLE ONLY public.currentuser
    ADD CONSTRAINT ccu_mid_pkey PRIMARY KEY (mid);


--
-- Name: game_log gamelog_id_mid; Type: CONSTRAINT; Schema: public; Owner: spiritking
--

ALTER TABLE ONLY public.game_log
    ADD CONSTRAINT gamelog_id_mid PRIMARY KEY (id, mid);


--
-- Name: gmip pk_gmip; Type: CONSTRAINT; Schema: public; Owner: spiritking
--

ALTER TABLE ONLY public.gmip
    ADD CONSTRAINT pk_gmip PRIMARY KEY (ip);


--
-- Name: age_user_aggregate pk_uid; Type: CONSTRAINT; Schema: public; Owner: spiritking
--

ALTER TABLE ONLY public.age_user_aggregate
    ADD CONSTRAINT pk_uid PRIMARY KEY (uid);


--
-- Name: powerupitem powerupitem_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.powerupitem
    ADD CONSTRAINT powerupitem_pkey PRIMARY KEY (item_id);


--
-- Name: pus_avg pus_avg_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking
--

ALTER TABLE ONLY public.pus_avg
    ADD CONSTRAINT pus_avg_pkey PRIMARY KEY (buydate);


--
-- Name: tb_user tb_user_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking
--

ALTER TABLE ONLY public.tb_user
    ADD CONSTRAINT tb_user_pkey PRIMARY KEY (mid);


--
-- Name: web_itemmall_log web_itemmall_log_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking
--

ALTER TABLE ONLY public.web_itemmall_log
    ADD CONSTRAINT web_itemmall_log_pkey PRIMARY KEY (idx, straccountid, itemid, buytime);


--
-- Name: game_log_index; Type: INDEX; Schema: public; Owner: spiritking
--

CREATE INDEX game_log_index ON public.game_log USING btree (logindate, logoutdate, serverid, clientip);


--
-- Name: index_tb_user_idnum; Type: INDEX; Schema: public; Owner: spiritking
--

CREATE INDEX index_tb_user_idnum ON public.tb_user USING btree (idnum);


--
-- Name: ix_last_activity; Type: INDEX; Schema: public; Owner: spiritking
--

CREATE INDEX ix_last_activity ON public.age_user_aggregate USING btree (last_activity);


--
-- Name: tb_user_index; Type: INDEX; Schema: public; Owner: spiritking
--

CREATE INDEX tb_user_index ON public.tb_user USING btree (regdate, lastlogindate, firstlogindate);


--
-- Name: TABLE powerupitem; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public.powerupitem TO spiritking;


--
-- PostgreSQL database dump complete
--

