import datetime
import sys

def parse_log_time(log_line):
    try:
        # 假設時間戳記在每行日誌的第二個逗號分隔的欄位
        timestamp_str = log_line.split(',')[1]
        return datetime.datetime.strptime(timestamp_str, '%Y/%m/%d %H:%M:%S')
    except ValueError:
        return None

def find_recent_send_logs(file_path, minutes=60):
    current_time = datetime.datetime.now()
    threshold_time = current_time - datetime.timedelta(minutes=minutes)
    send_logs = []

    with open(file_path, 'r', encoding='utf-8') as file:
        for line in file:
            log_time = parse_log_time(line)
            if log_time and log_time > threshold_time and ',Send,' in line:
                send_logs.append(line.strip())

    return send_logs

if __name__ == "__main__":
    if len(sys.argv) < 2:
        print("Usage: python find_recent_send_logs.py <path_to_log_file>")
        sys.exit(1)

    file_path = sys.argv[1]
    recent_send_logs = find_recent_send_logs(file_path)
    for log in recent_send_logs:
        print(log)

