#!/bin/bash

source ~/.gamerc

DATE="$(date +%s.%N)"
DATE_7_DAYS_AGO="$(date -d "-7 days" +%s)"
DATE_24_HOURS_AGO="$(date -d "-1 day" +%s)"

sendscript allgamedb nohostname nosave <<< 'source ~/.gamerc;DATE_7_DAYS_AGO="$(date -d "-7 days" +%s)";DATE_24_HOURS_AGO="$(date -d "-1 day" +%s)"
echo -n $GAME_TYPE,$COUNTRY_CODE,$(get_set $(awk -F_ "{print \$1}" <<< $HOST_NAME)),$(date +%s.%N),
psql $* $GAME_DB_NAME$(get_set $(awk -F_ "{print \$1}" <<< $HOST_NAME)) <<< " \
copy (select pg_supernice()) to stdout csv ; \
copy (select sum(gold) from player_characters) to stdout csv; \
copy (select sum(gold) from player_mail where cod = 0) to stdout csv; \
copy (select sum(gold) from player_characters where privilege = 0) to stdout csv; \
copy (select sum(gold) from player_characters where privilege = 0 and last_saving_time > $DATE_7_DAYS_AGO) to stdout csv; \
copy (select sum(gold) from player_characters where privilege = 0 and last_saving_time > $DATE_24_HOURS_AGO) to stdout csv; \
copy (select sum(gold) from player_characters where privilege = 0 and login_time_limit is not null) to stdout csv; \
copy (select stddev(gold) from player_characters where privilege = 0) to stdout csv; \
copy (select stddev(gold) from player_characters where privilege = 0 and last_saving_time > $DATE_7_DAYS_AGO) to stdout csv; \
copy (select stddev(gold) from player_characters where privilege = 0 and last_saving_time > $DATE_24_HOURS_AGO) to stdout csv; \
copy (select count(gold) from player_characters where privilege = 0) to stdout csv; \
copy (select count(gold) from player_characters where privilege = 0 and last_saving_time > $DATE_7_DAYS_AGO) to stdout csv; \
copy (select count(gold) from player_characters where privilege = 0 and last_saving_time > $DATE_24_HOURS_AGO) to stdout csv; \
"|grep -v "^\"\"$"|tr "\n" ,;echo' |tee /tmp/moneysupply-$DATE

to188 /tmp/moneysupply-$DATE
[ -e ~/www/moneysupply/moneysupply.sh ] && ~/www/moneysupply/moneysupply.sh
rm -fv /tmp/moneysupply-$DATE
