#!/usr/bin/env python33

import os
import sys
import optparse
import gzip
import lzma
#import tarfile
import glob
import datetime

def main():
    operation = optparse.OptionParser()
    operation.add_option('-s', '--start', dest='start_time', default=False, help='log start time')
    operation.add_option('-e', '--end', dest='end_time', default=False, help='log end time')
    operation.add_option('-t', '--type', dest='log_type', default='*.log.[0-9][0-9][0-9][0-9].*', help="log type, E.X. 'Item*.log.*' or  'Auction*log*'")
    operation.add_option('-l', '--list', dest='list_file', action='store_true', default=False, help='list all log file to cat ')
    (opt, argv) = operation.parse_args()
    #FileType = '*.log.[0-9][0-9][0-9][0-9].*'
    FileType = opt.log_type
    #print(opt, argv)
    #a = os.listdir(argv[0])
    #print(a)
    #path = argv[0]
    StartTime = None
    EndTime = None
    if opt.start_time:
        StartTime = datetime.datetime.strptime(opt.start_time, '%Y%m%d')
        StartTime = StartTime.date()
    if opt.end_time:
        EndTime = datetime.datetime.strptime(opt.end_time, '%Y%m%d')
        EndTime = EndTime.date()
    else:
        EndTime = datetime.datetime.now().date()
    if StartTime and EndTime:
        if StartTime > EndTime:
            StartTime, EndTime = EndTime, StartTime
    #if opt.log_type:
    #    FileType = opt.log_type

    AllPath = []
    FileList = []
    for x in argv:
        for root, dirs, files in os.walk(x):
            AllPath.append(root)
        if os.path.isfile(x):
            FileList.append(x)
        #print(files)
        #for f in files:
            #print(os.path.join(root, f))
    #print(AllPath)
    for path in AllPath:
        #print(path)
        #FileList = FileList + glob.glob(path+FileType)
        GlobDir = path + '/' + FileType
        FileList = FileList + glob.glob(GlobDir)
    CatList = []
    if StartTime:
        for TheFile in FileList:
            fstat = os.stat(TheFile)
            fmtime = datetime.datetime.fromtimestamp(fstat.st_mtime)
            fmdate = fmtime.date()
            #print(fmdate)
            if fmdate >= StartTime and fmdate <= EndTime:
                CatList.append(TheFile)
    else:
        CatList = FileList
    if opt.list_file:
        for x in CatList:
            print(x)
    #print(CatList)
    #return
    for x in CatList:
        try:
            #with gzip.open(x, 'rb') as f:
            #    file_content = f.readline()
            #    print(file_content)
            #print(gzip.open(x, 'rb').readline(), end='')
            gz = gzip.open(x, 'rt')
            for x in gz:
                print(x, end='')
            #gz = gz.decode('utf-8')
            continue
        except:
            #print('not gzip')
            pass
        try:
            print(lzma.open(x,'rt').read(), end='')
            continue
        except:
            #print('not lzma')
            pass
        #try:
        #    print(tarfile.open(x, 'r').read(), end='')
        #    continue
        #except:
            #print('not file')
        #    pass

        try:
            print(open(x, 'rt').read(), end='')
            continue
        except:
            #print('not file')
            pass


if __name__ == '__main__':
    main()

