/*
 * Decompiled with CFR 0.152.
 */
package com.android;

import com.google.common.base.Preconditions;
import java.util.concurrent.CancellationException;

public abstract class ProgressManagerAdapter {
    private static ProgressManagerAdapter ourInstance;

    public static void checkCanceled() {
        ProgressManagerAdapter instance = ourInstance;
        if (instance != null) {
            instance.doCheckCanceled();
        }
    }

    public static void throwIfCancellation(Throwable t4) {
        ProgressManagerAdapter instance = ourInstance;
        if (instance == null) {
            ProgressManagerAdapter.throwIfCancellationException(t4);
        } else {
            instance.doThrowIfCancellation(t4);
        }
    }

    protected abstract void doCheckCanceled();

    protected void doThrowIfCancellation(Throwable t4) {
        ProgressManagerAdapter.throwIfCancellationException(t4);
    }

    private static void throwIfCancellationException(Throwable t4) {
        if (t4 instanceof CancellationException) {
            throw (CancellationException)t4;
        }
    }

    protected static void setInstance(ProgressManagerAdapter instance) {
        Preconditions.checkState(ourInstance == null);
        ourInstance = instance;
    }
}

