/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.util;

import com.android.apksig.internal.asn1.Asn1BerParser;
import com.android.apksig.internal.asn1.Asn1DecodingException;
import com.android.apksig.internal.asn1.Asn1DerEncoder;
import com.android.apksig.internal.asn1.Asn1EncodingException;
import com.android.apksig.internal.util.ByteStreams;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;

public class X509CertificateUtils {
    private static CertificateFactory sCertFactory = null;
    public static final byte[] BEGIN_CERT_HEADER = "-----BEGIN CERTIFICATE-----".getBytes();
    public static final byte[] END_CERT_FOOTER = "-----END CERTIFICATE-----".getBytes();

    private static void buildCertFactory() {
        if (sCertFactory != null) {
            return;
        }
        try {
            sCertFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e5) {
            throw new RuntimeException("Failed to create X.509 CertificateFactory", e5);
        }
    }

    public static X509Certificate generateCertificate(InputStream in) throws CertificateException {
        byte[] encodedForm;
        try {
            encodedForm = ByteStreams.toByteArray(in);
        }
        catch (IOException e5) {
            throw new CertificateException("Failed to parse certificate", e5);
        }
        return X509CertificateUtils.generateCertificate(encodedForm);
    }

    public static X509Certificate generateCertificate(byte[] encodedForm) throws CertificateException {
        if (sCertFactory == null) {
            X509CertificateUtils.buildCertFactory();
        }
        return X509CertificateUtils.generateCertificate(encodedForm, sCertFactory);
    }

    public static X509Certificate generateCertificate(byte[] encodedForm, CertificateFactory certFactory) throws CertificateException {
        try {
            X509Certificate certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(encodedForm));
            return certificate;
        }
        catch (CertificateException certificateException) {
            try {
                ByteBuffer encodedCertBuffer = X509CertificateUtils.getNextDEREncodedCertificateBlock(ByteBuffer.wrap(encodedForm));
                int startingPos = encodedCertBuffer.position();
                com.android.apksig.internal.x509.Certificate reencodedCert = Asn1BerParser.parse(encodedCertBuffer, com.android.apksig.internal.x509.Certificate.class);
                byte[] reencodedForm = Asn1DerEncoder.encode(reencodedCert);
                X509Certificate certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(reencodedForm));
                byte[] originalEncoding = new byte[encodedCertBuffer.position() - startingPos];
                encodedCertBuffer.position(startingPos);
                encodedCertBuffer.get(originalEncoding);
                GuaranteedEncodedFormX509Certificate guaranteedEncodedCert = new GuaranteedEncodedFormX509Certificate(certificate, originalEncoding);
                return guaranteedEncodedCert;
            }
            catch (Asn1DecodingException | Asn1EncodingException | CertificateException e5) {
                throw new CertificateException("Failed to parse certificate", e5);
            }
        }
    }

    public static Collection<? extends Certificate> generateCertificates(InputStream in) throws CertificateException {
        if (sCertFactory == null) {
            X509CertificateUtils.buildCertFactory();
        }
        return X509CertificateUtils.generateCertificates(in, sCertFactory);
    }

    public static Collection<? extends Certificate> generateCertificates(InputStream in, CertificateFactory certFactory) throws CertificateException {
        byte[] encodedCerts;
        try {
            encodedCerts = ByteStreams.toByteArray(in);
        }
        catch (IOException e5) {
            throw new CertificateException("Failed to read the input stream", e5);
        }
        try {
            return certFactory.generateCertificates(new ByteArrayInputStream(encodedCerts));
        }
        catch (CertificateException e5) {
            try {
                ArrayList<GuaranteedEncodedFormX509Certificate> certificates = new ArrayList<GuaranteedEncodedFormX509Certificate>(1);
                ByteBuffer encodedCertsBuffer = ByteBuffer.wrap(encodedCerts);
                while (encodedCertsBuffer.hasRemaining()) {
                    ByteBuffer certBuffer = X509CertificateUtils.getNextDEREncodedCertificateBlock(encodedCertsBuffer);
                    int startingPos = certBuffer.position();
                    com.android.apksig.internal.x509.Certificate reencodedCert = Asn1BerParser.parse(certBuffer, com.android.apksig.internal.x509.Certificate.class);
                    byte[] reencodedForm = Asn1DerEncoder.encode(reencodedCert);
                    X509Certificate certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(reencodedForm));
                    byte[] originalEncoding = new byte[certBuffer.position() - startingPos];
                    certBuffer.position(startingPos);
                    certBuffer.get(originalEncoding);
                    GuaranteedEncodedFormX509Certificate guaranteedEncodedCert = new GuaranteedEncodedFormX509Certificate(certificate, originalEncoding);
                    certificates.add(guaranteedEncodedCert);
                }
                return certificates;
            }
            catch (Asn1DecodingException | Asn1EncodingException e6) {
                throw new CertificateException("Failed to parse certificates", e6);
            }
        }
    }

    private static ByteBuffer getNextDEREncodedCertificateBlock(ByteBuffer certificateBuffer) throws CertificateException {
        char trailingChar;
        char encodedChar;
        if (certificateBuffer == null) {
            throw new NullPointerException("The certificateBuffer cannot be null");
        }
        if (certificateBuffer.remaining() < BEGIN_CERT_HEADER.length) {
            return certificateBuffer;
        }
        certificateBuffer.mark();
        for (int i4 = 0; i4 < BEGIN_CERT_HEADER.length; ++i4) {
            if (certificateBuffer.get() == BEGIN_CERT_HEADER[i4]) continue;
            certificateBuffer.reset();
            return certificateBuffer;
        }
        StringBuilder pemEncoding = new StringBuilder();
        while (certificateBuffer.hasRemaining() && (encodedChar = (char)certificateBuffer.get()) != '-') {
            if (Character.isWhitespace(encodedChar)) continue;
            pemEncoding.append(encodedChar);
        }
        for (int i5 = 1; i5 < END_CERT_FOOTER.length; ++i5) {
            if (!certificateBuffer.hasRemaining()) {
                throw new CertificateException("The provided input contains the PEM certificate header but does not contain sufficient data for the footer");
            }
            if (certificateBuffer.get() == END_CERT_FOOTER[i5]) continue;
            throw new CertificateException("The provided input contains the PEM certificate header without a valid certificate footer");
        }
        byte[] derEncoding = Base64.getDecoder().decode(pemEncoding.toString());
        int nextEncodedChar = certificateBuffer.position();
        while (certificateBuffer.hasRemaining() && Character.isWhitespace(trailingChar = (char)certificateBuffer.get())) {
            ++nextEncodedChar;
        }
        certificateBuffer.position(nextEncodedChar);
        return ByteBuffer.wrap(derEncoding);
    }
}

