/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.commands.BuildApksModule;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.io.ApkPathManager;
import com.android.tools.build.bundletool.io.ApkSetBuilderFactory;
import com.android.tools.build.bundletool.io.ConcurrencyUtils;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.ApkListener;
import com.android.tools.build.bundletool.model.ApkModifier;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.GeneratedApks;
import com.android.tools.build.bundletool.model.GeneratedAssetSlices;
import com.android.tools.build.bundletool.model.ManifestDeliveryElement;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.VariantKey;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.CollectorUtils;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class ApkSerializerManager {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final AppBundle appBundle;
    private final ApkListener apkListener;
    private final ApkModifier apkModifier;
    private final ListeningExecutorService executorService;
    private final int firstVariantNumber;
    private final boolean verbose;
    private final ApkPathManager apkPathManager;
    private final ApkOptimizations apkOptimizations;

    @Inject
    public ApkSerializerManager(AppBundle appBundle, Optional<ApkListener> apkListener, Optional<ApkModifier> apkModifier, ListeningExecutorService executorService, @BuildApksModule.FirstVariantNumber Optional<Integer> firstVariantNumber, @BuildApksModule.VerboseLogs boolean verbose, ApkPathManager apkPathManager, ApkOptimizations apkOptimizations) {
        this.appBundle = appBundle;
        this.apkListener = apkListener.orElse(ApkListener.NO_OP);
        this.apkModifier = apkModifier.orElse(ApkModifier.NO_OP);
        this.executorService = executorService;
        this.firstVariantNumber = firstVariantNumber.orElse(0);
        this.verbose = verbose;
        this.apkPathManager = apkPathManager;
        this.apkOptimizations = apkOptimizations;
    }

    public void populateApkSetBuilder(ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, GeneratedApks generatedApks, GeneratedAssetSlices generatedAssetSlices, BuildApksCommand.ApkBuildMode apkBuildMode, Optional<Devices.DeviceSpec> deviceSpec, Commands.LocalTestingInfo localTestingInfo) {
        ImmutableList<Commands.Variant> allVariantsWithTargeting = this.serializeApks(apkSetBuilder, generatedApks, apkBuildMode, deviceSpec);
        ImmutableList<Commands.AssetSliceSet> allAssetSliceSets = this.serializeAssetSlices(apkSetBuilder, generatedAssetSlices, apkBuildMode, deviceSpec);
        Commands.BuildApksResult.Builder apksResult = Commands.BuildApksResult.newBuilder().setPackageName(this.appBundle.getPackageName()).addAllVariant(allVariantsWithTargeting).setBundletool(Config.Bundletool.newBuilder().setVersion(BundleToolVersion.getCurrentVersion().toString())).addAllAssetSliceSet(allAssetSliceSets).setLocalTestingInfo(localTestingInfo);
        if (this.appBundle.getBundleConfig().hasAssetModulesConfig()) {
            apksResult.setAssetModulesInfo(ApkSerializerManager.getAssetModulesInfo(this.appBundle.getBundleConfig().getAssetModulesConfig()));
        }
        apksResult.addAllDefaultTargetingValue(ApkSerializerManager.getDefaultTargetingValues(this.appBundle.getBundleConfig()));
        apkSetBuilder.setTableOfContentsFile(apksResult.build());
    }

    @VisibleForTesting
    ImmutableList<Commands.Variant> serializeApksForDevice(ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, GeneratedApks generatedApks, Devices.DeviceSpec deviceSpec, BuildApksCommand.ApkBuildMode apkBuildMode) {
        return this.serializeApks(apkSetBuilder, generatedApks, apkBuildMode, Optional.of(deviceSpec));
    }

    @VisibleForTesting
    ImmutableList<Commands.Variant> serializeApks(ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, GeneratedApks generatedApks) {
        return this.serializeApks(apkSetBuilder, generatedApks, BuildApksCommand.ApkBuildMode.DEFAULT);
    }

    @VisibleForTesting
    ImmutableList<Commands.Variant> serializeApks(ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, GeneratedApks generatedApks, BuildApksCommand.ApkBuildMode apkBuildMode) {
        return this.serializeApks(apkSetBuilder, generatedApks, apkBuildMode, Optional.empty());
    }

    private ImmutableList<Commands.Variant> serializeApks(ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, GeneratedApks generatedApks, BuildApksCommand.ApkBuildMode apkBuildMode, Optional<Devices.DeviceSpec> deviceSpec) {
        ApkSerializerManager.validateInput(generatedApks, apkBuildMode);
        Predicate deviceFilter = deviceSpec.isPresent() && !apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.SYSTEM) ? new ApkMatcher(this.addDefaultDeviceTierIfNecessary(deviceSpec.get()))::matchesModuleSplitByTargeting : Predicates.alwaysTrue();
        ImmutableListMultimap<VariantKey, ModuleSplit> splitsByVariant = generatedApks.getAllApksGroupedByOrderedVariants();
        AtomicInteger variantNumberCounter = new AtomicInteger(this.firstVariantNumber);
        ImmutableMap variantNumberByVariantKey = splitsByVariant.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), unused -> variantNumberCounter.getAndIncrement()));
        ApkSerializer apkSerializer = new ApkSerializer(this.apkListener, apkBuildMode);
        ImmutableListMultimap<VariantKey, ModuleSplit> finalSplitsByVariant = splitsByVariant.entries().stream().filter(keyModuleSplitEntry -> deviceFilter.test(keyModuleSplitEntry.getValue())).collect(CollectorUtils.groupingBySortedKeys(Map.Entry::getKey, entry -> ApkSerializerManager.clearVariantTargeting(this.modifyApk((ModuleSplit)entry.getValue(), (Integer)variantNumberByVariantKey.get(entry.getKey())))));
        ImmutableMap apkDescriptionBySplit = finalSplitsByVariant.values().stream().distinct().collect(Collectors.collectingAndThen(ImmutableMap.toImmutableMap(Function.identity(), split -> {
            ZipPath apkPath = this.apkPathManager.getApkPath((ModuleSplit)split);
            return this.executorService.submit(() -> apkSerializer.serialize(apkSetBuilder, (ModuleSplit)split, apkPath));
        }), ConcurrencyUtils::waitForAll));
        ImmutableList.Builder variants = ImmutableList.builder();
        for (VariantKey variantKey : finalSplitsByVariant.keySet()) {
            Commands.Variant.Builder variant = Commands.Variant.newBuilder().setVariantNumber(variantNumberByVariantKey.get(variantKey)).setTargeting(variantKey.getVariantTargeting());
            Multimap splitsByModuleName = finalSplitsByVariant.get((Object)variantKey).stream().collect(CollectorUtils.groupingBySortedKeys(ModuleSplit::getModuleName));
            for (BundleModuleName moduleName : splitsByModuleName.keySet()) {
                variant.addApkSet(Commands.ApkSet.newBuilder().setModuleMetadata(this.appBundle.getModule(moduleName).getModuleMetadata()).addAllApkDescription(splitsByModuleName.get(moduleName).stream().map(apkDescriptionBySplit::get).collect(ImmutableList.toImmutableList())));
            }
            variants.add(variant.build());
        }
        return variants.build();
    }

    @VisibleForTesting
    ImmutableList<Commands.AssetSliceSet> serializeAssetSlices(ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, GeneratedAssetSlices generatedAssetSlices, BuildApksCommand.ApkBuildMode apkBuildMode, Optional<Devices.DeviceSpec> deviceSpec) {
        Predicate deviceFilter = deviceSpec.isPresent() ? new ApkMatcher(this.addDefaultDeviceTierIfNecessary(deviceSpec.get()))::matchesModuleSplitByTargeting : Predicates.alwaysTrue();
        ApkSerializer apkSerializer = new ApkSerializer(this.apkListener, apkBuildMode);
        ImmutableListMultimap generatedSlicesByModule = generatedAssetSlices.getAssetSlices().stream().filter(deviceFilter).collect(CollectorUtils.groupingByDeterministic(ModuleSplit::getModuleName, Collectors.mapping(assetSlice -> {
            ZipPath apkPath = this.apkPathManager.getApkPath((ModuleSplit)assetSlice);
            return this.executorService.submit(() -> apkSerializer.serialize(apkSetBuilder, (ModuleSplit)assetSlice, apkPath));
        }, ImmutableList.toImmutableList()))).entrySet().stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(Map.Entry::getKey, entry -> ConcurrencyUtils.waitForAll((Iterable)entry.getValue()).stream()));
        return ((ImmutableMap)generatedSlicesByModule.asMap()).entrySet().stream().map(entry -> Commands.AssetSliceSet.newBuilder().setAssetModuleMetadata(this.getAssetModuleMetadata(this.appBundle.getModule((BundleModuleName)entry.getKey()))).addAllApkDescription((Iterable)entry.getValue()).build()).collect(ImmutableList.toImmutableList());
    }

    private Commands.AssetModuleMetadata getAssetModuleMetadata(BundleModule module) {
        AndroidManifest manifest = module.getAndroidManifest();
        Commands.AssetModuleMetadata.Builder metadataBuilder = Commands.AssetModuleMetadata.newBuilder().setName(module.getName().getName());
        Optional<ManifestDeliveryElement> persistentDelivery = manifest.getManifestDeliveryElement();
        metadataBuilder.setDeliveryType(persistentDelivery.map(delivery -> ApkSerializerManager.getDeliveryType(delivery)).orElse(Commands.DeliveryType.INSTALL_TIME));
        boolean isInstantModule = module.isInstantModule();
        Commands.InstantMetadata.Builder instantMetadataBuilder = Commands.InstantMetadata.newBuilder().setIsInstant(isInstantModule);
        Optional<ManifestDeliveryElement> instantDelivery = manifest.getInstantManifestDeliveryElement();
        if (isInstantModule) {
            instantMetadataBuilder.setDeliveryType(instantDelivery.map(delivery -> ApkSerializerManager.getDeliveryType(delivery)).orElse(Commands.DeliveryType.ON_DEMAND));
        }
        metadataBuilder.setInstantMetadata(instantMetadataBuilder.build());
        return metadataBuilder.build();
    }

    private static void validateInput(GeneratedApks generatedApks, BuildApksCommand.ApkBuildMode apkBuildMode) {
        switch (apkBuildMode) {
            case DEFAULT: {
                Preconditions.checkArgument(generatedApks.getSystemApks().isEmpty(), "Internal error: System APKs can only be set in system mode.");
                break;
            }
            case UNIVERSAL: {
                Preconditions.checkArgument(generatedApks.getSplitApks().isEmpty() && generatedApks.getInstantApks().isEmpty() && generatedApks.getSystemApks().isEmpty(), "Internal error: For universal APK expecting only standalone APKs.");
                break;
            }
            case SYSTEM: {
                Preconditions.checkArgument(generatedApks.getSplitApks().isEmpty() && generatedApks.getInstantApks().isEmpty() && generatedApks.getStandaloneApks().isEmpty(), "Internal error: For system mode expecting only system APKs.");
                break;
            }
            case PERSISTENT: {
                Preconditions.checkArgument(generatedApks.getSystemApks().isEmpty(), "Internal error: System APKs not expected with persistent mode.");
                Preconditions.checkArgument(generatedApks.getInstantApks().isEmpty(), "Internal error: Instant APKs not expected with persistent mode.");
                break;
            }
            case INSTANT: {
                Preconditions.checkArgument(generatedApks.getSystemApks().isEmpty(), "Internal error: System APKs not expected with instant mode.");
                Preconditions.checkArgument(generatedApks.getSplitApks().isEmpty() && generatedApks.getStandaloneApks().isEmpty(), "Internal error: Persistent APKs not expected with instant mode.");
            }
        }
    }

    private ModuleSplit modifyApk(ModuleSplit moduleSplit, int variantNumber) {
        ApkModifier.ApkDescription apkDescription = ApkModifier.ApkDescription.builder().setBase(moduleSplit.isBaseModuleSplit()).setApkType(moduleSplit.getSplitType().equals((Object)ModuleSplit.SplitType.STANDALONE) ? ApkModifier.ApkDescription.ApkType.STANDALONE : (moduleSplit.isMasterSplit() ? ApkModifier.ApkDescription.ApkType.MASTER_SPLIT : ApkModifier.ApkDescription.ApkType.CONFIG_SPLIT)).setVariantNumber(variantNumber).setVariantTargeting(moduleSplit.getVariantTargeting()).setApkTargeting(moduleSplit.getApkTargeting()).build();
        return moduleSplit.toBuilder().setAndroidManifest(this.apkModifier.modifyManifest(moduleSplit.getAndroidManifest(), apkDescription)).build();
    }

    private static ModuleSplit clearVariantTargeting(ModuleSplit moduleSplit) {
        return moduleSplit.toBuilder().setVariantTargeting(Targeting.VariantTargeting.getDefaultInstance()).build();
    }

    private static Commands.AssetModulesInfo getAssetModulesInfo(Config.AssetModulesConfig assetModulesConfig) {
        return Commands.AssetModulesInfo.newBuilder().addAllAppVersion(assetModulesConfig.getAppVersionList()).setAssetVersionTag(assetModulesConfig.getAssetVersionTag()).build();
    }

    private static ImmutableList<Commands.DefaultTargetingValue> getDefaultTargetingValues(Config.BundleConfig bundleConfig) {
        return bundleConfig.getOptimizations().getSplitsConfig().getSplitDimensionList().stream().filter(Config.SplitDimension::hasSuffixStripping).map(splitDimension -> Commands.DefaultTargetingValue.newBuilder().setDimension(splitDimension.getValue()).setDefaultValue(splitDimension.getSuffixStripping().getDefaultSuffix()).build()).collect(ImmutableList.toImmutableList());
    }

    private static Commands.DeliveryType getDeliveryType(ManifestDeliveryElement deliveryElement) {
        if (deliveryElement.hasOnDemandElement()) {
            return Commands.DeliveryType.ON_DEMAND;
        }
        if (deliveryElement.hasFastFollowElement()) {
            return Commands.DeliveryType.FAST_FOLLOW;
        }
        return Commands.DeliveryType.INSTALL_TIME;
    }

    private Devices.DeviceSpec addDefaultDeviceTierIfNecessary(Devices.DeviceSpec deviceSpec) {
        if (!deviceSpec.getDeviceTier().isEmpty()) {
            return deviceSpec;
        }
        Optional<Config.SuffixStripping> deviceTierSuffix = Optional.ofNullable(this.apkOptimizations.getSuffixStrippings().get((Object)OptimizationDimension.DEVICE_TIER));
        if (!deviceTierSuffix.isPresent()) {
            return deviceSpec;
        }
        return deviceSpec.toBuilder().setDeviceTier(deviceTierSuffix.get().getDefaultSuffix()).build();
    }

    private final class ApkSerializer {
        private final ApkListener apkListener;
        private final BuildApksCommand.ApkBuildMode apkBuildMode;

        public ApkSerializer(ApkListener apkListener, BuildApksCommand.ApkBuildMode apkBuildMode) {
            this.apkListener = apkListener;
            this.apkBuildMode = apkBuildMode;
        }

        public Commands.ApkDescription serialize(ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, ModuleSplit split, ZipPath apkPath) {
            Commands.ApkDescription apkDescription;
            switch (split.getSplitType()) {
                case INSTANT: {
                    apkDescription = apkSetBuilder.addInstantApk(split, apkPath);
                    break;
                }
                case SPLIT: {
                    apkDescription = apkSetBuilder.addSplitApk(split, apkPath);
                    break;
                }
                case SYSTEM: {
                    if (split.isBaseModuleSplit() && split.isMasterSplit()) {
                        apkDescription = apkSetBuilder.addSystemApk(split, apkPath);
                        break;
                    }
                    apkDescription = apkSetBuilder.addSplitApk(split, apkPath);
                    break;
                }
                case STANDALONE: {
                    apkDescription = this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.UNIVERSAL) ? apkSetBuilder.addStandaloneUniversalApk(split) : apkSetBuilder.addStandaloneApk(split, apkPath);
                    break;
                }
                case ASSET_SLICE: {
                    apkDescription = apkSetBuilder.addAssetSliceApk(split, apkPath);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected splitType: " + (Object)((Object)split.getSplitType()));
                }
            }
            this.apkListener.onApkFinalized(apkDescription);
            if (ApkSerializerManager.this.verbose) {
                System.out.printf("INFO: [%s] '%s' of type '%s' was written to disk.%n", new Object[]{LocalDateTime.now(ZoneId.systemDefault()).format(DATE_FORMATTER), apkPath, split.getSplitType()});
            }
            return apkDescription;
        }
    }
}

