/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Compressor;
import com.android.zipflinger.Ints;
import com.android.zipflinger.LargeFileSource;
import com.android.zipflinger.NoCopyByteArrayOutputStream;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

class StreamSource
extends Source {
    private static final int TMP_BUFFER_SIZE = 4096;
    private final NoCopyByteArrayOutputStream buffer = new NoCopyByteArrayOutputStream(4096);
    private Path tmpStore = null;
    private long tmpStoreSize = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamSource(InputStream src, String name, int compressionLevel, int largeLimit) throws IOException {
        super(name);
        long bytesRead = 0L;
        try (CheckedInputStream in = new CheckedInputStream(src, new CRC32());
             OutputStream out = this.getOutput(compressionLevel);){
            int read;
            byte[] bytes = new byte[4096];
            while ((read = in.read(bytes)) != -1) {
                out.write(bytes, 0, read);
                bytesRead += (long)read;
                if (this.buffer.getCount() <= largeLimit) continue;
                this.flushBuffer();
            }
            this.crc = Ints.longToUint(in.getChecksum().getValue());
        }
        finally {
            src.close();
        }
        this.compressedSize = (long)this.buffer.getCount() + this.tmpStoreSize;
        this.uncompressedSize = bytesRead;
        this.compressionFlag = compressionLevel == 0 ? (short)0 : (short)8;
    }

    private void flushBuffer() throws IOException {
        FileChannel fc;
        if (this.tmpStore == null) {
            this.tmpStore = LargeFileSource.getTmpStoragePath(this.getName());
            fc = FileChannel.open(this.tmpStore, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
            this.tmpStore.toFile().deleteOnExit();
        } else {
            fc = FileChannel.open(this.tmpStore, StandardOpenOption.APPEND);
        }
        try (FileChannel channel = fc;){
            ByteBuffer b5 = this.buffer.getByteBuffer();
            this.tmpStoreSize += (long)b5.remaining();
            channel.write(b5);
            this.buffer.reset();
        }
    }

    private OutputStream getOutput(int compressionLevel) {
        if (compressionLevel == 0) {
            return this.buffer;
        }
        Deflater deflater = Compressor.getDeflater(compressionLevel);
        return new DeflaterOutputStream((OutputStream)this.buffer, deflater);
    }

    @Override
    public void prepare() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long writeTo(ZipWriter writer) throws IOException {
        if (this.tmpStore != null) {
            try (FileChannel src = FileChannel.open(this.tmpStore, StandardOpenOption.READ);){
                writer.transferFrom(src, 0L, this.tmpStoreSize);
            }
            finally {
                Files.delete(this.tmpStore);
            }
        }
        writer.write(this.buffer.getByteBuffer());
        return (long)this.buffer.getCount() + this.tmpStoreSize;
    }
}

