/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.CharEscaper;
import com.google.common.escape.Escaper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.Map;

@Beta
@GwtCompatible
public final class CharEscaperBuilder {
    private final Map<Character, String> map = new HashMap<Character, String>();
    private int max = -1;

    @CanIgnoreReturnValue
    public CharEscaperBuilder addEscape(char c5, String r4) {
        this.map.put(Character.valueOf(c5), Preconditions.checkNotNull(r4));
        if (c5 > this.max) {
            this.max = c5;
        }
        return this;
    }

    @CanIgnoreReturnValue
    public CharEscaperBuilder addEscapes(char[] cs, String r4) {
        Preconditions.checkNotNull(r4);
        for (char c5 : cs) {
            this.addEscape(c5, r4);
        }
        return this;
    }

    public char[][] toArray() {
        char[][] result = new char[this.max + 1][];
        for (Map.Entry<Character, String> entry : this.map.entrySet()) {
            result[entry.getKey().charValue()] = entry.getValue().toCharArray();
        }
        return result;
    }

    public Escaper toEscaper() {
        return new CharArrayDecorator(this.toArray());
    }

    private static class CharArrayDecorator
    extends CharEscaper {
        private final char[][] replacements;
        private final int replaceLength;

        CharArrayDecorator(char[][] replacements) {
            this.replacements = replacements;
            this.replaceLength = replacements.length;
        }

        @Override
        public String escape(String s4) {
            int slen = s4.length();
            for (int index = 0; index < slen; ++index) {
                char c5 = s4.charAt(index);
                if (c5 >= this.replacements.length || this.replacements[c5] == null) continue;
                return this.escapeSlow(s4, index);
            }
            return s4;
        }

        @Override
        protected char[] escape(char c5) {
            return c5 < this.replaceLength ? this.replacements[c5] : null;
        }
    }
}

