/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CertResponse;

public class CertRepMessage
extends ASN1Object {
    private ASN1Sequence caPubs;
    private ASN1Sequence response;

    private CertRepMessage(ASN1Sequence aSN1Sequence) {
        int n4 = 0;
        if (aSN1Sequence.size() > 1) {
            this.caPubs = ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n4++), true);
        }
        this.response = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(n4));
    }

    public static CertRepMessage getInstance(Object object) {
        if (object instanceof CertRepMessage) {
            return (CertRepMessage)object;
        }
        if (object != null) {
            return new CertRepMessage(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CertRepMessage(CMPCertificate[] cMPCertificateArray, CertResponse[] certResponseArray) {
        int n4;
        ASN1EncodableVector aSN1EncodableVector;
        if (certResponseArray == null) {
            throw new IllegalArgumentException("'response' cannot be null");
        }
        if (cMPCertificateArray != null) {
            aSN1EncodableVector = new ASN1EncodableVector();
            for (n4 = 0; n4 < cMPCertificateArray.length; ++n4) {
                aSN1EncodableVector.add(cMPCertificateArray[n4]);
            }
            this.caPubs = new DERSequence(aSN1EncodableVector);
        }
        aSN1EncodableVector = new ASN1EncodableVector();
        for (n4 = 0; n4 < certResponseArray.length; ++n4) {
            aSN1EncodableVector.add(certResponseArray[n4]);
        }
        this.response = new DERSequence(aSN1EncodableVector);
    }

    public CMPCertificate[] getCaPubs() {
        if (this.caPubs == null) {
            return null;
        }
        CMPCertificate[] cMPCertificateArray = new CMPCertificate[this.caPubs.size()];
        for (int i4 = 0; i4 != cMPCertificateArray.length; ++i4) {
            cMPCertificateArray[i4] = CMPCertificate.getInstance(this.caPubs.getObjectAt(i4));
        }
        return cMPCertificateArray;
    }

    public CertResponse[] getResponse() {
        CertResponse[] certResponseArray = new CertResponse[this.response.size()];
        for (int i4 = 0; i4 != certResponseArray.length; ++i4) {
            certResponseArray[i4] = CertResponse.getInstance(this.response.getObjectAt(i4));
        }
        return certResponseArray;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.caPubs != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.caPubs));
        }
        aSN1EncodableVector.add(this.response);
        return new DERSequence(aSN1EncodableVector);
    }
}

