/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class RC6Engine
implements BlockCipher {
    private static final int wordSize = 32;
    private static final int bytesPerWord = 4;
    private static final int _noRounds = 20;
    private int[] _S = null;
    private static final int P32 = -1209970333;
    private static final int Q32 = -1640531527;
    private static final int LGW = 5;
    private boolean forEncryption;

    public String getAlgorithmName() {
        return "RC6";
    }

    public int getBlockSize() {
        return 16;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to RC6 init - " + cipherParameters.getClass().getName());
        }
        KeyParameter keyParameter = (KeyParameter)cipherParameters;
        this.forEncryption = bl;
        this.setKey(keyParameter.getKey());
    }

    public int processBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6 = this.getBlockSize();
        if (this._S == null) {
            throw new IllegalStateException("RC6 engine not initialised");
        }
        if (n4 + n6 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n5 + n6 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        return this.forEncryption ? this.encryptBlock(byArray, n4, byArray2, n5) : this.decryptBlock(byArray, n4, byArray2, n5);
    }

    public void reset() {
    }

    private void setKey(byte[] byArray) {
        int n4;
        int n5 = (byArray.length + 3) / 4;
        if (n5 == 0) {
            n5 = 1;
        }
        int[] nArray = new int[(byArray.length + 4 - 1) / 4];
        for (n4 = byArray.length - 1; n4 >= 0; --n4) {
            nArray[n4 / 4] = (nArray[n4 / 4] << 8) + (byArray[n4] & 0xFF);
        }
        this._S = new int[44];
        this._S[0] = -1209970333;
        for (n4 = 1; n4 < this._S.length; ++n4) {
            this._S[n4] = this._S[n4 - 1] + -1640531527;
        }
        n4 = nArray.length > this._S.length ? 3 * nArray.length : 3 * this._S.length;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (int i4 = 0; i4 < n4; ++i4) {
            n6 = this._S[n8] = this.rotateLeft(this._S[n8] + n6 + n7, 3);
            n7 = nArray[n9] = this.rotateLeft(nArray[n9] + n6 + n7, n6 + n7);
            n8 = (n8 + 1) % this._S.length;
            n9 = (n9 + 1) % nArray.length;
        }
    }

    private int encryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6 = this.bytesToWord(byArray, n4);
        int n7 = this.bytesToWord(byArray, n4 + 4);
        int n8 = this.bytesToWord(byArray, n4 + 8);
        int n9 = this.bytesToWord(byArray, n4 + 12);
        n7 += this._S[0];
        n9 += this._S[1];
        for (int i4 = 1; i4 <= 20; ++i4) {
            int n10 = 0;
            int n11 = 0;
            n10 = n7 * (2 * n7 + 1);
            n10 = this.rotateLeft(n10, 5);
            n11 = n9 * (2 * n9 + 1);
            n11 = this.rotateLeft(n11, 5);
            n6 ^= n10;
            n6 = this.rotateLeft(n6, n11);
            n8 ^= n11;
            n8 = this.rotateLeft(n8, n10);
            int n12 = n6 += this._S[2 * i4];
            n6 = n7;
            n7 = n8 += this._S[2 * i4 + 1];
            n8 = n9;
            n9 = n12;
        }
        this.wordToBytes(n6 += this._S[42], byArray2, n5);
        this.wordToBytes(n7, byArray2, n5 + 4);
        this.wordToBytes(n8 += this._S[43], byArray2, n5 + 8);
        this.wordToBytes(n9, byArray2, n5 + 12);
        return 16;
    }

    private int decryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6 = this.bytesToWord(byArray, n4);
        int n7 = this.bytesToWord(byArray, n4 + 4);
        int n8 = this.bytesToWord(byArray, n4 + 8);
        int n9 = this.bytesToWord(byArray, n4 + 12);
        n8 -= this._S[43];
        n6 -= this._S[42];
        for (int i4 = 20; i4 >= 1; --i4) {
            int n10 = 0;
            int n11 = 0;
            int n12 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n6;
            n6 = n12;
            n10 = n7 * (2 * n7 + 1);
            n10 = this.rotateLeft(n10, 5);
            n11 = n9 * (2 * n9 + 1);
            n11 = this.rotateLeft(n11, 5);
            n8 -= this._S[2 * i4 + 1];
            n8 = this.rotateRight(n8, n10);
            n8 ^= n11;
            n6 -= this._S[2 * i4];
            n6 = this.rotateRight(n6, n11);
            n6 ^= n10;
        }
        this.wordToBytes(n6, byArray2, n5);
        this.wordToBytes(n7 -= this._S[0], byArray2, n5 + 4);
        this.wordToBytes(n8, byArray2, n5 + 8);
        this.wordToBytes(n9 -= this._S[1], byArray2, n5 + 12);
        return 16;
    }

    private int rotateLeft(int n4, int n5) {
        return n4 << n5 | n4 >>> -n5;
    }

    private int rotateRight(int n4, int n5) {
        return n4 >>> n5 | n4 << -n5;
    }

    private int bytesToWord(byte[] byArray, int n4) {
        int n5 = 0;
        for (int i4 = 3; i4 >= 0; --i4) {
            n5 = (n5 << 8) + (byArray[i4 + n4] & 0xFF);
        }
        return n5;
    }

    private void wordToBytes(int n4, byte[] byArray, int n5) {
        for (int i4 = 0; i4 < 4; ++i4) {
            byArray[i4 + n5] = (byte)n4;
            n4 >>>= 8;
        }
    }
}

