/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class RFC3211WrapEngine
implements Wrapper {
    private CBCBlockCipher engine;
    private ParametersWithIV param;
    private boolean forWrapping;
    private SecureRandom rand;

    public RFC3211WrapEngine(BlockCipher blockCipher) {
        this.engine = new CBCBlockCipher(blockCipher);
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forWrapping = bl;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.rand = parametersWithRandom.getRandom();
            this.param = (ParametersWithIV)parametersWithRandom.getParameters();
        } else {
            if (bl) {
                this.rand = new SecureRandom();
            }
            this.param = (ParametersWithIV)cipherParameters;
        }
    }

    public String getAlgorithmName() {
        return this.engine.getUnderlyingCipher().getAlgorithmName() + "/RFC3211Wrap";
    }

    public byte[] wrap(byte[] byArray, int n4, int n5) {
        int n6;
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        this.engine.init(true, this.param);
        int n7 = this.engine.getBlockSize();
        byte[] byArray2 = n5 + 4 < n7 * 2 ? new byte[n7 * 2] : new byte[(n5 + 4) % n7 == 0 ? n5 + 4 : ((n5 + 4) / n7 + 1) * n7];
        byArray2[0] = (byte)n5;
        byArray2[1] = ~byArray[n4];
        byArray2[2] = ~byArray[n4 + 1];
        byArray2[3] = ~byArray[n4 + 2];
        System.arraycopy(byArray, n4, byArray2, 4, n5);
        byte[] byArray3 = new byte[byArray2.length - (n5 + 4)];
        this.rand.nextBytes(byArray3);
        System.arraycopy(byArray3, 0, byArray2, n5 + 4, byArray3.length);
        for (n6 = 0; n6 < byArray2.length; n6 += n7) {
            this.engine.processBlock(byArray2, n6, byArray2, n6);
        }
        for (n6 = 0; n6 < byArray2.length; n6 += n7) {
            this.engine.processBlock(byArray2, n6, byArray2, n6);
        }
        return byArray2;
    }

    public byte[] unwrap(byte[] byArray, int n4, int n5) throws InvalidCipherTextException {
        int n6;
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n7 = this.engine.getBlockSize();
        if (n5 < 2 * n7) {
            throw new InvalidCipherTextException("input too short");
        }
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[n7];
        System.arraycopy(byArray, n4, byArray2, 0, n5);
        System.arraycopy(byArray, n4, byArray3, 0, byArray3.length);
        this.engine.init(false, new ParametersWithIV(this.param.getParameters(), byArray3));
        for (n6 = n7; n6 < byArray2.length; n6 += n7) {
            this.engine.processBlock(byArray2, n6, byArray2, n6);
        }
        System.arraycopy(byArray2, byArray2.length - byArray3.length, byArray3, 0, byArray3.length);
        this.engine.init(false, new ParametersWithIV(this.param.getParameters(), byArray3));
        this.engine.processBlock(byArray2, 0, byArray2, 0);
        this.engine.init(false, this.param);
        for (n6 = 0; n6 < byArray2.length; n6 += n7) {
            this.engine.processBlock(byArray2, n6, byArray2, n6);
        }
        if ((byArray2[0] & 0xFF) > byArray2.length - 4) {
            throw new InvalidCipherTextException("wrapped key corrupted");
        }
        byte[] byArray4 = new byte[byArray2[0] & 0xFF];
        System.arraycopy(byArray2, 4, byArray4, 0, byArray2[0]);
        int n8 = 0;
        for (int i4 = 0; i4 != 3; ++i4) {
            byte by = ~byArray2[1 + i4];
            n8 |= by ^ byArray4[i4];
        }
        if (n8 != 0) {
            throw new InvalidCipherTextException("wrapped key fails checksum");
        }
        return byArray4;
    }
}

