/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class XTEAEngine
implements BlockCipher {
    private static final int rounds = 32;
    private static final int block_size = 8;
    private static final int delta = -1640531527;
    private int[] _S = new int[4];
    private int[] _sum0 = new int[32];
    private int[] _sum1 = new int[32];
    private boolean _initialised = false;
    private boolean _forEncryption;

    public String getAlgorithmName() {
        return "XTEA";
    }

    public int getBlockSize() {
        return 8;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to TEA init - " + cipherParameters.getClass().getName());
        }
        this._forEncryption = bl;
        this._initialised = true;
        KeyParameter keyParameter = (KeyParameter)cipherParameters;
        this.setKey(keyParameter.getKey());
    }

    public int processBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        if (!this._initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (n4 + 8 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n5 + 8 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        return this._forEncryption ? this.encryptBlock(byArray, n4, byArray2, n5) : this.decryptBlock(byArray, n4, byArray2, n5);
    }

    public void reset() {
    }

    private void setKey(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Key size must be 128 bits.");
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < 4) {
            this._S[n5] = this.bytesToInt(byArray, n4);
            ++n5;
            n4 += 4;
        }
        n4 = 0;
        for (n5 = 0; n5 < 32; ++n5) {
            this._sum0[n5] = n4 + this._S[n4 & 3];
            this._sum1[n5] = (n4 -= 1640531527) + this._S[n4 >>> 11 & 3];
        }
    }

    private int encryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6 = this.bytesToInt(byArray, n4);
        int n7 = this.bytesToInt(byArray, n4 + 4);
        for (int i4 = 0; i4 < 32; ++i4) {
            n7 += ((n6 += (n7 << 4 ^ n7 >>> 5) + n7 ^ this._sum0[i4]) << 4 ^ n6 >>> 5) + n6 ^ this._sum1[i4];
        }
        this.unpackInt(n6, byArray2, n5);
        this.unpackInt(n7, byArray2, n5 + 4);
        return 8;
    }

    private int decryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6 = this.bytesToInt(byArray, n4);
        int n7 = this.bytesToInt(byArray, n4 + 4);
        for (int i4 = 31; i4 >= 0; --i4) {
            n6 -= ((n7 -= (n6 << 4 ^ n6 >>> 5) + n6 ^ this._sum1[i4]) << 4 ^ n7 >>> 5) + n7 ^ this._sum0[i4];
        }
        this.unpackInt(n6, byArray2, n5);
        this.unpackInt(n7, byArray2, n5 + 4);
        return 8;
    }

    private int bytesToInt(byte[] byArray, int n4) {
        return byArray[n4++] << 24 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4] & 0xFF;
    }

    private void unpackInt(int n4, byte[] byArray, int n5) {
        byArray[n5++] = (byte)(n4 >>> 24);
        byArray[n5++] = (byte)(n4 >>> 16);
        byArray[n5++] = (byte)(n4 >>> 8);
        byArray[n5] = (byte)n4;
    }
}

