/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.macs;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Pack;

public class Poly1305
implements Mac {
    private static final int BLOCK_SIZE = 16;
    private final BlockCipher cipher;
    private final byte[] singleByte = new byte[1];
    private int r0;
    private int r1;
    private int r2;
    private int r3;
    private int r4;
    private int s1;
    private int s2;
    private int s3;
    private int s4;
    private int k0;
    private int k1;
    private int k2;
    private int k3;
    private final byte[] currentBlock = new byte[16];
    private int currentBlockOffset = 0;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;

    public Poly1305() {
        this.cipher = null;
    }

    public Poly1305(BlockCipher blockCipher) {
        if (blockCipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("Poly1305 requires a 128 bit block cipher.");
        }
        this.cipher = blockCipher;
    }

    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        CipherParameters cipherParameters2;
        byte[] byArray = null;
        if (this.cipher != null) {
            if (!(cipherParameters instanceof ParametersWithIV)) {
                throw new IllegalArgumentException("Poly1305 requires an IV when used with a block cipher.");
            }
            cipherParameters2 = (ParametersWithIV)cipherParameters;
            byArray = ((ParametersWithIV)cipherParameters2).getIV();
            cipherParameters = ((ParametersWithIV)cipherParameters2).getParameters();
        }
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("Poly1305 requires a key.");
        }
        cipherParameters2 = (KeyParameter)cipherParameters;
        this.setKey(((KeyParameter)cipherParameters2).getKey(), byArray);
        this.reset();
    }

    private void setKey(byte[] byArray, byte[] byArray2) {
        int n4;
        byte[] byArray3;
        if (byArray.length != 32) {
            throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
        }
        if (this.cipher != null && (byArray2 == null || byArray2.length != 16)) {
            throw new IllegalArgumentException("Poly1305 requires a 128 bit IV.");
        }
        int n5 = Pack.littleEndianToInt(byArray, 0);
        int n6 = Pack.littleEndianToInt(byArray, 4);
        int n7 = Pack.littleEndianToInt(byArray, 8);
        int n8 = Pack.littleEndianToInt(byArray, 12);
        this.r0 = n5 & 0x3FFFFFF;
        this.r1 = (n5 >>> 26 | n6 << 6) & 0x3FFFF03;
        this.r2 = (n6 >>> 20 | n7 << 12) & 0x3FFC0FF;
        this.r3 = (n7 >>> 14 | n8 << 18) & 0x3F03FFF;
        this.r4 = n8 >>> 8 & 0xFFFFF;
        this.s1 = this.r1 * 5;
        this.s2 = this.r2 * 5;
        this.s3 = this.r3 * 5;
        this.s4 = this.r4 * 5;
        if (this.cipher == null) {
            byArray3 = byArray;
            n4 = 16;
        } else {
            byArray3 = new byte[16];
            n4 = 0;
            this.cipher.init(true, new KeyParameter(byArray, 16, 16));
            this.cipher.processBlock(byArray2, 0, byArray3, 0);
        }
        this.k0 = Pack.littleEndianToInt(byArray3, n4 + 0);
        this.k1 = Pack.littleEndianToInt(byArray3, n4 + 4);
        this.k2 = Pack.littleEndianToInt(byArray3, n4 + 8);
        this.k3 = Pack.littleEndianToInt(byArray3, n4 + 12);
    }

    public String getAlgorithmName() {
        return this.cipher == null ? "Poly1305" : "Poly1305-" + this.cipher.getAlgorithmName();
    }

    public int getMacSize() {
        return 16;
    }

    public void update(byte by) throws IllegalStateException {
        this.singleByte[0] = by;
        this.update(this.singleByte, 0, 1);
    }

    public void update(byte[] byArray, int n4, int n5) throws DataLengthException, IllegalStateException {
        int n6 = 0;
        while (n5 > n6) {
            if (this.currentBlockOffset == 16) {
                this.processBlock();
                this.currentBlockOffset = 0;
            }
            int n7 = Math.min(n5 - n6, 16 - this.currentBlockOffset);
            System.arraycopy(byArray, n6 + n4, this.currentBlock, this.currentBlockOffset, n7);
            n6 += n7;
            this.currentBlockOffset += n7;
        }
    }

    private void processBlock() {
        if (this.currentBlockOffset < 16) {
            this.currentBlock[this.currentBlockOffset] = 1;
            for (int i4 = this.currentBlockOffset + 1; i4 < 16; ++i4) {
                this.currentBlock[i4] = 0;
            }
        }
        long l4 = 0xFFFFFFFFL & (long)Pack.littleEndianToInt(this.currentBlock, 0);
        long l5 = 0xFFFFFFFFL & (long)Pack.littleEndianToInt(this.currentBlock, 4);
        long l6 = 0xFFFFFFFFL & (long)Pack.littleEndianToInt(this.currentBlock, 8);
        long l7 = 0xFFFFFFFFL & (long)Pack.littleEndianToInt(this.currentBlock, 12);
        this.h0 = (int)((long)this.h0 + (l4 & 0x3FFFFFFL));
        this.h1 = (int)((long)this.h1 + ((l5 << 32 | l4) >>> 26 & 0x3FFFFFFL));
        this.h2 = (int)((long)this.h2 + ((l6 << 32 | l5) >>> 20 & 0x3FFFFFFL));
        this.h3 = (int)((long)this.h3 + ((l7 << 32 | l6) >>> 14 & 0x3FFFFFFL));
        this.h4 = (int)((long)this.h4 + (l7 >>> 8));
        if (this.currentBlockOffset == 16) {
            this.h4 += 0x1000000;
        }
        long l8 = Poly1305.mul32x32_64(this.h0, this.r0) + Poly1305.mul32x32_64(this.h1, this.s4) + Poly1305.mul32x32_64(this.h2, this.s3) + Poly1305.mul32x32_64(this.h3, this.s2) + Poly1305.mul32x32_64(this.h4, this.s1);
        long l9 = Poly1305.mul32x32_64(this.h0, this.r1) + Poly1305.mul32x32_64(this.h1, this.r0) + Poly1305.mul32x32_64(this.h2, this.s4) + Poly1305.mul32x32_64(this.h3, this.s3) + Poly1305.mul32x32_64(this.h4, this.s2);
        long l10 = Poly1305.mul32x32_64(this.h0, this.r2) + Poly1305.mul32x32_64(this.h1, this.r1) + Poly1305.mul32x32_64(this.h2, this.r0) + Poly1305.mul32x32_64(this.h3, this.s4) + Poly1305.mul32x32_64(this.h4, this.s3);
        long l11 = Poly1305.mul32x32_64(this.h0, this.r3) + Poly1305.mul32x32_64(this.h1, this.r2) + Poly1305.mul32x32_64(this.h2, this.r1) + Poly1305.mul32x32_64(this.h3, this.r0) + Poly1305.mul32x32_64(this.h4, this.s4);
        long l12 = Poly1305.mul32x32_64(this.h0, this.r4) + Poly1305.mul32x32_64(this.h1, this.r3) + Poly1305.mul32x32_64(this.h2, this.r2) + Poly1305.mul32x32_64(this.h3, this.r1) + Poly1305.mul32x32_64(this.h4, this.r0);
        this.h0 = (int)l8 & 0x3FFFFFF;
        this.h1 = (int)(l9 += l8 >>> 26) & 0x3FFFFFF;
        this.h2 = (int)(l10 += l9 >>> 26) & 0x3FFFFFF;
        this.h3 = (int)(l11 += l10 >>> 26) & 0x3FFFFFF;
        this.h4 = (int)(l12 += l11 >>> 26) & 0x3FFFFFF;
        this.h0 += (int)(l12 >>> 26) * 5;
        this.h1 += this.h0 >>> 26;
        this.h0 &= 0x3FFFFFF;
    }

    public int doFinal(byte[] byArray, int n4) throws DataLengthException, IllegalStateException {
        if (n4 + 16 > byArray.length) {
            throw new DataLengthException("Output buffer is too short.");
        }
        if (this.currentBlockOffset > 0) {
            this.processBlock();
        }
        this.h1 += this.h0 >>> 26;
        this.h0 &= 0x3FFFFFF;
        this.h2 += this.h1 >>> 26;
        this.h1 &= 0x3FFFFFF;
        this.h3 += this.h2 >>> 26;
        this.h2 &= 0x3FFFFFF;
        this.h4 += this.h3 >>> 26;
        this.h3 &= 0x3FFFFFF;
        this.h0 += (this.h4 >>> 26) * 5;
        this.h4 &= 0x3FFFFFF;
        this.h1 += this.h0 >>> 26;
        this.h0 &= 0x3FFFFFF;
        int n5 = this.h0 + 5;
        int n6 = n5 >>> 26;
        n5 &= 0x3FFFFFF;
        int n7 = this.h1 + n6;
        n6 = n7 >>> 26;
        n7 &= 0x3FFFFFF;
        int n8 = this.h2 + n6;
        n6 = n8 >>> 26;
        n8 &= 0x3FFFFFF;
        int n9 = this.h3 + n6;
        n6 = n9 >>> 26;
        n9 &= 0x3FFFFFF;
        int n10 = this.h4 + n6 - 0x4000000;
        n6 = (n10 >>> 31) - 1;
        int n11 = ~n6;
        this.h0 = this.h0 & n11 | n5 & n6;
        this.h1 = this.h1 & n11 | n7 & n6;
        this.h2 = this.h2 & n11 | n8 & n6;
        this.h3 = this.h3 & n11 | n9 & n6;
        this.h4 = this.h4 & n11 | n10 & n6;
        long l4 = ((long)(this.h0 | this.h1 << 26) & 0xFFFFFFFFL) + (0xFFFFFFFFL & (long)this.k0);
        long l5 = ((long)(this.h1 >>> 6 | this.h2 << 20) & 0xFFFFFFFFL) + (0xFFFFFFFFL & (long)this.k1);
        long l6 = ((long)(this.h2 >>> 12 | this.h3 << 14) & 0xFFFFFFFFL) + (0xFFFFFFFFL & (long)this.k2);
        long l7 = ((long)(this.h3 >>> 18 | this.h4 << 8) & 0xFFFFFFFFL) + (0xFFFFFFFFL & (long)this.k3);
        Pack.intToLittleEndian((int)l4, byArray, n4);
        Pack.intToLittleEndian((int)(l5 += l4 >>> 32), byArray, n4 + 4);
        Pack.intToLittleEndian((int)(l6 += l5 >>> 32), byArray, n4 + 8);
        Pack.intToLittleEndian((int)(l7 += l6 >>> 32), byArray, n4 + 12);
        this.reset();
        return 16;
    }

    public void reset() {
        this.currentBlockOffset = 0;
        this.h4 = 0;
        this.h3 = 0;
        this.h2 = 0;
        this.h1 = 0;
        this.h0 = 0;
    }

    private static final long mul32x32_64(int n4, int n5) {
        return ((long)n4 & 0xFFFFFFFFL) * (long)n5;
    }
}

