/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import java.util.Vector;
import org.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private Vector lookupPowX2;

    public void init(byte[] byArray) {
        int[] nArray = GCMUtil.asInts(byArray);
        if (this.lookupPowX2 != null && Arrays.areEqual(nArray, (int[])this.lookupPowX2.elementAt(0))) {
            return;
        }
        this.lookupPowX2 = new Vector(8);
        this.lookupPowX2.addElement(nArray);
    }

    public void exponentiateX(long l4, byte[] byArray) {
        int[] nArray = GCMUtil.oneAsInts();
        int n4 = 0;
        while (l4 > 0L) {
            if ((l4 & 1L) != 0L) {
                this.ensureAvailable(n4);
                GCMUtil.multiply(nArray, (int[])this.lookupPowX2.elementAt(n4));
            }
            ++n4;
            l4 >>>= 1;
        }
        GCMUtil.asBytes(nArray, byArray);
    }

    private void ensureAvailable(int n4) {
        int n5 = this.lookupPowX2.size();
        if (n5 <= n4) {
            int[] nArray = (int[])this.lookupPowX2.elementAt(n5 - 1);
            do {
                nArray = Arrays.clone(nArray);
                GCMUtil.multiply(nArray, nArray);
                this.lookupPowX2.addElement(nArray);
            } while (++n5 <= n4);
        }
    }
}

