/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.util.Vector;

class DTLSReassembler {
    private short msg_type;
    private byte[] body;
    private Vector missing = new Vector();

    DTLSReassembler(short s4, int n4) {
        this.msg_type = s4;
        this.body = new byte[n4];
        this.missing.addElement(new Range(0, n4));
    }

    short getMsgType() {
        return this.msg_type;
    }

    byte[] getBodyIfComplete() {
        return this.missing.isEmpty() ? this.body : null;
    }

    void contributeFragment(short s4, int n4, byte[] byArray, int n5, int n6, int n7) {
        Range range;
        int n8 = n6 + n7;
        if (this.msg_type != s4 || this.body.length != n4 || n8 > n4) {
            return;
        }
        if (n7 == 0) {
            Range range2;
            if (n6 == 0 && !this.missing.isEmpty() && (range2 = (Range)this.missing.firstElement()).getEnd() == 0) {
                this.missing.removeElementAt(0);
            }
            return;
        }
        for (int i4 = 0; i4 < this.missing.size() && (range = (Range)this.missing.elementAt(i4)).getStart() < n8; ++i4) {
            if (range.getEnd() <= n6) continue;
            int n9 = Math.max(range.getStart(), n6);
            int n10 = Math.min(range.getEnd(), n8);
            int n11 = n10 - n9;
            System.arraycopy(byArray, n5 + n9 - n6, this.body, n9, n11);
            if (n9 == range.getStart()) {
                if (n10 == range.getEnd()) {
                    this.missing.removeElementAt(i4--);
                    continue;
                }
                range.setStart(n10);
                continue;
            }
            if (n10 != range.getEnd()) {
                this.missing.insertElementAt(new Range(n10, range.getEnd()), ++i4);
            }
            range.setEnd(n9);
        }
    }

    void reset() {
        this.missing.removeAllElements();
        this.missing.addElement(new Range(0, this.body.length));
    }

    private static class Range {
        private int start;
        private int end;

        Range(int n4, int n5) {
            this.start = n4;
            this.end = n5;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int n4) {
            this.start = n4;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int n4) {
            this.end = n4;
        }
    }
}

