/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsMac;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsBlockCipher
implements TlsCipher {
    protected TlsContext context;
    protected byte[] randomData;
    protected boolean useExplicitIV;
    protected boolean encryptThenMAC;
    protected BlockCipher encryptCipher;
    protected BlockCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsMac getWriteMac() {
        return this.writeMac;
    }

    public TlsMac getReadMac() {
        return this.readMac;
    }

    public TlsBlockCipher(TlsContext tlsContext, BlockCipher blockCipher, BlockCipher blockCipher2, Digest digest, Digest digest2, int n4) throws IOException {
        ParametersWithIV parametersWithIV;
        ParametersWithIV parametersWithIV2;
        byte[] byArray;
        byte[] byArray2;
        this.context = tlsContext;
        this.randomData = new byte[256];
        tlsContext.getNonceRandomGenerator().nextBytes(this.randomData);
        this.useExplicitIV = TlsUtils.isTLSv11(tlsContext);
        this.encryptThenMAC = tlsContext.getSecurityParameters().encryptThenMAC;
        int n5 = 2 * n4 + digest.getDigestSize() + digest2.getDigestSize();
        if (!this.useExplicitIV) {
            n5 += blockCipher.getBlockSize() + blockCipher2.getBlockSize();
        }
        byte[] byArray3 = TlsUtils.calculateKeyBlock(tlsContext, n5);
        int n6 = 0;
        TlsMac tlsMac = new TlsMac(tlsContext, digest, byArray3, n6, digest.getDigestSize());
        TlsMac tlsMac2 = new TlsMac(tlsContext, digest2, byArray3, n6 += digest.getDigestSize(), digest2.getDigestSize());
        KeyParameter keyParameter = new KeyParameter(byArray3, n6 += digest2.getDigestSize(), n4);
        KeyParameter keyParameter2 = new KeyParameter(byArray3, n6 += n4, n4);
        n6 += n4;
        if (this.useExplicitIV) {
            byArray2 = new byte[blockCipher.getBlockSize()];
            byArray = new byte[blockCipher2.getBlockSize()];
        } else {
            byArray2 = Arrays.copyOfRange(byArray3, n6, n6 + blockCipher.getBlockSize());
            byArray = Arrays.copyOfRange(byArray3, n6 += blockCipher.getBlockSize(), n6 + blockCipher2.getBlockSize());
            n6 += blockCipher2.getBlockSize();
        }
        if (n6 != n5) {
            throw new TlsFatalAlert(80);
        }
        if (tlsContext.isServer()) {
            this.writeMac = tlsMac2;
            this.readMac = tlsMac;
            this.encryptCipher = blockCipher2;
            this.decryptCipher = blockCipher;
            parametersWithIV2 = new ParametersWithIV(keyParameter2, byArray);
            parametersWithIV = new ParametersWithIV(keyParameter, byArray2);
        } else {
            this.writeMac = tlsMac;
            this.readMac = tlsMac2;
            this.encryptCipher = blockCipher;
            this.decryptCipher = blockCipher2;
            parametersWithIV2 = new ParametersWithIV(keyParameter, byArray2);
            parametersWithIV = new ParametersWithIV(keyParameter2, byArray);
        }
        this.encryptCipher.init(true, parametersWithIV2);
        this.decryptCipher.init(false, parametersWithIV);
    }

    public int getPlaintextLimit(int n4) {
        int n5 = this.encryptCipher.getBlockSize();
        int n6 = this.writeMac.getSize();
        int n7 = n4;
        if (this.useExplicitIV) {
            n7 -= n5;
        }
        if (this.encryptThenMAC) {
            n7 -= n6;
            n7 -= n7 % n5;
        } else {
            n7 -= n7 % n5;
            n7 -= n6;
        }
        return --n7;
    }

    public byte[] encodePlaintext(long l4, short s4, byte[] byArray, int n4, int n5) {
        int n6;
        int n7;
        int n8 = this.encryptCipher.getBlockSize();
        int n9 = this.writeMac.getSize();
        ProtocolVersion protocolVersion = this.context.getServerVersion();
        int n10 = n5;
        if (!this.encryptThenMAC) {
            n10 += n9;
        }
        int n11 = n8 - 1 - n10 % n8;
        if (!protocolVersion.isDTLS() && !protocolVersion.isSSL()) {
            n7 = (255 - n11) / n8;
            int n12 = this.chooseExtraPadBlocks(this.context.getSecureRandom(), n7);
            n11 += n12 * n8;
        }
        n7 = n5 + n9 + n11 + 1;
        if (this.useExplicitIV) {
            n7 += n8;
        }
        byte[] byArray2 = new byte[n7];
        int n13 = 0;
        if (this.useExplicitIV) {
            byte[] byArray3 = new byte[n8];
            this.context.getNonceRandomGenerator().nextBytes(byArray3);
            this.encryptCipher.init(true, new ParametersWithIV(null, byArray3));
            System.arraycopy(byArray3, 0, byArray2, n13, n8);
            n13 += n8;
        }
        int n14 = n13;
        System.arraycopy(byArray, n4, byArray2, n13, n5);
        n13 += n5;
        if (!this.encryptThenMAC) {
            byte[] byArray4 = this.writeMac.calculateMac(l4, s4, byArray, n4, n5);
            System.arraycopy(byArray4, 0, byArray2, n13, byArray4.length);
            n13 += byArray4.length;
        }
        for (n6 = 0; n6 <= n11; ++n6) {
            byArray2[n13++] = (byte)n11;
        }
        for (n6 = n14; n6 < n13; n6 += n8) {
            this.encryptCipher.processBlock(byArray2, n6, byArray2, n6);
        }
        if (this.encryptThenMAC) {
            byte[] byArray5 = this.writeMac.calculateMac(l4, s4, byArray2, 0, n13);
            System.arraycopy(byArray5, 0, byArray2, n13, byArray5.length);
            n13 += byArray5.length;
        }
        return byArray2;
    }

    public byte[] decodeCiphertext(long l4, short s4, byte[] byArray, int n4, int n5) throws IOException {
        int n6;
        int n7;
        int n8 = this.decryptCipher.getBlockSize();
        int n9 = this.readMac.getSize();
        int n10 = n8;
        n10 = this.encryptThenMAC ? (n10 += n9) : Math.max(n10, n9 + 1);
        if (this.useExplicitIV) {
            n10 += n8;
        }
        if (n5 < n10) {
            throw new TlsFatalAlert(50);
        }
        int n11 = n5;
        if (this.encryptThenMAC) {
            n11 -= n9;
        }
        if (n11 % n8 != 0) {
            throw new TlsFatalAlert(21);
        }
        if (this.encryptThenMAC) {
            n7 = n4 + n5;
            byte[] byArray2 = Arrays.copyOfRange(byArray, n7 - n9, n7);
            byte[] byArray3 = this.readMac.calculateMac(l4, s4, byArray, n4, n5 - n9);
            int n12 = n6 = !Arrays.constantTimeAreEqual(byArray3, byArray2) ? 1 : 0;
            if (n6 != 0) {
                throw new TlsFatalAlert(20);
            }
        }
        if (this.useExplicitIV) {
            this.decryptCipher.init(false, new ParametersWithIV(null, byArray, n4, n8));
            n4 += n8;
            n11 -= n8;
        }
        for (n7 = 0; n7 < n11; n7 += n8) {
            this.decryptCipher.processBlock(byArray, n4 + n7, byArray, n4 + n7);
        }
        n7 = this.checkPaddingConstantTime(byArray, n4, n11, n8, this.encryptThenMAC ? 0 : n9);
        boolean bl = n7 == 0;
        int n13 = n11 - n7;
        if (!this.encryptThenMAC) {
            n6 = n13 -= n9;
            int n14 = n4 + n6;
            byte[] byArray4 = Arrays.copyOfRange(byArray, n14, n14 + n9);
            byte[] byArray5 = this.readMac.calculateMacConstantTime(l4, s4, byArray, n4, n6, n11 - n9, this.randomData);
            bl |= !Arrays.constantTimeAreEqual(byArray5, byArray4);
        }
        if (bl) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(byArray, n4, n4 + n13);
    }

    protected int checkPaddingConstantTime(byte[] byArray, int n4, int n5, int n6, int n7) {
        int n8 = n4 + n5;
        byte by = byArray[n8 - 1];
        int n9 = by & 0xFF;
        int n10 = n9 + 1;
        int n11 = 0;
        int n12 = 0;
        if (TlsUtils.isSSL(this.context) && n10 > n6 || n7 + n10 > n5) {
            n10 = 0;
        } else {
            int n13 = n8 - n10;
            do {
                n12 = (byte)(n12 | byArray[n13++] ^ by);
            } while (n13 < n8);
            n11 = n10;
            if (n12 != 0) {
                n10 = 0;
            }
        }
        byte[] byArray2 = this.randomData;
        while (n11 < 256) {
            n12 = (byte)(n12 | byArray2[n11++] ^ by);
        }
        byArray2[0] = (byte)(byArray2[0] ^ n12);
        return n10;
    }

    protected int chooseExtraPadBlocks(SecureRandom secureRandom, int n4) {
        int n5 = secureRandom.nextInt();
        int n6 = this.lowestBitSet(n5);
        return Math.min(n6, n4);
    }

    protected int lowestBitSet(int n4) {
        if (n4 == 0) {
            return 32;
        }
        int n5 = 0;
        while ((n4 & 1) == 0) {
            ++n5;
            n4 >>= 1;
        }
        return n5;
    }
}

