/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import org.bouncycastle.crypto.io.InvalidCipherTextIOException;

public class CipherInputStream
extends FilterInputStream {
    private final Cipher cipher;
    private final byte[] inputBuffer = new byte[512];
    private boolean finalized = false;
    private byte[] buf;
    private int maxBuf;
    private int bufOff;

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        this.cipher = cipher;
    }

    private int nextChunk() throws IOException {
        if (this.finalized) {
            return -1;
        }
        this.bufOff = 0;
        this.maxBuf = 0;
        while (this.maxBuf == 0) {
            int n4 = this.in.read(this.inputBuffer);
            if (n4 == -1) {
                this.buf = this.finaliseCipher();
                if (this.buf == null || this.buf.length == 0) {
                    return -1;
                }
                this.maxBuf = this.buf.length;
                return this.maxBuf;
            }
            this.buf = this.cipher.update(this.inputBuffer, 0, n4);
            if (this.buf == null) continue;
            this.maxBuf = this.buf.length;
        }
        return this.maxBuf;
    }

    private byte[] finaliseCipher() throws InvalidCipherTextIOException {
        try {
            this.finalized = true;
            return this.cipher.doFinal();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidCipherTextIOException("Error finalising cipher", generalSecurityException);
        }
    }

    public int read() throws IOException {
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        return this.buf[this.bufOff++] & 0xFF;
    }

    public int read(byte[] byArray, int n4, int n5) throws IOException {
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        int n6 = Math.min(n5, this.available());
        System.arraycopy(this.buf, this.bufOff, byArray, n4, n6);
        this.bufOff += n6;
        return n6;
    }

    public long skip(long l4) throws IOException {
        if (l4 <= 0L) {
            return 0L;
        }
        int n4 = (int)Math.min(l4, (long)this.available());
        this.bufOff += n4;
        return n4;
    }

    public int available() throws IOException {
        return this.maxBuf - this.bufOff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            if (!this.finalized) {
                this.finaliseCipher();
            }
        }
        this.bufOff = 0;
        this.maxBuf = 0;
    }

    public void mark(int n4) {
    }

    public void reset() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }
}

