/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.math.raw.Nat256;

public class SecT233Field {
    private static final long M41 = 0x1FFFFFFFFFFL;
    private static final long M59 = 0x7FFFFFFFFFFFFFFL;

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
        lArray3[3] = lArray[3] ^ lArray2[3];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
        lArray3[3] = lArray[3] ^ lArray2[3];
        lArray3[4] = lArray[4] ^ lArray2[4];
        lArray3[5] = lArray[5] ^ lArray2[5];
        lArray3[6] = lArray[6] ^ lArray2[6];
        lArray3[7] = lArray[7] ^ lArray2[7];
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray[0] ^ 1L;
        lArray2[1] = lArray[1];
        lArray2[2] = lArray[2];
        lArray2[3] = lArray[3];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        long[] lArray = Nat256.fromBigInteger64(bigInteger);
        SecT233Field.reduce23(lArray, 0);
        return lArray;
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (Nat256.isZero64(lArray)) {
            throw new IllegalStateException();
        }
        long[] lArray3 = Nat256.create64();
        long[] lArray4 = Nat256.create64();
        SecT233Field.square(lArray, lArray3);
        SecT233Field.multiply(lArray3, lArray, lArray3);
        SecT233Field.square(lArray3, lArray3);
        SecT233Field.multiply(lArray3, lArray, lArray3);
        SecT233Field.squareN(lArray3, 3, lArray4);
        SecT233Field.multiply(lArray4, lArray3, lArray4);
        SecT233Field.square(lArray4, lArray4);
        SecT233Field.multiply(lArray4, lArray, lArray4);
        SecT233Field.squareN(lArray4, 7, lArray3);
        SecT233Field.multiply(lArray3, lArray4, lArray3);
        SecT233Field.squareN(lArray3, 14, lArray4);
        SecT233Field.multiply(lArray4, lArray3, lArray4);
        SecT233Field.square(lArray4, lArray4);
        SecT233Field.multiply(lArray4, lArray, lArray4);
        SecT233Field.squareN(lArray4, 29, lArray3);
        SecT233Field.multiply(lArray3, lArray4, lArray3);
        SecT233Field.squareN(lArray3, 58, lArray4);
        SecT233Field.multiply(lArray4, lArray3, lArray4);
        SecT233Field.squareN(lArray4, 116, lArray3);
        SecT233Field.multiply(lArray3, lArray4, lArray3);
        SecT233Field.square(lArray3, lArray2);
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat256.createExt64();
        SecT233Field.implMultiply(lArray, lArray2, lArray4);
        SecT233Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat256.createExt64();
        SecT233Field.implMultiply(lArray, lArray2, lArray4);
        SecT233Field.addExt(lArray3, lArray4, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        long l9 = lArray[5];
        long l10 = lArray[6];
        long l11 = lArray[7];
        l7 ^= l11 << 23;
        l8 ^= l11 >>> 41 ^ l11 << 33;
        l6 ^= l10 << 23;
        l7 ^= l10 >>> 41 ^ l10 << 33;
        l5 ^= (l9 ^= l11 >>> 31) << 23;
        l6 ^= l9 >>> 41 ^ l9 << 33;
        long l12 = (l7 ^= l9 >>> 31) >>> 41;
        lArray2[0] = (l4 ^= (l8 ^= l10 >>> 31) << 23) ^ l12;
        lArray2[1] = (l5 ^= l8 >>> 41 ^ l8 << 33) ^ l12 << 10;
        lArray2[2] = l6 ^= l8 >>> 31;
        lArray2[3] = l7 & 0x1FFFFFFFFFFL;
    }

    public static void reduce23(long[] lArray, int n4) {
        long l4 = lArray[n4 + 3];
        long l5 = l4 >>> 41;
        int n5 = n4;
        lArray[n5] = lArray[n5] ^ l5;
        int n6 = n4 + 1;
        lArray[n6] = lArray[n6] ^ l5 << 10;
        lArray[n4 + 3] = l4 & 0x1FFFFFFFFFFL;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT233Field.implSquare(lArray, lArray3);
        SecT233Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT233Field.implSquare(lArray, lArray3);
        SecT233Field.addExt(lArray2, lArray3, lArray2);
    }

    public static void squareN(long[] lArray, int n4, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT233Field.implSquare(lArray, lArray3);
        SecT233Field.reduce(lArray3, lArray2);
        while (--n4 > 0) {
            SecT233Field.implSquare(lArray2, lArray3);
            SecT233Field.reduce(lArray3, lArray2);
        }
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long l4 = Interleave.unshuffle(lArray[0]);
        long l5 = Interleave.unshuffle(lArray[1]);
        long l6 = l4 & 0xFFFFFFFFL | l5 << 32;
        long l7 = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        l4 = Interleave.unshuffle(lArray[2]);
        l5 = Interleave.unshuffle(lArray[3]);
        long l8 = l4 & 0xFFFFFFFFL | l5 << 32;
        long l9 = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        long l10 = l9 >>> 27;
        l9 ^= l7 >>> 27 | l9 << 37;
        l7 ^= l7 << 37;
        long[] lArray3 = Nat256.createExt64();
        int[] nArray = new int[]{32, 117, 191};
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            int n4 = nArray[i4] >>> 6;
            int n5 = nArray[i4] & 0x3F;
            int n6 = n4;
            lArray3[n6] = lArray3[n6] ^ l7 << n5;
            int n7 = n4 + 1;
            lArray3[n7] = lArray3[n7] ^ (l9 << n5 | l7 >>> -n5);
            int n8 = n4 + 2;
            lArray3[n8] = lArray3[n8] ^ (l10 << n5 | l9 >>> -n5);
            int n9 = n4 + 3;
            lArray3[n9] = lArray3[n9] ^ l10 >>> -n5;
        }
        SecT233Field.reduce(lArray3, lArray2);
        lArray2[0] = lArray2[0] ^ l6;
        lArray2[1] = lArray2[1] ^ l8;
    }

    public static int trace(long[] lArray) {
        return (int)(lArray[0] ^ lArray[2] >>> 31) & 1;
    }

    protected static void implCompactExt(long[] lArray) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        long l9 = lArray[5];
        long l10 = lArray[6];
        long l11 = lArray[7];
        lArray[0] = l4 ^ l5 << 59;
        lArray[1] = l5 >>> 5 ^ l6 << 54;
        lArray[2] = l6 >>> 10 ^ l7 << 49;
        lArray[3] = l7 >>> 15 ^ l8 << 44;
        lArray[4] = l8 >>> 20 ^ l9 << 39;
        lArray[5] = l9 >>> 25 ^ l10 << 34;
        lArray[6] = l10 >>> 30 ^ l11 << 29;
        lArray[7] = l11 >>> 35;
    }

    protected static void implExpand(long[] lArray, long[] lArray2) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        lArray2[0] = l4 & 0x7FFFFFFFFFFFFFFL;
        lArray2[1] = (l4 >>> 59 ^ l5 << 5) & 0x7FFFFFFFFFFFFFFL;
        lArray2[2] = (l5 >>> 54 ^ l6 << 10) & 0x7FFFFFFFFFFFFFFL;
        lArray2[3] = l6 >>> 49 ^ l7 << 15;
    }

    protected static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        int n4;
        long[] lArray4 = new long[4];
        long[] lArray5 = new long[4];
        SecT233Field.implExpand(lArray, lArray4);
        SecT233Field.implExpand(lArray2, lArray5);
        SecT233Field.implMulwAcc(lArray4[0], lArray5[0], lArray3, 0);
        SecT233Field.implMulwAcc(lArray4[1], lArray5[1], lArray3, 1);
        SecT233Field.implMulwAcc(lArray4[2], lArray5[2], lArray3, 2);
        SecT233Field.implMulwAcc(lArray4[3], lArray5[3], lArray3, 3);
        for (n4 = 5; n4 > 0; --n4) {
            int n5 = n4;
            lArray3[n5] = lArray3[n5] ^ lArray3[n4 - 1];
        }
        SecT233Field.implMulwAcc(lArray4[0] ^ lArray4[1], lArray5[0] ^ lArray5[1], lArray3, 1);
        SecT233Field.implMulwAcc(lArray4[2] ^ lArray4[3], lArray5[2] ^ lArray5[3], lArray3, 3);
        for (n4 = 7; n4 > 1; --n4) {
            int n6 = n4;
            lArray3[n6] = lArray3[n6] ^ lArray3[n4 - 2];
        }
        long l4 = lArray4[0] ^ lArray4[2];
        long l5 = lArray4[1] ^ lArray4[3];
        long l6 = lArray5[0] ^ lArray5[2];
        long l7 = lArray5[1] ^ lArray5[3];
        SecT233Field.implMulwAcc(l4 ^ l5, l6 ^ l7, lArray3, 3);
        long[] lArray6 = new long[3];
        SecT233Field.implMulwAcc(l4, l6, lArray6, 0);
        SecT233Field.implMulwAcc(l5, l7, lArray6, 1);
        long l8 = lArray6[0];
        long l9 = lArray6[1];
        long l10 = lArray6[2];
        lArray3[2] = lArray3[2] ^ l8;
        lArray3[3] = lArray3[3] ^ (l8 ^ l9);
        lArray3[4] = lArray3[4] ^ (l10 ^ l9);
        lArray3[5] = lArray3[5] ^ l10;
        SecT233Field.implCompactExt(lArray3);
    }

    protected static void implMulwAcc(long l4, long l5, long[] lArray, int n4) {
        long[] lArray2 = new long[8];
        lArray2[1] = l5;
        lArray2[2] = lArray2[1] << 1;
        lArray2[3] = lArray2[2] ^ l5;
        lArray2[4] = lArray2[2] << 1;
        lArray2[5] = lArray2[4] ^ l5;
        lArray2[6] = lArray2[3] << 1;
        lArray2[7] = lArray2[6] ^ l5;
        int n5 = (int)l4;
        long l6 = 0L;
        long l7 = lArray2[n5 & 7] ^ lArray2[n5 >>> 3 & 7] << 3;
        int n6 = 54;
        do {
            n5 = (int)(l4 >>> n6);
            long l8 = lArray2[n5 & 7] ^ lArray2[n5 >>> 3 & 7] << 3;
            l7 ^= l8 << n6;
            l6 ^= l8 >>> -n6;
        } while ((n6 -= 6) > 0);
        int n7 = n4;
        lArray[n7] = lArray[n7] ^ l7 & 0x7FFFFFFFFFFFFFFL;
        int n8 = n4 + 1;
        lArray[n8] = lArray[n8] ^ (l7 >>> 59 ^ l6 << 5);
    }

    protected static void implSquare(long[] lArray, long[] lArray2) {
        Interleave.expand64To128(lArray[0], lArray2, 0);
        Interleave.expand64To128(lArray[1], lArray2, 2);
        Interleave.expand64To128(lArray[2], lArray2, 4);
        long l4 = lArray[3];
        lArray2[6] = Interleave.expand32to64((int)l4);
        lArray2[7] = (long)Interleave.expand16to32((int)(l4 >>> 32)) & 0xFFFFFFFFL;
    }
}

