/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.math.raw.Nat320;

public class SecT283Field {
    private static final long M27 = 0x7FFFFFFL;
    private static final long M57 = 0x1FFFFFFFFFFFFFFL;
    private static final long[] ROOT_Z = new long[]{878416384462358536L, 0x30C30C30C30C30C3L, -9076969306111048948L, 0x820820820820820L, 0x2082082L};

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
        lArray3[3] = lArray[3] ^ lArray2[3];
        lArray3[4] = lArray[4] ^ lArray2[4];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
        lArray3[3] = lArray[3] ^ lArray2[3];
        lArray3[4] = lArray[4] ^ lArray2[4];
        lArray3[5] = lArray[5] ^ lArray2[5];
        lArray3[6] = lArray[6] ^ lArray2[6];
        lArray3[7] = lArray[7] ^ lArray2[7];
        lArray3[8] = lArray[8] ^ lArray2[8];
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray[0] ^ 1L;
        lArray2[1] = lArray[1];
        lArray2[2] = lArray[2];
        lArray2[3] = lArray[3];
        lArray2[4] = lArray[4];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        long[] lArray = Nat320.fromBigInteger64(bigInteger);
        SecT283Field.reduce37(lArray, 0);
        return lArray;
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (Nat320.isZero64(lArray)) {
            throw new IllegalStateException();
        }
        long[] lArray3 = Nat320.create64();
        long[] lArray4 = Nat320.create64();
        SecT283Field.square(lArray, lArray3);
        SecT283Field.multiply(lArray3, lArray, lArray3);
        SecT283Field.squareN(lArray3, 2, lArray4);
        SecT283Field.multiply(lArray4, lArray3, lArray4);
        SecT283Field.squareN(lArray4, 4, lArray3);
        SecT283Field.multiply(lArray3, lArray4, lArray3);
        SecT283Field.squareN(lArray3, 8, lArray4);
        SecT283Field.multiply(lArray4, lArray3, lArray4);
        SecT283Field.square(lArray4, lArray4);
        SecT283Field.multiply(lArray4, lArray, lArray4);
        SecT283Field.squareN(lArray4, 17, lArray3);
        SecT283Field.multiply(lArray3, lArray4, lArray3);
        SecT283Field.square(lArray3, lArray3);
        SecT283Field.multiply(lArray3, lArray, lArray3);
        SecT283Field.squareN(lArray3, 35, lArray4);
        SecT283Field.multiply(lArray4, lArray3, lArray4);
        SecT283Field.squareN(lArray4, 70, lArray3);
        SecT283Field.multiply(lArray3, lArray4, lArray3);
        SecT283Field.square(lArray3, lArray3);
        SecT283Field.multiply(lArray3, lArray, lArray3);
        SecT283Field.squareN(lArray3, 141, lArray4);
        SecT283Field.multiply(lArray4, lArray3, lArray4);
        SecT283Field.square(lArray4, lArray2);
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat320.createExt64();
        SecT283Field.implMultiply(lArray, lArray2, lArray4);
        SecT283Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat320.createExt64();
        SecT283Field.implMultiply(lArray, lArray2, lArray4);
        SecT283Field.addExt(lArray3, lArray4, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        long l9 = lArray[5];
        long l10 = lArray[6];
        long l11 = lArray[7];
        long l12 = lArray[8];
        l7 ^= l12 << 37 ^ l12 << 42 ^ l12 << 44 ^ l12 << 49;
        l6 ^= l11 << 37 ^ l11 << 42 ^ l11 << 44 ^ l11 << 49;
        l7 ^= l11 >>> 27 ^ l11 >>> 22 ^ l11 >>> 20 ^ l11 >>> 15;
        l5 ^= l10 << 37 ^ l10 << 42 ^ l10 << 44 ^ l10 << 49;
        long l13 = (l8 ^= l12 >>> 27 ^ l12 >>> 22 ^ l12 >>> 20 ^ l12 >>> 15) >>> 27;
        lArray2[0] = (l4 ^= l9 << 37 ^ l9 << 42 ^ l9 << 44 ^ l9 << 49) ^ l13 ^ l13 << 5 ^ l13 << 7 ^ l13 << 12;
        lArray2[1] = l5 ^= l9 >>> 27 ^ l9 >>> 22 ^ l9 >>> 20 ^ l9 >>> 15;
        lArray2[2] = l6 ^= l10 >>> 27 ^ l10 >>> 22 ^ l10 >>> 20 ^ l10 >>> 15;
        lArray2[3] = l7;
        lArray2[4] = l8 & 0x7FFFFFFL;
    }

    public static void reduce37(long[] lArray, int n4) {
        long l4 = lArray[n4 + 4];
        long l5 = l4 >>> 27;
        int n5 = n4;
        lArray[n5] = lArray[n5] ^ (l5 ^ l5 << 5 ^ l5 << 7 ^ l5 << 12);
        lArray[n4 + 4] = l4 & 0x7FFFFFFL;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat320.create64();
        long l4 = Interleave.unshuffle(lArray[0]);
        long l5 = Interleave.unshuffle(lArray[1]);
        long l6 = l4 & 0xFFFFFFFFL | l5 << 32;
        lArray3[0] = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        l4 = Interleave.unshuffle(lArray[2]);
        l5 = Interleave.unshuffle(lArray[3]);
        long l7 = l4 & 0xFFFFFFFFL | l5 << 32;
        lArray3[1] = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        l4 = Interleave.unshuffle(lArray[4]);
        long l8 = l4 & 0xFFFFFFFFL;
        lArray3[2] = l4 >>> 32;
        SecT283Field.multiply(lArray3, ROOT_Z, lArray2);
        lArray2[0] = lArray2[0] ^ l6;
        lArray2[1] = lArray2[1] ^ l7;
        lArray2[2] = lArray2[2] ^ l8;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat.create64(9);
        SecT283Field.implSquare(lArray, lArray3);
        SecT283Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat.create64(9);
        SecT283Field.implSquare(lArray, lArray3);
        SecT283Field.addExt(lArray2, lArray3, lArray2);
    }

    public static void squareN(long[] lArray, int n4, long[] lArray2) {
        long[] lArray3 = Nat.create64(9);
        SecT283Field.implSquare(lArray, lArray3);
        SecT283Field.reduce(lArray3, lArray2);
        while (--n4 > 0) {
            SecT283Field.implSquare(lArray2, lArray3);
            SecT283Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)(lArray[0] ^ lArray[4] >>> 15) & 1;
    }

    protected static void implCompactExt(long[] lArray) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        long l9 = lArray[5];
        long l10 = lArray[6];
        long l11 = lArray[7];
        long l12 = lArray[8];
        long l13 = lArray[9];
        lArray[0] = l4 ^ l5 << 57;
        lArray[1] = l5 >>> 7 ^ l6 << 50;
        lArray[2] = l6 >>> 14 ^ l7 << 43;
        lArray[3] = l7 >>> 21 ^ l8 << 36;
        lArray[4] = l8 >>> 28 ^ l9 << 29;
        lArray[5] = l9 >>> 35 ^ l10 << 22;
        lArray[6] = l10 >>> 42 ^ l11 << 15;
        lArray[7] = l11 >>> 49 ^ l12 << 8;
        lArray[8] = l12 >>> 56 ^ l13 << 1;
        lArray[9] = l13 >>> 63;
    }

    protected static void implExpand(long[] lArray, long[] lArray2) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        lArray2[0] = l4 & 0x1FFFFFFFFFFFFFFL;
        lArray2[1] = (l4 >>> 57 ^ l5 << 7) & 0x1FFFFFFFFFFFFFFL;
        lArray2[2] = (l5 >>> 50 ^ l6 << 14) & 0x1FFFFFFFFFFFFFFL;
        lArray2[3] = (l6 >>> 43 ^ l7 << 21) & 0x1FFFFFFFFFFFFFFL;
        lArray2[4] = l7 >>> 36 ^ l8 << 28;
    }

    protected static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long[] lArray4 = new long[5];
        long[] lArray5 = new long[5];
        SecT283Field.implExpand(lArray, lArray4);
        SecT283Field.implExpand(lArray2, lArray5);
        long[] lArray6 = new long[26];
        SecT283Field.implMulw(lArray4[0], lArray5[0], lArray6, 0);
        SecT283Field.implMulw(lArray4[1], lArray5[1], lArray6, 2);
        SecT283Field.implMulw(lArray4[2], lArray5[2], lArray6, 4);
        SecT283Field.implMulw(lArray4[3], lArray5[3], lArray6, 6);
        SecT283Field.implMulw(lArray4[4], lArray5[4], lArray6, 8);
        long l12 = lArray4[0] ^ lArray4[1];
        long l13 = lArray5[0] ^ lArray5[1];
        long l14 = lArray4[0] ^ lArray4[2];
        long l15 = lArray5[0] ^ lArray5[2];
        long l16 = lArray4[2] ^ lArray4[4];
        long l17 = lArray5[2] ^ lArray5[4];
        long l18 = lArray4[3] ^ lArray4[4];
        long l19 = lArray5[3] ^ lArray5[4];
        SecT283Field.implMulw(l14 ^ lArray4[3], l15 ^ lArray5[3], lArray6, 18);
        SecT283Field.implMulw(l16 ^ lArray4[1], l17 ^ lArray5[1], lArray6, 20);
        long l20 = l12 ^ l18;
        long l21 = l13 ^ l19;
        long l22 = l20 ^ lArray4[2];
        long l23 = l21 ^ lArray5[2];
        SecT283Field.implMulw(l20, l21, lArray6, 22);
        SecT283Field.implMulw(l22, l23, lArray6, 24);
        SecT283Field.implMulw(l12, l13, lArray6, 10);
        SecT283Field.implMulw(l14, l15, lArray6, 12);
        SecT283Field.implMulw(l16, l17, lArray6, 14);
        SecT283Field.implMulw(l18, l19, lArray6, 16);
        lArray3[0] = lArray6[0];
        lArray3[9] = lArray6[9];
        long l24 = lArray6[0] ^ lArray6[1];
        long l25 = l24 ^ lArray6[2];
        lArray3[1] = l11 = l25 ^ lArray6[10];
        long l26 = lArray6[3] ^ lArray6[4];
        long l27 = lArray6[11] ^ lArray6[12];
        long l28 = l26 ^ l27;
        lArray3[2] = l10 = l25 ^ l28;
        long l29 = l24 ^ l26;
        long l30 = lArray6[5] ^ lArray6[6];
        long l31 = l29 ^ l30;
        long l32 = l31 ^ lArray6[8];
        long l33 = lArray6[13] ^ lArray6[14];
        long l34 = l32 ^ l33;
        long l35 = lArray6[18] ^ lArray6[22];
        long l36 = l35 ^ lArray6[24];
        lArray3[3] = l9 = l34 ^ l36;
        long l37 = lArray6[7] ^ lArray6[8];
        long l38 = l37 ^ lArray6[9];
        lArray3[8] = l8 = l38 ^ lArray6[17];
        long l39 = l38 ^ l30;
        long l40 = lArray6[15] ^ lArray6[16];
        lArray3[7] = l7 = l39 ^ l40;
        long l41 = l7 ^ l11;
        long l42 = lArray6[19] ^ lArray6[20];
        long l43 = lArray6[25] ^ lArray6[24];
        long l44 = lArray6[18] ^ lArray6[23];
        long l45 = l42 ^ l43;
        long l46 = l45 ^ l44;
        lArray3[4] = l6 = l46 ^ l41;
        long l47 = l10 ^ l8;
        long l48 = l45 ^ l47;
        long l49 = lArray6[21] ^ lArray6[22];
        lArray3[5] = l5 = l48 ^ l49;
        long l50 = l32 ^ lArray6[0];
        long l51 = l50 ^ lArray6[9];
        long l52 = l51 ^ l33;
        long l53 = l52 ^ lArray6[21];
        long l54 = l53 ^ lArray6[23];
        lArray3[6] = l4 = l54 ^ lArray6[25];
        SecT283Field.implCompactExt(lArray3);
    }

    protected static void implMulw(long l4, long l5, long[] lArray, int n4) {
        long[] lArray2 = new long[8];
        lArray2[1] = l5;
        lArray2[2] = lArray2[1] << 1;
        lArray2[3] = lArray2[2] ^ l5;
        lArray2[4] = lArray2[2] << 1;
        lArray2[5] = lArray2[4] ^ l5;
        lArray2[6] = lArray2[3] << 1;
        lArray2[7] = lArray2[6] ^ l5;
        int n5 = (int)l4;
        long l6 = 0L;
        long l7 = lArray2[n5 & 7];
        int n6 = 48;
        do {
            n5 = (int)(l4 >>> n6);
            long l8 = lArray2[n5 & 7] ^ lArray2[n5 >>> 3 & 7] << 3 ^ lArray2[n5 >>> 6 & 7] << 6;
            l7 ^= l8 << n6;
            l6 ^= l8 >>> -n6;
        } while ((n6 -= 9) > 0);
        lArray[n4] = l7 & 0x1FFFFFFFFFFFFFFL;
        lArray[n4 + 1] = l7 >>> 57 ^ (l6 ^= (l4 & 0x100804020100800L & l5 << 7 >> 63) >>> 8) << 7;
    }

    protected static void implSquare(long[] lArray, long[] lArray2) {
        for (int i4 = 0; i4 < 4; ++i4) {
            Interleave.expand64To128(lArray[i4], lArray2, i4 << 1);
        }
        lArray2[8] = Interleave.expand32to64((int)lArray[4]);
    }
}

