/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.math.raw.Nat576;

public class SecT571Field {
    private static final long M59 = 0x7FFFFFFFFFFFFFFL;
    private static final long RM = -1190112520884487202L;
    private static final long[] ROOT_Z = new long[]{3161836309350906777L, -7642453882179322845L, -3821226941089661423L, 7312758566309945096L, -556661012383879292L, 8945041530681231562L, -4750851271514160027L, 6847946401097695794L, 541669439031730457L};

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        for (int i4 = 0; i4 < 9; ++i4) {
            lArray3[i4] = lArray[i4] ^ lArray2[i4];
        }
    }

    private static void add(long[] lArray, int n4, long[] lArray2, int n5, long[] lArray3, int n6) {
        for (int i4 = 0; i4 < 9; ++i4) {
            lArray3[n6 + i4] = lArray[n4 + i4] ^ lArray2[n5 + i4];
        }
    }

    private static void addBothTo(long[] lArray, int n4, long[] lArray2, int n5, long[] lArray3, int n6) {
        for (int i4 = 0; i4 < 9; ++i4) {
            int n7 = n6 + i4;
            lArray3[n7] = lArray3[n7] ^ (lArray[n4 + i4] ^ lArray2[n5 + i4]);
        }
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        for (int i4 = 0; i4 < 18; ++i4) {
            lArray3[i4] = lArray[i4] ^ lArray2[i4];
        }
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray[0] ^ 1L;
        for (int i4 = 1; i4 < 9; ++i4) {
            lArray2[i4] = lArray[i4];
        }
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        long[] lArray = Nat576.fromBigInteger64(bigInteger);
        SecT571Field.reduce5(lArray, 0);
        return lArray;
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (Nat576.isZero64(lArray)) {
            throw new IllegalStateException();
        }
        long[] lArray3 = Nat576.create64();
        long[] lArray4 = Nat576.create64();
        long[] lArray5 = Nat576.create64();
        SecT571Field.square(lArray, lArray5);
        SecT571Field.square(lArray5, lArray3);
        SecT571Field.square(lArray3, lArray4);
        SecT571Field.multiply(lArray3, lArray4, lArray3);
        SecT571Field.squareN(lArray3, 2, lArray4);
        SecT571Field.multiply(lArray3, lArray4, lArray3);
        SecT571Field.multiply(lArray3, lArray5, lArray3);
        SecT571Field.squareN(lArray3, 5, lArray4);
        SecT571Field.multiply(lArray3, lArray4, lArray3);
        SecT571Field.squareN(lArray4, 5, lArray4);
        SecT571Field.multiply(lArray3, lArray4, lArray3);
        SecT571Field.squareN(lArray3, 15, lArray4);
        SecT571Field.multiply(lArray3, lArray4, lArray5);
        SecT571Field.squareN(lArray5, 30, lArray3);
        SecT571Field.squareN(lArray3, 30, lArray4);
        SecT571Field.multiply(lArray3, lArray4, lArray3);
        SecT571Field.squareN(lArray3, 60, lArray4);
        SecT571Field.multiply(lArray3, lArray4, lArray3);
        SecT571Field.squareN(lArray4, 60, lArray4);
        SecT571Field.multiply(lArray3, lArray4, lArray3);
        SecT571Field.squareN(lArray3, 180, lArray4);
        SecT571Field.multiply(lArray3, lArray4, lArray3);
        SecT571Field.squareN(lArray4, 180, lArray4);
        SecT571Field.multiply(lArray3, lArray4, lArray3);
        SecT571Field.multiply(lArray3, lArray5, lArray2);
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat576.createExt64();
        SecT571Field.implMultiply(lArray, lArray2, lArray4);
        SecT571Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat576.createExt64();
        SecT571Field.implMultiply(lArray, lArray2, lArray4);
        SecT571Field.addExt(lArray3, lArray4, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l4 = lArray[9];
        long l5 = lArray[17];
        long l6 = l4;
        l4 = l6 ^ l5 >>> 59 ^ l5 >>> 57 ^ l5 >>> 54 ^ l5 >>> 49;
        l6 = lArray[8] ^ l5 << 5 ^ l5 << 7 ^ l5 << 10 ^ l5 << 15;
        for (int i4 = 16; i4 >= 10; --i4) {
            l5 = lArray[i4];
            lArray2[i4 - 8] = l6 ^ l5 >>> 59 ^ l5 >>> 57 ^ l5 >>> 54 ^ l5 >>> 49;
            l6 = lArray[i4 - 9] ^ l5 << 5 ^ l5 << 7 ^ l5 << 10 ^ l5 << 15;
        }
        l5 = l4;
        lArray2[1] = l6 ^ l5 >>> 59 ^ l5 >>> 57 ^ l5 >>> 54 ^ l5 >>> 49;
        l6 = lArray[0] ^ l5 << 5 ^ l5 << 7 ^ l5 << 10 ^ l5 << 15;
        long l7 = lArray2[8];
        long l8 = l7 >>> 59;
        lArray2[0] = l6 ^ l8 ^ l8 << 2 ^ l8 << 5 ^ l8 << 10;
        lArray2[8] = l7 & 0x7FFFFFFFFFFFFFFL;
    }

    public static void reduce5(long[] lArray, int n4) {
        long l4 = lArray[n4 + 8];
        long l5 = l4 >>> 59;
        int n5 = n4;
        lArray[n5] = lArray[n5] ^ (l5 ^ l5 << 2 ^ l5 << 5 ^ l5 << 10);
        lArray[n4 + 8] = l4 & 0x7FFFFFFFFFFFFFFL;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat576.create64();
        long[] lArray4 = Nat576.create64();
        int n4 = 0;
        for (int i4 = 0; i4 < 4; ++i4) {
            long l4 = Interleave.unshuffle(lArray[n4++]);
            long l5 = Interleave.unshuffle(lArray[n4++]);
            lArray3[i4] = l4 & 0xFFFFFFFFL | l5 << 32;
            lArray4[i4] = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        }
        long l6 = Interleave.unshuffle(lArray[n4]);
        lArray3[4] = l6 & 0xFFFFFFFFL;
        lArray4[4] = l6 >>> 32;
        SecT571Field.multiply(lArray4, ROOT_Z, lArray2);
        SecT571Field.add(lArray2, lArray3, lArray2);
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat576.createExt64();
        SecT571Field.implSquare(lArray, lArray3);
        SecT571Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat576.createExt64();
        SecT571Field.implSquare(lArray, lArray3);
        SecT571Field.addExt(lArray2, lArray3, lArray2);
    }

    public static void squareN(long[] lArray, int n4, long[] lArray2) {
        long[] lArray3 = Nat576.createExt64();
        SecT571Field.implSquare(lArray, lArray3);
        SecT571Field.reduce(lArray3, lArray2);
        while (--n4 > 0) {
            SecT571Field.implSquare(lArray2, lArray3);
            SecT571Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)(lArray[0] ^ lArray[8] >>> 49 ^ lArray[8] >>> 57) & 1;
    }

    protected static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        long[] lArray4 = new long[144];
        System.arraycopy(lArray2, 0, lArray4, 9, 9);
        int n9 = 0;
        for (int i4 = 7; i4 > 0; --i4) {
            Nat.shiftUpBit64(9, lArray4, (n9 += 18) >>> 1, 0L, lArray4, n9);
            SecT571Field.reduce5(lArray4, n9);
            SecT571Field.add(lArray4, 9, lArray4, n9, lArray4, n9 + 9);
        }
        long[] lArray5 = new long[lArray4.length];
        Nat.shiftUpBits64(lArray4.length, lArray4, 0, 4, 0L, lArray5, 0);
        int n10 = 15;
        for (n8 = 56; n8 >= 0; n8 -= 8) {
            for (n7 = 1; n7 < 9; n7 += 2) {
                n6 = (int)(lArray[n7] >>> n8);
                n5 = n6 & n10;
                n4 = n6 >>> 4 & n10;
                SecT571Field.addBothTo(lArray4, 9 * n5, lArray5, 9 * n4, lArray3, n7 - 1);
            }
            Nat.shiftUpBits64(16, lArray3, 0, 8, 0L);
        }
        for (n8 = 56; n8 >= 0; n8 -= 8) {
            for (n7 = 0; n7 < 9; n7 += 2) {
                n6 = (int)(lArray[n7] >>> n8);
                n5 = n6 & n10;
                n4 = n6 >>> 4 & n10;
                SecT571Field.addBothTo(lArray4, 9 * n5, lArray5, 9 * n4, lArray3, n7);
            }
            if (n8 <= 0) continue;
            Nat.shiftUpBits64(18, lArray3, 0, 8, 0L);
        }
    }

    protected static void implMulwAcc(long[] lArray, long l4, long[] lArray2, int n4) {
        long[] lArray3 = new long[32];
        lArray3[1] = l4;
        for (int i4 = 2; i4 < 32; i4 += 2) {
            lArray3[i4] = lArray3[i4 >>> 1] << 1;
            lArray3[i4 + 1] = lArray3[i4] ^ l4;
        }
        long l5 = 0L;
        for (int i5 = 0; i5 < 9; ++i5) {
            long l6 = lArray[i5];
            int n5 = (int)l6;
            l5 ^= lArray3[n5 & 0x1F];
            long l7 = 0L;
            int n6 = 60;
            do {
                n5 = (int)(l6 >>> n6);
                long l8 = lArray3[n5 & 0x1F];
                l5 ^= l8 << n6;
                l7 ^= l8 >>> -n6;
            } while ((n6 -= 5) > 0);
            for (int i6 = 0; i6 < 4; ++i6) {
                l6 = (l6 & 0xEF7BDEF7BDEF7BDEL) >>> 1;
                l7 ^= l6 & l4 << i6 >> 63;
            }
            int n7 = n4 + i5;
            lArray2[n7] = lArray2[n7] ^ l5;
            l5 = l7;
        }
        int n8 = n4 + 9;
        lArray2[n8] = lArray2[n8] ^ l5;
    }

    protected static void implSquare(long[] lArray, long[] lArray2) {
        for (int i4 = 0; i4 < 9; ++i4) {
            Interleave.expand64To128(lArray[i4], lArray2, i4 << 1);
        }
    }
}

