/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sphincs;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.sphincs.Permute;
import org.bouncycastle.util.Strings;

class HashFunctions {
    private static final byte[] hashc = Strings.toByteArray("expand 32-byte to 64-byte state!");
    private final Digest dig256;
    private final Digest dig512;
    private final Permute perm = new Permute();

    HashFunctions(Digest digest) {
        this(digest, null);
    }

    HashFunctions(Digest digest, Digest digest2) {
        this.dig256 = digest;
        this.dig512 = digest2;
    }

    int varlen_hash(byte[] byArray, int n4, byte[] byArray2, int n5) {
        this.dig256.update(byArray2, 0, n5);
        this.dig256.doFinal(byArray, n4);
        return 0;
    }

    Digest getMessageHash() {
        return this.dig512;
    }

    int hash_2n_n(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6;
        byte[] byArray3 = new byte[64];
        for (n6 = 0; n6 < 32; ++n6) {
            byArray3[n6] = byArray2[n5 + n6];
            byArray3[n6 + 32] = hashc[n6];
        }
        this.perm.chacha_permute(byArray3, byArray3);
        for (n6 = 0; n6 < 32; ++n6) {
            byArray3[n6] = (byte)(byArray3[n6] ^ byArray2[n5 + n6 + 32]);
        }
        this.perm.chacha_permute(byArray3, byArray3);
        for (n6 = 0; n6 < 32; ++n6) {
            byArray[n4 + n6] = byArray3[n6];
        }
        return 0;
    }

    int hash_2n_n_mask(byte[] byArray, int n4, byte[] byArray2, int n5, byte[] byArray3, int n6) {
        byte[] byArray4 = new byte[64];
        for (int i4 = 0; i4 < 64; ++i4) {
            byArray4[i4] = (byte)(byArray2[n5 + i4] ^ byArray3[n6 + i4]);
        }
        int n7 = this.hash_2n_n(byArray, n4, byArray4, 0);
        return n7;
    }

    int hash_n_n(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6;
        byte[] byArray3 = new byte[64];
        for (n6 = 0; n6 < 32; ++n6) {
            byArray3[n6] = byArray2[n5 + n6];
            byArray3[n6 + 32] = hashc[n6];
        }
        this.perm.chacha_permute(byArray3, byArray3);
        for (n6 = 0; n6 < 32; ++n6) {
            byArray[n4 + n6] = byArray3[n6];
        }
        return 0;
    }

    int hash_n_n_mask(byte[] byArray, int n4, byte[] byArray2, int n5, byte[] byArray3, int n6) {
        byte[] byArray4 = new byte[32];
        for (int i4 = 0; i4 < 32; ++i4) {
            byArray4[i4] = (byte)(byArray2[n5 + i4] ^ byArray3[n6 + i4]);
        }
        return this.hash_n_n(byArray, n4, byArray4, 0);
    }
}

