/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sphincs;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.sphincs.HashFunctions;
import org.bouncycastle.pqc.crypto.sphincs.Horst;
import org.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.sphincs.Seed;
import org.bouncycastle.pqc.crypto.sphincs.Tree;
import org.bouncycastle.pqc.crypto.sphincs.Wots;
import org.bouncycastle.util.Pack;

public class SPHINCS256Signer
implements MessageSigner {
    private final HashFunctions hashFunctions;
    private byte[] keyData;

    public SPHINCS256Signer(Digest digest, Digest digest2) {
        if (digest.getDigestSize() != 32) {
            throw new IllegalArgumentException("n-digest needs to produce 32 bytes of output");
        }
        if (digest2.getDigestSize() != 64) {
            throw new IllegalArgumentException("2n-digest needs to produce 64 bytes of output");
        }
        this.hashFunctions = new HashFunctions(digest, digest2);
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.keyData = bl ? ((SPHINCSPrivateKeyParameters)cipherParameters).getKeyData() : ((SPHINCSPublicKeyParameters)cipherParameters).getKeyData();
    }

    public byte[] generateSignature(byte[] byArray) {
        return this.crypto_sign(this.hashFunctions, byArray, this.keyData);
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        return this.verify(this.hashFunctions, byArray, byArray2, this.keyData);
    }

    static void validate_authpath(HashFunctions hashFunctions, byte[] byArray, byte[] byArray2, int n4, byte[] byArray3, int n5, byte[] byArray4, int n6) {
        int n7;
        byte[] byArray5 = new byte[64];
        if ((n4 & 1) != 0) {
            for (n7 = 0; n7 < 32; ++n7) {
                byArray5[32 + n7] = byArray2[n7];
            }
            for (n7 = 0; n7 < 32; ++n7) {
                byArray5[n7] = byArray3[n5 + n7];
            }
        } else {
            for (n7 = 0; n7 < 32; ++n7) {
                byArray5[n7] = byArray2[n7];
            }
            for (n7 = 0; n7 < 32; ++n7) {
                byArray5[32 + n7] = byArray3[n5 + n7];
            }
        }
        int n8 = n5 + 32;
        for (int i4 = 0; i4 < n6 - 1; ++i4) {
            if (((n4 >>>= 1) & 1) != 0) {
                hashFunctions.hash_2n_n_mask(byArray5, 32, byArray5, 0, byArray4, 2 * (7 + i4) * 32);
                for (n7 = 0; n7 < 32; ++n7) {
                    byArray5[n7] = byArray3[n8 + n7];
                }
            } else {
                hashFunctions.hash_2n_n_mask(byArray5, 0, byArray5, 0, byArray4, 2 * (7 + i4) * 32);
                for (n7 = 0; n7 < 32; ++n7) {
                    byArray5[n7 + 32] = byArray3[n8 + n7];
                }
            }
            n8 += 32;
        }
        hashFunctions.hash_2n_n_mask(byArray, 0, byArray5, 0, byArray4, 2 * (7 + n6 - 1) * 32);
    }

    static void compute_authpath_wots(HashFunctions hashFunctions, byte[] byArray, byte[] byArray2, int n4, Tree.leafaddr leafaddr2, byte[] byArray3, byte[] byArray4, int n5) {
        int n6;
        Tree.leafaddr leafaddr3 = new Tree.leafaddr(leafaddr2);
        byte[] byArray5 = new byte[2048];
        byte[] byArray6 = new byte[1024];
        byte[] byArray7 = new byte[68608];
        leafaddr3.subleaf = 0L;
        while (leafaddr3.subleaf < 32L) {
            Seed.get_seed(hashFunctions, byArray6, (int)(leafaddr3.subleaf * 32L), byArray3, leafaddr3);
            ++leafaddr3.subleaf;
        }
        Wots wots = new Wots();
        leafaddr3.subleaf = 0L;
        while (leafaddr3.subleaf < 32L) {
            wots.wots_pkgen(hashFunctions, byArray7, (int)(leafaddr3.subleaf * 67L * 32L), byArray6, (int)(leafaddr3.subleaf * 32L), byArray4, 0);
            ++leafaddr3.subleaf;
        }
        leafaddr3.subleaf = 0L;
        while (leafaddr3.subleaf < 32L) {
            Tree.l_tree(hashFunctions, byArray5, (int)(1024L + leafaddr3.subleaf * 32L), byArray7, (int)(leafaddr3.subleaf * 67L * 32L), byArray4, 0);
            ++leafaddr3.subleaf;
        }
        int n7 = 0;
        for (n6 = 32; n6 > 0; n6 >>>= 1) {
            for (int i4 = 0; i4 < n6; i4 += 2) {
                hashFunctions.hash_2n_n_mask(byArray5, (n6 >>> 1) * 32 + (i4 >>> 1) * 32, byArray5, n6 * 32 + i4 * 32, byArray4, 2 * (7 + n7) * 32);
            }
            ++n7;
        }
        int n8 = (int)leafaddr2.subleaf;
        for (n6 = 0; n6 < n5; ++n6) {
            System.arraycopy(byArray5, (32 >>> n6) * 32 + (n8 >>> n6 ^ 1) * 32, byArray2, n4 + n6 * 32, 32);
        }
        System.arraycopy(byArray5, 32, byArray, 0, 32);
    }

    byte[] crypto_sign(HashFunctions hashFunctions, byte[] byArray, byte[] byArray2) {
        int n4;
        byte[] byArray3 = new byte[41000];
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[64];
        long[] lArray = new long[8];
        byte[] byArray6 = new byte[32];
        byte[] byArray7 = new byte[32];
        byte[] byArray8 = new byte[1024];
        byte[] byArray9 = new byte[1088];
        for (n4 = 0; n4 < 1088; ++n4) {
            byArray9[n4] = byArray2[n4];
        }
        int n5 = 40968;
        System.arraycopy(byArray9, 1056, byArray3, n5, 32);
        Digest digest = hashFunctions.getMessageHash();
        Object object = new byte[digest.getDigestSize()];
        digest.update(byArray3, n5, 32);
        digest.update(byArray, 0, byArray.length);
        digest.doFinal((byte[])object, 0);
        this.zerobytes(byArray3, n5, 32);
        for (int i4 = 0; i4 != lArray.length; ++i4) {
            lArray[i4] = Pack.littleEndianToLong(object, i4 * 8);
        }
        long l4 = lArray[0] & 0xFFFFFFFFFFFFFFFL;
        System.arraycopy(object, 16, byArray4, 0, 32);
        n5 = 39912;
        System.arraycopy(byArray4, 0, byArray3, n5, 32);
        Tree.leafaddr leafaddr2 = new Tree.leafaddr();
        leafaddr2.level = 11;
        leafaddr2.subtree = 0L;
        leafaddr2.subleaf = 0L;
        int n6 = n5 + 32;
        System.arraycopy(byArray9, 32, byArray3, n6, 1024);
        Tree.treehash(hashFunctions, byArray3, n6 + 1024, 5, byArray9, leafaddr2, byArray3, n6);
        digest = hashFunctions.getMessageHash();
        digest.update(byArray3, n5, 1088);
        digest.update(byArray, 0, byArray.length);
        digest.doFinal(byArray5, 0);
        Tree.leafaddr leafaddr3 = new Tree.leafaddr();
        leafaddr3.level = 12;
        leafaddr3.subleaf = (int)(l4 & 0x1FL);
        leafaddr3.subtree = l4 >>> 5;
        for (n4 = 0; n4 < 32; ++n4) {
            byArray3[n4] = byArray4[n4];
        }
        int n7 = 32;
        System.arraycopy(byArray9, 32, byArray8, 0, 1024);
        for (n4 = 0; n4 < 8; ++n4) {
            byArray3[n7 + n4] = (byte)(l4 >>> 8 * n4 & 0xFFL);
        }
        Seed.get_seed(hashFunctions, byArray7, 0, byArray9, leafaddr3);
        object = new Horst();
        int n8 = Horst.horst_sign(hashFunctions, byArray3, n7 += 8, byArray6, byArray7, byArray8, byArray5);
        n7 += n8;
        Wots wots = new Wots();
        n4 = 0;
        while (n4 < 12) {
            leafaddr3.level = n4++;
            Seed.get_seed(hashFunctions, byArray7, 0, byArray9, leafaddr3);
            wots.wots_sign(hashFunctions, byArray3, n7, byArray6, byArray7, byArray8);
            SPHINCS256Signer.compute_authpath_wots(hashFunctions, byArray6, byArray3, n7 += 2144, leafaddr3, byArray9, byArray8, 5);
            n7 += 160;
            leafaddr3.subleaf = (int)(leafaddr3.subtree & 0x1FL);
            leafaddr3.subtree >>>= 5;
        }
        this.zerobytes(byArray9, 0, 1088);
        return byArray3;
    }

    private void zerobytes(byte[] byArray, int n4, int n5) {
        for (int i4 = 0; i4 != n5; ++i4) {
            byArray[n4 + i4] = 0;
        }
    }

    boolean verify(HashFunctions hashFunctions, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n4;
        int n5 = byArray2.length;
        long l4 = 0L;
        byte[] byArray4 = new byte[2144];
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = new byte[32];
        byte[] byArray7 = new byte[41000];
        byte[] byArray8 = new byte[1056];
        if (n5 != 41000) {
            throw new IllegalArgumentException("signature wrong size");
        }
        byte[] byArray9 = new byte[64];
        for (n4 = 0; n4 < 1056; ++n4) {
            byArray8[n4] = byArray3[n4];
        }
        Object object = new byte[32];
        for (n4 = 0; n4 < 32; ++n4) {
            object[n4] = byArray2[n4];
        }
        System.arraycopy(byArray2, 0, byArray7, 0, 41000);
        Digest digest = hashFunctions.getMessageHash();
        digest.update((byte[])object, 0, 32);
        digest.update(byArray8, 0, 1056);
        digest.update(byArray, 0, byArray.length);
        digest.doFinal(byArray9, 0);
        int n6 = 0;
        n6 += 32;
        n5 -= 32;
        for (n4 = 0; n4 < 8; ++n4) {
            l4 ^= (long)(byArray7[n6 + n4] & 0xFF) << 8 * n4;
        }
        new Horst();
        Horst.horst_verify(hashFunctions, byArray6, byArray7, n6 + 8, byArray8, byArray9);
        n6 += 8;
        n5 -= 8;
        n6 += 13312;
        n5 -= 13312;
        object = new Wots();
        for (n4 = 0; n4 < 12; ++n4) {
            ((Wots)object).wots_verify(hashFunctions, byArray4, byArray7, n6, byArray6, byArray8);
            n5 -= 2144;
            Tree.l_tree(hashFunctions, byArray5, 0, byArray4, 0, byArray8, 0);
            SPHINCS256Signer.validate_authpath(hashFunctions, byArray6, byArray5, (int)(l4 & 0x1FL), byArray7, n6 += 2144, byArray8, 5);
            l4 >>= 5;
            n6 += 160;
            n5 -= 160;
        }
        boolean bl = true;
        for (n4 = 0; n4 < 32; ++n4) {
            if (byArray6[n4] == byArray8[n4 + 1024]) continue;
            bl = false;
        }
        return bl;
    }
}

