/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Provider;
import java.security.SecureRandom;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.encoders.Hex;

public class FixedSecureRandom
extends SecureRandom {
    private static java.math.BigInteger REGULAR = new java.math.BigInteger("01020304ffffffff0506070811111111", 16);
    private static java.math.BigInteger ANDROID = new java.math.BigInteger("1111111105060708ffffffff01020304", 16);
    private static java.math.BigInteger CLASSPATH = new java.math.BigInteger("3020104ffffffff05060708111111", 16);
    private static final boolean isAndroidStyle;
    private static final boolean isClasspathStyle;
    private static final boolean isRegularStyle;
    private byte[] _data;
    private int _index;

    public FixedSecureRandom(byte[] byArray) {
        this(new Source[]{new Data(byArray)});
    }

    public FixedSecureRandom(byte[][] byArray) {
        this(FixedSecureRandom.buildDataArray(byArray));
    }

    private static Data[] buildDataArray(byte[][] byArray) {
        Data[] dataArray = new Data[byArray.length];
        for (int i4 = 0; i4 != byArray.length; ++i4) {
            dataArray[i4] = new Data(byArray[i4]);
        }
        return dataArray;
    }

    public FixedSecureRandom(Source[] sourceArray) {
        super(null, new DummyProvider());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (isRegularStyle) {
            if (isClasspathStyle) {
                for (int i4 = 0; i4 != sourceArray.length; ++i4) {
                    try {
                        if (sourceArray[i4] instanceof BigInteger) {
                            int n4;
                            byte[] byArray = sourceArray[i4].data;
                            int n5 = byArray.length - byArray.length % 4;
                            for (n4 = byArray.length - n5 - 1; n4 >= 0; --n4) {
                                byteArrayOutputStream.write(byArray[n4]);
                            }
                            for (n4 = byArray.length - n5; n4 < byArray.length; n4 += 4) {
                                byteArrayOutputStream.write(byArray, n4, 4);
                            }
                            continue;
                        }
                        byteArrayOutputStream.write(sourceArray[i4].data);
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("can't save value source.");
                    }
                }
            } else {
                for (int i5 = 0; i5 != sourceArray.length; ++i5) {
                    try {
                        byteArrayOutputStream.write(sourceArray[i5].data);
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("can't save value source.");
                    }
                }
            }
        } else if (isAndroidStyle) {
            for (int i6 = 0; i6 != sourceArray.length; ++i6) {
                try {
                    if (sourceArray[i6] instanceof BigInteger) {
                        int n6;
                        byte[] byArray = sourceArray[i6].data;
                        int n7 = byArray.length - byArray.length % 4;
                        for (n6 = 0; n6 < n7; n6 += 4) {
                            byteArrayOutputStream.write(byArray, byArray.length - (n6 + 4), 4);
                        }
                        if (byArray.length - n7 != 0) {
                            for (n6 = 0; n6 != 4 - (byArray.length - n7); ++n6) {
                                byteArrayOutputStream.write(0);
                            }
                        }
                        for (n6 = 0; n6 != byArray.length - n7; ++n6) {
                            byteArrayOutputStream.write(byArray[n7 + n6]);
                        }
                        continue;
                    }
                    byteArrayOutputStream.write(sourceArray[i6].data);
                    continue;
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("can't save value source.");
                }
            }
        } else {
            throw new IllegalStateException("Unrecognized BigInteger implementation");
        }
        this._data = byteArrayOutputStream.toByteArray();
    }

    public void nextBytes(byte[] byArray) {
        System.arraycopy(this._data, this._index, byArray, 0, byArray.length);
        this._index += byArray.length;
    }

    public byte[] generateSeed(int n4) {
        byte[] byArray = new byte[n4];
        this.nextBytes(byArray);
        return byArray;
    }

    public int nextInt() {
        int n4 = 0;
        n4 |= this.nextValue() << 24;
        n4 |= this.nextValue() << 16;
        n4 |= this.nextValue() << 8;
        return n4 |= this.nextValue();
    }

    public long nextLong() {
        long l4 = 0L;
        l4 |= (long)this.nextValue() << 56;
        l4 |= (long)this.nextValue() << 48;
        l4 |= (long)this.nextValue() << 40;
        l4 |= (long)this.nextValue() << 32;
        l4 |= (long)this.nextValue() << 24;
        l4 |= (long)this.nextValue() << 16;
        l4 |= (long)this.nextValue() << 8;
        return l4 |= (long)this.nextValue();
    }

    public boolean isExhausted() {
        return this._index == this._data.length;
    }

    private int nextValue() {
        return this._data[this._index++] & 0xFF;
    }

    private static byte[] expandToBitLength(int n4, byte[] byArray) {
        if ((n4 + 7) / 8 > byArray.length) {
            byte[] byArray2 = new byte[(n4 + 7) / 8];
            System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
            if (isAndroidStyle && n4 % 8 != 0) {
                int n5 = Pack.bigEndianToInt(byArray2, 0);
                Pack.intToBigEndian(n5 << 8 - n4 % 8, byArray2, 0);
            }
            return byArray2;
        }
        if (isAndroidStyle && n4 < byArray.length * 8 && n4 % 8 != 0) {
            int n6 = Pack.bigEndianToInt(byArray, 0);
            Pack.intToBigEndian(n6 << 8 - n4 % 8, byArray, 0);
        }
        return byArray;
    }

    static {
        java.math.BigInteger bigInteger = new java.math.BigInteger(128, new RandomChecker());
        java.math.BigInteger bigInteger2 = new java.math.BigInteger(120, new RandomChecker());
        isAndroidStyle = bigInteger.equals(ANDROID);
        isRegularStyle = bigInteger.equals(REGULAR);
        isClasspathStyle = bigInteger2.equals(CLASSPATH);
    }

    public static class BigInteger
    extends Source {
        public BigInteger(byte[] byArray) {
            super(byArray);
        }

        public BigInteger(int n4, byte[] byArray) {
            super(FixedSecureRandom.expandToBitLength(n4, byArray));
        }

        public BigInteger(String string) {
            this(Hex.decode(string));
        }

        public BigInteger(int n4, String string) {
            super(FixedSecureRandom.expandToBitLength(n4, Hex.decode(string)));
        }
    }

    public static class Data
    extends Source {
        public Data(byte[] byArray) {
            super(byArray);
        }
    }

    private static class DummyProvider
    extends Provider {
        DummyProvider() {
            super("BCFIPS_FIXED_RNG", 1.0, "BCFIPS Fixed Secure Random Provider");
        }
    }

    private static class RandomChecker
    extends SecureRandom {
        byte[] data = Hex.decode("01020304ffffffff0506070811111111");
        int index = 0;

        RandomChecker() {
            super(null, new DummyProvider());
        }

        public void nextBytes(byte[] byArray) {
            System.arraycopy(this.data, this.index, byArray, 0, byArray.length);
            this.index += byArray.length;
        }
    }

    public static class Source {
        byte[] data;

        Source(byte[] byArray) {
            this.data = byArray;
        }
    }
}

