/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.regex;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.checker.index.qual.GTENegativeOne;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.EnsuresQualifierIf;

public final class RegexUtil {
    private RegexUtil() {
        throw new Error("do not instantiate");
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(String s4) {
        return RegexUtil.isRegex(s4, 0);
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(String s4, int groups2) {
        Pattern p4;
        try {
            p4 = Pattern.compile(s4);
        }
        catch (PatternSyntaxException e5) {
            return false;
        }
        return RegexUtil.getGroupCount(p4) >= groups2;
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(char c5) {
        return RegexUtil.isRegex(Character.toString(c5));
    }

    @SideEffectFree
    public static @Nullable String regexError(String s4) {
        return RegexUtil.regexError(s4, 0);
    }

    @SideEffectFree
    public static @Nullable String regexError(String s4, int groups2) {
        try {
            Pattern p4 = Pattern.compile(s4);
            int actualGroups = RegexUtil.getGroupCount(p4);
            if (actualGroups < groups2) {
                return RegexUtil.regexErrorMessage(s4, groups2, actualGroups);
            }
        }
        catch (PatternSyntaxException e5) {
            return e5.getMessage();
        }
        return null;
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String s4) {
        return RegexUtil.regexException(s4, 0);
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String s4, int groups2) {
        try {
            Pattern p4 = Pattern.compile(s4);
            int actualGroups = RegexUtil.getGroupCount(p4);
            if (actualGroups < groups2) {
                return new PatternSyntaxException(RegexUtil.regexErrorMessage(s4, groups2, actualGroups), s4, -1);
            }
        }
        catch (PatternSyntaxException pse) {
            return pse;
        }
        return null;
    }

    @SideEffectFree
    public static @Regex String asRegex(String s4) {
        return RegexUtil.asRegex(s4, 0);
    }

    @SideEffectFree
    public static @Regex String asRegex(String s4, int groups2) {
        try {
            Pattern p4 = Pattern.compile(s4);
            int actualGroups = RegexUtil.getGroupCount(p4);
            if (actualGroups < groups2) {
                throw new Error(RegexUtil.regexErrorMessage(s4, groups2, actualGroups));
            }
            return s4;
        }
        catch (PatternSyntaxException e5) {
            throw new Error(e5);
        }
    }

    @SideEffectFree
    private static String regexErrorMessage(String s4, int expectedGroups, int actualGroups) {
        return "regex \"" + s4 + "\" has " + actualGroups + " groups, but " + expectedGroups + " groups are needed.";
    }

    @Pure
    private static int getGroupCount(Pattern p4) {
        return p4.matcher("").groupCount();
    }

    public static class CheckedPatternSyntaxException
    extends Exception {
        private static final long serialVersionUID = 6266881831979001480L;
        private final PatternSyntaxException pse;

        public CheckedPatternSyntaxException(PatternSyntaxException pse) {
            this.pse = pse;
        }

        public CheckedPatternSyntaxException(String desc, String regex, @GTENegativeOne int index) {
            this(new PatternSyntaxException(desc, regex, index));
        }

        public String getDescription() {
            return this.pse.getDescription();
        }

        public int getIndex() {
            return this.pse.getIndex();
        }

        @Override
        @Pure
        public String getMessage(@GuardSatisfied CheckedPatternSyntaxException this) {
            return this.pse.getMessage();
        }

        public String getPattern() {
            return this.pse.getPattern();
        }
    }
}

