/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.json.internal.json_simple;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ItemList {
    private String sp = ",";
    List items = new ArrayList();

    public ItemList() {
    }

    public ItemList(String s4) {
        this.split(s4, this.sp, this.items);
    }

    public ItemList(String s4, String sp) {
        this.sp = s4;
        this.split(s4, sp, this.items);
    }

    public ItemList(String s4, String sp, boolean isMultiToken) {
        this.split(s4, sp, this.items, isMultiToken);
    }

    public List getItems() {
        return this.items;
    }

    public String[] getArray() {
        return (String[])this.items.toArray();
    }

    public void split(String s4, String sp, List append, boolean isMultiToken) {
        if (s4 == null || sp == null) {
            return;
        }
        if (isMultiToken) {
            StringTokenizer tokens = new StringTokenizer(s4, sp);
            while (tokens.hasMoreTokens()) {
                append.add(tokens.nextToken().trim());
            }
        } else {
            this.split(s4, sp, append);
        }
    }

    public void split(String s4, String sp, List append) {
        if (s4 == null || sp == null) {
            return;
        }
        int pos = 0;
        int prevPos = 0;
        do {
            prevPos = pos;
            if ((pos = s4.indexOf(sp, pos)) == -1) break;
            append.add(s4.substring(prevPos, pos).trim());
        } while ((pos += sp.length()) != -1);
        append.add(s4.substring(prevPos).trim());
    }

    public void setSP(String sp) {
        this.sp = sp;
    }

    public void add(int i4, String item) {
        if (item == null) {
            return;
        }
        this.items.add(i4, item.trim());
    }

    public void add(String item) {
        if (item == null) {
            return;
        }
        this.items.add(item.trim());
    }

    public void addAll(ItemList list2) {
        this.items.addAll(list2.items);
    }

    public void addAll(String s4) {
        this.split(s4, this.sp, this.items);
    }

    public void addAll(String s4, String sp) {
        this.split(s4, sp, this.items);
    }

    public void addAll(String s4, String sp, boolean isMultiToken) {
        this.split(s4, sp, this.items, isMultiToken);
    }

    public String get(int i4) {
        return (String)this.items.get(i4);
    }

    public int size() {
        return this.items.size();
    }

    public String toString() {
        return this.toString(this.sp);
    }

    public String toString(String sp) {
        StringBuilder sb = new StringBuilder();
        for (int i4 = 0; i4 < this.items.size(); ++i4) {
            if (i4 == 0) {
                sb.append(this.items.get(i4));
                continue;
            }
            sb.append(sp);
            sb.append(this.items.get(i4));
        }
        return sb.toString();
    }

    public void clear() {
        this.items.clear();
    }

    public void reset() {
        this.sp = ",";
        this.items.clear();
    }
}

