/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.lang;

public class ExceptionHelp {
    public static String toStringWithCauses(Throwable t4) {
        StringBuilder sb = new StringBuilder();
        sb.append(t4);
        while (t4.getCause() != null) {
            t4 = t4.getCause();
            sb.append("; caused by: ").append(t4);
        }
        return sb.toString();
    }

    public static String toStringWithCausesAndAbbreviatedStack(Throwable t4, Class stopAt) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (t4 != null) {
            if (!first) {
                sb.append("; caused by: ");
            }
            sb.append(t4).append(" at ");
            for (StackTraceElement ste : t4.getStackTrace()) {
                if (ste.getClassName().equals(stopAt.getName())) {
                    sb.append("...omitted...");
                    break;
                }
                sb.append(ste).append("; ");
            }
            t4 = t4.getCause();
            first = false;
        }
        return sb.toString();
    }
}

