--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'SQL_ASCII';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

--
-- Name: res_set; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE res_set AS (
	pidnum integer,
	nret smallint
);


ALTER TYPE public.res_set OWNER TO postgres;

--
-- Name: account_login(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION account_login(character varying, character varying, character varying) RETURNS res_set
    LANGUAGE plpgsql
    AS $_$declare
ppAccountID ALIAS FOR $1;
pPassword ALIAS FOR $2;
pClientIP ALIAS FOR $3;
pAccountID varchar(20);
pcount int;
pPwd char(32) default null;
pBAuthority int2 default 0;
pGMIP varchar(15) default null;

res res_set;

BEGIN
pAccountID = lower(ppAccountID);
res.nRet=-1;

SELECT INTO pcount count(mid) FROM "tb_user" WHERE mid=pAccountID;
IF pcount =0 THEN --This Account is not exist
res.pIdNum= -1;
res.nRet = 2;
RETURN res;
END IF;

SELECT INTO pPwd,pBAuthority,res.pIdNum pwd,byAuthority,idnum FROM "tb_user" WHERE mid=pAccountID;

IF pPwd IS null THEN
res.nRet = 2;
RETURN res;
ELSEIF pPwd <> pPassword THEN
res.nRet = 3;
RETURN res;
END IF;

IF pBAuthority = 255 THEN   --This Account was locked
res.nRet = 5;
RETURN res;
END IF;

--IF pBAuthority = 1 THEN   --gmAccount  Check ip (0-->User, 1-->GM, 255-->Locked)
--SELECT INTO pGMIP ip FROM gmip WHERE ip=pClientIP;
--IF pGMIP IS NULL THEN
--res.nRet = 4;
--RETURN res;
--END IF;
--END IF;

res.nRet = 1;
RETURN res;
END;
$_$;


ALTER FUNCTION public.account_login(character varying, character varying, character varying) OWNER TO spiritking;

--
-- Name: account_logout(character varying, character varying, character varying, character varying, integer); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION account_logout(character varying, character varying, character varying, character varying, integer) RETURNS smallint
    LANGUAGE plpgsql
    AS $_$
DECLARE
ppAccountID ALIAS FOR $1;
pCharID ALIAS FOR $2;
pServerIP ALIAS FOR $3;
pClientIP ALIAS FOR $4;
pServerID ALIAS FOR $5;
pAccountID varchar(21);

-- update billing data when logout
pPValue int2;
pExpireDate timestamp;
pBillingRule int2;
pFree bit;
pDeduction int2;
pAddTime int2;
pTimeFormat char(2);
pMID char(20);
pVPS int2;
pUnits real;

pTotalVPS int4 default 0;
pTimeLogin timestamp;
pDuring int4;
pTimeLogout timestamp;
pBrule int2;
pOriServerID int2;
pOriServerIP varchar(15);


integer_var integer;

BEGIN
pAccountID = lower(ppAccountID);
SELECT INTO pMID mid FROM tb_user where mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN
SELECT INTO pTimeLogin, pBrule, pOriServerID, pOriServerIP logindate, billingrule, serverid, serverip FROM currentuser WHERE mid=pAccountID;

pDuring = CAST(EXTRACT(EPOCH FROM now()) - EXTRACT(EPOCH FROM pTimeLogin) as int4) / 60;

UPDATE tb_user SET status=0, ExpireDate=now(),clientip=pClientIP WHERE mid=pAccountID;

-- 
INSERT INTO game_log (mid,strcharid,logindate,logoutdate,nduring,serverid,serverip,clientip)
VALUES
(pAccountID,pCharID,pTimeLogin,now(),pDuring,pServerID,pServerIP,pClientIP);

DELETE FROM currentuser WHERE mid=pAccountID;

-- Update user_aggregate - dsell@aeriagames.com
PERFORM age_createorupdate_accountactivity(pAccountID,CURRENT_TIMESTAMP);

return 1;
--ELSE
-- abnormal account( without Billing_Login )
--INSERT INTO  "Abnormal_Log"
--(MID,strCharID,logoutDate,ServerIP,ClientIp,ExpireDate,BillingRule,ServerID) 
--VALUES
--(pAccountID,pCharID,now(),pServerIP,pClientIP,pExpireDate,0,pServerID);
END IF;

return 1;
END;
$_$;


ALTER FUNCTION public.account_logout(character varying, character varying, character varying, character varying, integer) OWNER TO spiritking;

--
-- Name: age_create_gfaccount(character varying, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION age_create_gfaccount(p_name character varying, p_uid integer, p_passwd character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
BEGIN                                      

    INSERT INTO tb_user (mid, pwd, idnum, byauthority, regdate) VALUES (lower(p_name), p_passwd, p_uid, 0, now());
    RETURN 0;

END; 
$$;


ALTER FUNCTION public.age_create_gfaccount(p_name character varying, p_uid integer, p_passwd character varying) OWNER TO postgres;

--
-- Name: age_createorupdate_accountactivity(character varying, timestamp with time zone); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION age_createorupdate_accountactivity(p_name character varying, p_logtime timestamp with time zone) RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE 
  v_uid INT;
  v_count INT;
BEGIN
  SELECT INTO v_uid idnum FROM tb_user WHERE mid = p_name;
  
  IF NOT FOUND THEN
    return 0;
  END IF;
  
  SELECT INTO v_count COUNT(*) FROM age_user_aggregate WHERE uid = v_uid;
  IF v_count = 0 THEN
    INSERT INTO age_user_aggregate (uid, first_activity, last_activity) VALUES (v_uid, p_logtime, p_logtime);
  ELSE
    UPDATE age_user_aggregate SET last_activity = p_logtime WHERE uid = v_uid AND p_logtime > last_activity;
  END IF;
  
  return 0;
END;
$$;


ALTER FUNCTION public.age_createorupdate_accountactivity(p_name character varying, p_logtime timestamp with time zone) OWNER TO spiritking;

--
-- Name: age_createorupdate_gfaccount(character varying, integer, character varying, timestamp without time zone); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION age_createorupdate_gfaccount(p_name character varying, p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE 
    v_curuid INT;
    v_curPasswd VARCHAR(32);
    v_curUpdateTime timestamp; 

BEGIN

    v_curuid := -1;

    SELECT INTO v_curuid, v_curPasswd, v_curUpdateTime idnum, pwd, updatetime FROM tb_user WHERE idnum = p_uid;

    IF (v_curuid = -1 OR v_curuid IS NULL) THEN
        -- create the user
        RETURN age_Create_GFAccount (p_name, p_uid, p_passwd);
    END IF;

    IF (v_curuid IS NOT NULL AND v_curPasswd <> p_passwd AND v_curUpdateTime < p_updateTime) THEN
        -- update the user
        RETURN age_Update_GFAccount (p_uid, p_passwd, p_updateTime);
    END IF;
    
    RETURN 0;
END;
$$;


ALTER FUNCTION public.age_createorupdate_gfaccount(p_name character varying, p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) OWNER TO postgres;

--
-- Name: age_update_gfaccount(integer, character varying, timestamp without time zone); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION age_update_gfaccount(p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) RETURNS integer
    LANGUAGE plpgsql
    AS $$
BEGIN      

    UPDATE tb_user SET pwd = TRIM(p_passwd), updatetime = p_updateTime WHERE idnum = p_uid AND updatetime < p_updateTime;
    RETURN 0;

END; 
$$;


ALTER FUNCTION public.age_update_gfaccount(p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) OWNER TO postgres;

--
-- Name: char_login(character varying, integer, character varying, character varying, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION char_login(character varying, integer, character varying, character varying, integer, character varying) RETURNS smallint
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
nWorldID ALIAS FOR $2;
pServerIP  ALIAS FOR $3;
pClientIP  ALIAS FOR $4;
nCharID ALIAS FOR $5;
pCharName  ALIAS FOR $6;

pMID char(32);
pExpiredate timestamp;
pAccountID varchar(32);
integer_var integer;



BEGIN
pAccountID = lower(ppAccountID);

DELETE FROM currentuser WHERE mid=pAccountID;

SELECT INTO pMID,pExpiredate mid,expiredate FROM tb_user WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN
INSERT INTO currentuser (mid,serverid,serverip,clientip,char_id,strcharid) VALUES (pAccountID,nWorldID,pServerIP,pClientIP,nCharID,pCharName);
   IF pExpiredate is null THEN
UPDATE tb_user SET  ExpireDate=now() Where mid=pAccountID;
   END IF;
UPDATE tb_user SET Status=1, lastlogindate=now() Where mid=pAccountID;
return 2;
END IF;
return -4;
END;



$_$;


ALTER FUNCTION public.char_login(character varying, integer, character varying, character varying, integer, character varying) OWNER TO postgres;

--
-- Name: char_logout(character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION char_logout(character varying, integer, integer) RETURNS smallint
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
nNodeID ALIAS FOR $2;
nLevel ALIAS FOR $3;

-- update billing data when logout
pAccountID varchar(32);

pTimeLogin timestamp;
pDuring integer;
pServerID int2;
pServerIP varchar(15);
pClientIP varchar(15);
pstrCharID varchar(32);
pCharID integer;


integer_var integer;
BEGIN
pAccountID = lower(ppAccountID);

SELECT INTO pTimeLogin,  pServerID, pServerIP,pClientIP,pstrCharID,pCharID  logindate, serverid, serverip,clientip,strcharid,char_id FROM currentuser WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN


pDuring = CAST(EXTRACT(EPOCH FROM now()) - EXTRACT(EPOCH FROM pTimeLogin) as int4) / 60;

UPDATE tb_user SET status=0,clientip=pClientIP WHERE mid=pAccountID;

--
INSERT INTO game_log (mid,strcharid,logindate,logoutdate,nduring,serverid,serverip,clientip,char_id,node_id,char_level)
VALUES (pAccountID,pstrCharID,pTimeLogin,now(),pDuring,pServerID,pServerIP,pClientIP,pCharID,nNodeID,nLevel);

--INSERT INTO game_log (mid,strcharid,logindate,logoutdate,nduring,serverid,serverip,clientip)
--VALUES (pAccountID,pstrCharID,pTimeLogin,now(),pDuring,pServerID,pServerIP,pClientIP);

DELETE FROM currentuser WHERE mid=pAccountID;

return 1;

END IF;

return 1;
END;

$_$;


ALTER FUNCTION public.char_logout(character varying, integer, integer) OWNER TO postgres;

--
-- Name: datediff(character varying, date, date); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION datediff(p_interval character varying, p_datefrom date, p_dateto date) RETURNS integer
    LANGUAGE plpgsql
    AS $$




BEGIN
if p_Interval = 'm' then
return ((date_part('y',p_DateTo) * 12) + date_part('month',p_DateTo))
- ((date_part('y',p_DateFrom) * 12) + date_part('month',p_DateFrom));
elseif p_Interval = 'y' then
return date_part('y',p_DateTo) - date_part('y',p_DateFrom);
else
raise exception 'Datediff: Interval not supported';
return 0;
end if;
END;
$$;


ALTER FUNCTION public.datediff(p_interval character varying, p_datefrom date, p_dateto date) OWNER TO spiritking;

--
-- Name: game_login(character varying, integer, character varying); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION game_login(character varying, integer, character varying) RETURNS smallint
    LANGUAGE plpgsql
    AS $_$
DECLARE
ppAccountID ALIAS FOR $1;
pServerID ALIAS FOR $2;
pServerIP ALIAS FOR $3;
pAccountID varchar(20);

pPValue int2;
pExpireDate timestamp;
pBillingRule int2;
pFree bit;
pDeduction int2;
pAddTime int2;
pTimeFormat char(2);
pMID char(20);
integer_var integer;
BEGIN
pAccountID = lower(ppAccountID);

DELETE FROM currentuser WHERE mid=pAccountID;

SELECT INTO pMID mid FROM tb_user WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN
INSERT INTO currentuser (mid,billingrule,serverid,serverip) VALUES (pAccountID,1,pServerID,pServerIP);
UPDATE tb_user SET Status=1, lastlogindate=now(), ExpireDate=now() Where mid=pAccountID;
-- Update user_aggregate - dsell@aeriagames.com
PERFORM age_createorupdate_accountactivity(pAccountID,CURRENT_TIMESTAMP);
return 1;   --ok
ELSE
return 4;
END IF;
END;
$_$;


ALTER FUNCTION public.game_login(character varying, integer, character varying) OWNER TO spiritking;

--
-- Name: get_point_info(character varying); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION get_point_info(character varying) RETURNS record
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
pAccountID varchar(20);
nPValues int;
nBonus int;
integer_var int;
nPoints record; --(nPValues,nBonus);
BEGIN
pAccountID = lower(ppAccountID);

SELECT INTO nPValues,nBonus pvalues,bonus FROM tb_user WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN
nPoints :=(nPValues,nBonus);
return nPoints;   --ok
ELSE
nPoints :=(0,0);
return nPoints; --false There is no Account.
END IF;
END;$_$;


ALTER FUNCTION public.get_point_info(character varying) OWNER TO spiritking;

--
-- Name: req_buy_item(character varying, character varying, integer, character varying, integer, character varying); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION req_buy_item(character varying, character varying, integer, character varying, integer, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
ppAccountID ALIAS FOR $1;
pServerIP ALIAS FOR $2;
pItemID ALIAS FOR $3;
pCharName ALIAS FOR $4;
pBuyPoint ALIAS FOR $5;
pClientIP ALIAS FOR $6;
pAccountID varchar(20);
pPValues int;
integer_var int;

BEGIN
pAccountID = lower(ppAccountID);

SELECT INTO pPValues pvalues FROM tb_user WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN
	IF (pPValues >= pBuyPoint) THEN
	INSERT INTO web_itemmall_log (straccountid,strcharid,serverno,itemid,buyprice,clientip) Values (pAccountID,pCharName,pServerIP,pItemID,pBuyPoint,pClientIP);
	INSERT INTO ppoint_trade_log  (straccountid,ppoint,"type") Values (pAccountID,-pBuyPoint,'Buy Item');
	update tb_user set pvalues = pvalues - pBuyPoint where mid=pAccountID;
	return pPvalues-pBuyPoint;   --ok
	ELSE
	return -103;
	END IF;
END IF;
return -101;
END;
$_$;


ALTER FUNCTION public.req_buy_item(character varying, character varying, integer, character varying, integer, character varying) OWNER TO spiritking;

--
-- Name: admin_pro_fid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE admin_pro_fid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.admin_pro_fid_seq OWNER TO postgres;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: admin_pro; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE admin_pro (
    fid integer DEFAULT nextval('admin_pro_fid_seq'::regclass) NOT NULL,
    parentid integer DEFAULT 1,
    program character(30),
    cname character(20),
    subid character(10),
    bywho character(20),
    regdate date DEFAULT now()
);


ALTER TABLE public.admin_pro OWNER TO spiritking;

--
-- Name: adminuser; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE adminuser (
    userid character varying(20) NOT NULL,
    adminname character varying(20),
    userpass character(20),
    gid character(255),
    regdate date DEFAULT now(),
    flag smallint DEFAULT 1
);


ALTER TABLE public.adminuser OWNER TO spiritking;

--
-- Name: age_user_aggregate; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE age_user_aggregate (
    uid integer NOT NULL,
    first_activity timestamp with time zone DEFAULT now() NOT NULL,
    last_activity timestamp with time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.age_user_aggregate OWNER TO spiritking;

--
-- Name: ccu_log; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE ccu_log (
    hostname character varying(16) NOT NULL,
    ccu integer,
    regdate timestamp with time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.ccu_log OWNER TO spiritking;

--
-- Name: currentuser; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE currentuser (
    mid character varying(20) NOT NULL,
    strcharid character varying(32),
    serverip character varying(15),
    clientip character varying(15),
    logindate timestamp with time zone DEFAULT now() NOT NULL,
    billingrule smallint,
    nduring integer,
    vps integer,
    serverid smallint,
    char_id integer
);


ALTER TABLE public.currentuser OWNER TO spiritking;

--
-- Name: distinctbid; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE distinctbid (
    logdate date DEFAULT now() NOT NULL,
    amount integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.distinctbid OWNER TO spiritking;

--
-- Name: game_log; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE game_log (
    id integer NOT NULL,
    mid character varying(20) NOT NULL,
    strcharid character varying(32),
    logindate timestamp with time zone DEFAULT now(),
    logoutdate timestamp with time zone DEFAULT now(),
    nduring integer,
    vps integer,
    serverid smallint,
    clientip character varying(15),
    serverip character varying(15),
    char_id integer,
    node_id integer,
    char_level integer
);


ALTER TABLE public.game_log OWNER TO spiritking;

--
-- Name: game_log_id_seq; Type: SEQUENCE; Schema: public; Owner: spiritking
--

CREATE SEQUENCE game_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.game_log_id_seq OWNER TO spiritking;

--
-- Name: game_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: spiritking
--

ALTER SEQUENCE game_log_id_seq OWNED BY game_log.id;


--
-- Name: gameserver; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE gameserver (
    gameserverip character varying(20) NOT NULL,
    description character varying(24),
    dbip character varying(20),
    dbid character varying(20),
    dbname character varying(20),
    note character varying(16),
    regdate date DEFAULT now(),
    flag integer
);


ALTER TABLE public.gameserver OWNER TO spiritking;

--
-- Name: gmip; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE gmip (
    ip character varying(15) NOT NULL,
    description character varying(50)
);


ALTER TABLE public.gmip OWNER TO spiritking;

--
-- Name: gmtool_log; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE gmtool_log (
    gameaccount character varying(32),
    gameserver character varying(32),
    itemid character varying(10),
    itemname character varying(50),
    itemcount integer,
    byuser character varying(20),
    regdate date DEFAULT now()
);


ALTER TABLE public.gmtool_log OWNER TO spiritking;

--
-- Name: log_eason_test; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE log_eason_test (
    "time" timestamp without time zone,
    ip text,
    account text,
    version text
);


ALTER TABLE public.log_eason_test OWNER TO spiritking;

--
-- Name: powerupitem; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE powerupitem (
    item_id integer NOT NULL,
    cnname text DEFAULT ''::text,
    itemname text DEFAULT ''::text
);


ALTER TABLE public.powerupitem OWNER TO postgres;

--
-- Name: ppoint_trade_log; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE ppoint_trade_log (
    idx integer NOT NULL,
    straccountid character varying(20) NOT NULL,
    ppoint integer,
    type character varying(50),
    buytime timestamp with time zone DEFAULT now() NOT NULL,
    orderid character varying(100)
);


ALTER TABLE public.ppoint_trade_log OWNER TO spiritking;

--
-- Name: ppoint_trade_log_idx_seq; Type: SEQUENCE; Schema: public; Owner: spiritking
--

CREATE SEQUENCE ppoint_trade_log_idx_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ppoint_trade_log_idx_seq OWNER TO spiritking;

--
-- Name: ppoint_trade_log_idx_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: spiritking
--

ALTER SEQUENCE ppoint_trade_log_idx_seq OWNED BY ppoint_trade_log.idx;


--
-- Name: pus_avg; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE pus_avg (
    buydate date DEFAULT now() NOT NULL,
    buyprice integer DEFAULT 0,
    buynum integer DEFAULT 0,
    buyavg integer DEFAULT 0
);


ALTER TABLE public.pus_avg OWNER TO spiritking;

--
-- Name: tb_user; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE tb_user (
    mid character varying(20) NOT NULL,
    password character varying(20),
    pwd character varying(32) NOT NULL,
    idnum integer NOT NULL,
    byauthority smallint DEFAULT 0,
    pvalues integer DEFAULT 0,
    expiredate timestamp without time zone DEFAULT now(),
    billingrule smallint DEFAULT 0,
    status smallint DEFAULT 0,
    regdate timestamp with time zone DEFAULT now(),
    lastlogindate timestamp with time zone,
    memberid character varying(20),
    clientip character varying(20),
    updatetime timestamp without time zone DEFAULT now(),
    bonus integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.tb_user OWNER TO spiritking;

--
-- Name: tb_user_idnum_seq; Type: SEQUENCE; Schema: public; Owner: spiritking
--

CREATE SEQUENCE tb_user_idnum_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tb_user_idnum_seq OWNER TO spiritking;

--
-- Name: tb_user_idnum_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: spiritking
--

ALTER SEQUENCE tb_user_idnum_seq OWNED BY tb_user.idnum;


--
-- Name: web_itemmall_log; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE web_itemmall_log (
    idx integer NOT NULL,
    straccountid character varying(32) NOT NULL,
    strcharid character varying(32),
    serverno character(16) NOT NULL,
    itemid integer NOT NULL,
    itemcount smallint DEFAULT 1,
    buytime timestamp with time zone DEFAULT now() NOT NULL,
    buyprice integer,
    clientip character(20)
);


ALTER TABLE public.web_itemmall_log OWNER TO spiritking;

--
-- Name: web_itemmall_log_idx_seq; Type: SEQUENCE; Schema: public; Owner: spiritking
--

CREATE SEQUENCE web_itemmall_log_idx_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.web_itemmall_log_idx_seq OWNER TO spiritking;

--
-- Name: web_itemmall_log_idx_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: spiritking
--

ALTER SEQUENCE web_itemmall_log_idx_seq OWNED BY web_itemmall_log.idx;


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: spiritking
--

ALTER TABLE game_log ALTER COLUMN id SET DEFAULT nextval('game_log_id_seq'::regclass);


--
-- Name: idx; Type: DEFAULT; Schema: public; Owner: spiritking
--

ALTER TABLE ppoint_trade_log ALTER COLUMN idx SET DEFAULT nextval('ppoint_trade_log_idx_seq'::regclass);


--
-- Name: idnum; Type: DEFAULT; Schema: public; Owner: spiritking
--

ALTER TABLE tb_user ALTER COLUMN idnum SET DEFAULT nextval('tb_user_idnum_seq'::regclass);


--
-- Name: idx; Type: DEFAULT; Schema: public; Owner: spiritking
--

ALTER TABLE web_itemmall_log ALTER COLUMN idx SET DEFAULT nextval('web_itemmall_log_idx_seq'::regclass);


--
-- Name: admin_pro_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY admin_pro
    ADD CONSTRAINT admin_pro_pkey PRIMARY KEY (fid);


--
-- Name: adminuser_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY adminuser
    ADD CONSTRAINT adminuser_pkey PRIMARY KEY (userid);


--
-- Name: ccu_log_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY ccu_log
    ADD CONSTRAINT ccu_log_pkey PRIMARY KEY (hostname, regdate);


--
-- Name: ccu_mid_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY currentuser
    ADD CONSTRAINT ccu_mid_pkey PRIMARY KEY (mid);


--
-- Name: distinctbid_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY distinctbid
    ADD CONSTRAINT distinctbid_pkey PRIMARY KEY (logdate);


--
-- Name: gamelog_id_mid; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY game_log
    ADD CONSTRAINT gamelog_id_mid PRIMARY KEY (id, mid);


--
-- Name: gameserver_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY gameserver
    ADD CONSTRAINT gameserver_pkey PRIMARY KEY (gameserverip);


--
-- Name: pk_gmip; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY gmip
    ADD CONSTRAINT pk_gmip PRIMARY KEY (ip);


--
-- Name: pk_uid; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY age_user_aggregate
    ADD CONSTRAINT pk_uid PRIMARY KEY (uid);


--
-- Name: powerupitem_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY powerupitem
    ADD CONSTRAINT powerupitem_pkey PRIMARY KEY (item_id);


--
-- Name: ppoint_trade_log_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY ppoint_trade_log
    ADD CONSTRAINT ppoint_trade_log_pkey PRIMARY KEY (idx, straccountid, buytime);


--
-- Name: pus_avg_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY pus_avg
    ADD CONSTRAINT pus_avg_pkey PRIMARY KEY (buydate);


--
-- Name: tb_user_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY tb_user
    ADD CONSTRAINT tb_user_pkey PRIMARY KEY (mid);


--
-- Name: web_itemmall_log_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY web_itemmall_log
    ADD CONSTRAINT web_itemmall_log_pkey PRIMARY KEY (idx, straccountid, itemid, buytime);


--
-- Name: game_log_index; Type: INDEX; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE INDEX game_log_index ON game_log USING btree (logindate, logoutdate, serverid, clientip);


--
-- Name: index_account; Type: INDEX; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE INDEX index_account ON log_eason_test USING btree (account);


--
-- Name: index_gameserver; Type: INDEX; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE INDEX index_gameserver ON gameserver USING btree (gameserverip, note);


--
-- Name: index_tb_user_idnum; Type: INDEX; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE INDEX index_tb_user_idnum ON tb_user USING btree (idnum);


--
-- Name: index_time; Type: INDEX; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE INDEX index_time ON log_eason_test USING btree ("time");


--
-- Name: ix_last_activity; Type: INDEX; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE INDEX ix_last_activity ON age_user_aggregate USING btree (last_activity);


--
-- Name: tb_user_index; Type: INDEX; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE INDEX tb_user_index ON tb_user USING btree (regdate, lastlogindate, expiredate);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: age_create_gfaccount(character varying, integer, character varying); Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON FUNCTION age_create_gfaccount(p_name character varying, p_uid integer, p_passwd character varying) FROM PUBLIC;
REVOKE ALL ON FUNCTION age_create_gfaccount(p_name character varying, p_uid integer, p_passwd character varying) FROM postgres;
GRANT ALL ON FUNCTION age_create_gfaccount(p_name character varying, p_uid integer, p_passwd character varying) TO postgres;
GRANT ALL ON FUNCTION age_create_gfaccount(p_name character varying, p_uid integer, p_passwd character varying) TO PUBLIC;


--
-- Name: age_createorupdate_gfaccount(character varying, integer, character varying, timestamp without time zone); Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON FUNCTION age_createorupdate_gfaccount(p_name character varying, p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) FROM PUBLIC;
REVOKE ALL ON FUNCTION age_createorupdate_gfaccount(p_name character varying, p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) FROM postgres;
GRANT ALL ON FUNCTION age_createorupdate_gfaccount(p_name character varying, p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) TO postgres;
GRANT ALL ON FUNCTION age_createorupdate_gfaccount(p_name character varying, p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) TO PUBLIC;


--
-- Name: age_update_gfaccount(integer, character varying, timestamp without time zone); Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON FUNCTION age_update_gfaccount(p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) FROM PUBLIC;
REVOKE ALL ON FUNCTION age_update_gfaccount(p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) FROM postgres;
GRANT ALL ON FUNCTION age_update_gfaccount(p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) TO postgres;
GRANT ALL ON FUNCTION age_update_gfaccount(p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) TO PUBLIC;


--
-- Name: admin_pro; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE admin_pro FROM PUBLIC;
REVOKE ALL ON TABLE admin_pro FROM spiritking;
GRANT ALL ON TABLE admin_pro TO spiritking;


--
-- Name: adminuser; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE adminuser FROM PUBLIC;
REVOKE ALL ON TABLE adminuser FROM spiritking;
GRANT ALL ON TABLE adminuser TO spiritking;


--
-- Name: age_user_aggregate; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE age_user_aggregate FROM PUBLIC;
REVOKE ALL ON TABLE age_user_aggregate FROM spiritking;
GRANT ALL ON TABLE age_user_aggregate TO spiritking;


--
-- Name: ccu_log; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE ccu_log FROM PUBLIC;
REVOKE ALL ON TABLE ccu_log FROM spiritking;
GRANT ALL ON TABLE ccu_log TO spiritking;


--
-- Name: currentuser; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE currentuser FROM PUBLIC;
REVOKE ALL ON TABLE currentuser FROM spiritking;
GRANT ALL ON TABLE currentuser TO spiritking;


--
-- Name: distinctbid; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE distinctbid FROM PUBLIC;
REVOKE ALL ON TABLE distinctbid FROM spiritking;
GRANT ALL ON TABLE distinctbid TO spiritking;


--
-- Name: game_log; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE game_log FROM PUBLIC;
REVOKE ALL ON TABLE game_log FROM spiritking;
GRANT ALL ON TABLE game_log TO spiritking;


--
-- Name: game_log_id_seq; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON SEQUENCE game_log_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE game_log_id_seq FROM spiritking;
GRANT ALL ON SEQUENCE game_log_id_seq TO spiritking;


--
-- Name: gameserver; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE gameserver FROM PUBLIC;
REVOKE ALL ON TABLE gameserver FROM spiritking;
GRANT ALL ON TABLE gameserver TO spiritking;


--
-- Name: gmip; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE gmip FROM PUBLIC;
REVOKE ALL ON TABLE gmip FROM spiritking;
GRANT ALL ON TABLE gmip TO spiritking;


--
-- Name: gmtool_log; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE gmtool_log FROM PUBLIC;
REVOKE ALL ON TABLE gmtool_log FROM spiritking;
GRANT ALL ON TABLE gmtool_log TO spiritking;


--
-- Name: powerupitem; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE powerupitem FROM PUBLIC;
REVOKE ALL ON TABLE powerupitem FROM postgres;
GRANT ALL ON TABLE powerupitem TO postgres;
GRANT ALL ON TABLE powerupitem TO spiritking;


--
-- Name: ppoint_trade_log; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE ppoint_trade_log FROM PUBLIC;
REVOKE ALL ON TABLE ppoint_trade_log FROM spiritking;
GRANT ALL ON TABLE ppoint_trade_log TO spiritking;


--
-- Name: ppoint_trade_log_idx_seq; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON SEQUENCE ppoint_trade_log_idx_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ppoint_trade_log_idx_seq FROM spiritking;
GRANT ALL ON SEQUENCE ppoint_trade_log_idx_seq TO spiritking;


--
-- Name: pus_avg; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE pus_avg FROM PUBLIC;
REVOKE ALL ON TABLE pus_avg FROM spiritking;
GRANT ALL ON TABLE pus_avg TO spiritking;


--
-- Name: tb_user; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE tb_user FROM PUBLIC;
REVOKE ALL ON TABLE tb_user FROM spiritking;
GRANT ALL ON TABLE tb_user TO spiritking;
GRANT ALL ON TABLE tb_user TO usersync;


--
-- Name: tb_user_idnum_seq; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON SEQUENCE tb_user_idnum_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tb_user_idnum_seq FROM spiritking;
GRANT ALL ON SEQUENCE tb_user_idnum_seq TO spiritking;


--
-- Name: web_itemmall_log; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE web_itemmall_log FROM PUBLIC;
REVOKE ALL ON TABLE web_itemmall_log FROM spiritking;
GRANT ALL ON TABLE web_itemmall_log TO spiritking;


--
-- Name: web_itemmall_log_idx_seq; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON SEQUENCE web_itemmall_log_idx_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE web_itemmall_log_idx_seq FROM spiritking;
GRANT ALL ON SEQUENCE web_itemmall_log_idx_seq TO spiritking;


--
-- PostgreSQL database dump complete
--

