--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'SQL_ASCII';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: postgres
--

CREATE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO postgres;

SET search_path = public, pg_catalog;

--
-- Name: dblink_pkey_results; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE dblink_pkey_results AS (
	"position" integer,
	colname text
);


ALTER TYPE public.dblink_pkey_results OWNER TO postgres;

--
-- Name: res_set; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE res_set AS (
	pidnum integer,
	nret smallint
);


ALTER TYPE public.res_set OWNER TO postgres;

--
-- Name: account_login(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION account_login(character varying, character varying, character varying) RETURNS res_set
    LANGUAGE plpgsql
    AS $_$declare
ppAccountID ALIAS FOR $1;
pPassword ALIAS FOR $2;
pClientIP ALIAS FOR $3;
pAccountID varchar(20);
pcount int;
pPwd char(32) default null;
pBAuthority int2 default 0;
pGMIP varchar(15) default null;

res res_set;

BEGIN
pAccountID = lower(ppAccountID);
res.nRet=-1;

SELECT INTO pcount count(mid) FROM "tb_user" WHERE mid=pAccountID;
IF pcount =0 THEN --This Account is not exist
res.pIdNum= -1;
res.nRet = 2;
RETURN res;
END IF;

SELECT INTO pPwd,pBAuthority,res.pIdNum pwd,byAuthority,idnum FROM "tb_user" WHERE mid=pAccountID;

IF pPwd IS null THEN
res.nRet = 2;
RETURN res;
ELSEIF pPwd <> pPassword THEN
res.nRet = 3;
RETURN res;
END IF;

IF pBAuthority = 255 THEN   --This Account was locked
res.nRet = 5;
RETURN res;
END IF;

--IF pBAuthority = 1 THEN   --gmAccount  Check ip (0-->User, 1-->GM, 255-->Locked)
--SELECT INTO pGMIP ip FROM gmip WHERE ip=pClientIP;
--IF pGMIP IS NULL THEN
--res.nRet = 4;
--RETURN res;
--END IF;
--END IF;

res.nRet = 1;
RETURN res;
END;
$_$;


ALTER FUNCTION public.account_login(character varying, character varying, character varying) OWNER TO spiritking;

--
-- Name: account_logoutx(character varying, character varying, character varying, character varying, integer); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION account_logoutx(character varying, character varying, character varying, character varying, integer) RETURNS smallint
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
pCharID_var ALIAS FOR $2;
pServerIP_var ALIAS FOR $3;
pClientIP_var ALIAS FOR $4;
pServerID_var ALIAS FOR $5;
pAccountID varchar(21);

-- update billing data when logout
pServerID int2;
pCharID integer;
pServerIP varchar(15);
pClientIP varchar(15);
pstrCharID varchar(32);
pPValue int2;
pExpireDate timestamp;
pBillingRule int2;
pFree bit;
pDeduction int2;
pAddTime int2;
pTimeFormat char(2);
pMID char(20);
pVPS int2;
pUnits real;

pTotalVPS int4 default 0;
pTimeLogin timestamp;
pDuring int4;
pTimeLogout timestamp;
pBrule int2;
pOriServerID int2;
pOriServerIP varchar(15);


integer_var integer;

BEGIN
pAccountID = ppAccountID;  
SELECT INTO pMID mid FROM tb_user where mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN

SELECT INTO pTimeLogin,  pServerID, pServerIP,pClientIP,pstrCharID,pCharID  logindate, serverid, serverip,clientip,strcharid,char_id FROM currentuser WHERE mid=pAccountID;


pDuring = CAST(EXTRACT(EPOCH FROM now()) - EXTRACT(EPOCH FROM pTimeLogin) as int4) / 60;

UPDATE tb_user SET status=0,clientip=pClientIP WHERE mid=pAccountID;

--


INSERT INTO game_log (mid,strcharid,logindate,logoutdate,nduring,serverid,serverip,clientip,char_id)
VALUES (pAccountID,pstrCharID,pTimeLogin,now(),pDuring,pServerID,pServerIP,pClientIP,pCharID);

DELETE FROM currentuser WHERE mid=pAccountID;

-- Update user_aggregate - dsell@aeriagames.com
--PERFORM age_createorupdate_accountactivity(pAccountID,CURRENT_TIMESTAMP);

return 1;
END IF;

return 1;
END;
$_$;


ALTER FUNCTION public.account_logoutx(character varying, character varying, character varying, character varying, integer) OWNER TO spiritking;

--
-- Name: age_create_gfaccount(character varying, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION age_create_gfaccount(p_name character varying, p_uid integer, p_passwd character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
BEGIN                                      

    INSERT INTO tb_user (mid, pwd, idnum, byauthority, regdate) VALUES
(lower(p_name), p_passwd, p_uid, 0, now());
    RETURN 0;

END; 
$$;


ALTER FUNCTION public.age_create_gfaccount(p_name character varying, p_uid integer, p_passwd character varying) OWNER TO postgres;

--
-- Name: age_createorupdate_accountactivity(character varying, timestamp with time zone); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION age_createorupdate_accountactivity(p_name character varying, p_logtime timestamp with time zone) RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE 
  v_uid INT;
  v_count INT;
BEGIN
  SELECT INTO v_uid idnum FROM tb_user WHERE mid = p_name;
  
  IF NOT FOUND THEN
    return 0;
  END IF;
  
  SELECT INTO v_count COUNT(*) FROM age_user_aggregate WHERE uid = v_uid;
  IF v_count = 0 THEN
    INSERT INTO age_user_aggregate (uid, first_activity, last_activity) VALUES (v_uid, p_logtime, p_logtime);
  ELSE
    UPDATE age_user_aggregate SET last_activity = p_logtime WHERE uid = v_uid AND p_logtime > last_activity;
  END IF;
  
  return 0;
END;
$$;


ALTER FUNCTION public.age_createorupdate_accountactivity(p_name character varying, p_logtime timestamp with time zone) OWNER TO spiritking;

--
-- Name: age_createorupdate_gfaccount(character varying, integer, character varying, timestamp without time zone); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION age_createorupdate_gfaccount(p_name character varying, p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE 
    v_curuid INT;
    v_curPasswd VARCHAR(32);
    v_curUpdateTime timestamp; 

BEGIN

    v_curuid := -1;

    SELECT INTO v_curuid, v_curPasswd, v_curUpdateTime idnum, pwd, updatetime
FROM tb_user WHERE idnum = p_uid;

    IF (v_curuid = -1 OR v_curuid IS NULL) THEN
        -- create the user
        RETURN age_Create_GFAccount (p_name, p_uid, p_passwd);
    END IF;

    IF (v_curuid IS NOT NULL AND v_curPasswd <> p_passwd AND v_curUpdateTime <
p_updateTime) THEN
        -- update the user
        RETURN age_Update_GFAccount (p_uid, p_passwd, p_updateTime);
    END IF;
    
    RETURN 0;
END;
$$;


ALTER FUNCTION public.age_createorupdate_gfaccount(p_name character varying, p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) OWNER TO postgres;

--
-- Name: age_update_gfaccount(integer, character varying, timestamp without time zone); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION age_update_gfaccount(p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) RETURNS integer
    LANGUAGE plpgsql
    AS $$
BEGIN      

    UPDATE tb_user SET pwd = TRIM(p_passwd), updatetime = p_updateTime WHERE
idnum = p_uid AND updatetime < p_updateTime;
    RETURN 0;

END; 
$$;


ALTER FUNCTION public.age_update_gfaccount(p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) OWNER TO postgres;

--
-- Name: char_login(character varying, integer, character varying, character varying, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION char_login(character varying, integer, character varying, character varying, integer, character varying) RETURNS smallint
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
nWorldID ALIAS FOR $2;
pServerIP  ALIAS FOR $3;
pClientIP  ALIAS FOR $4;
nCharID ALIAS FOR $5;
pCharName  ALIAS FOR $6;
v_uid INT;
pMID char(32);
pfirstlogindate timestamp;
pAccountID varchar(32);
integer_var integer;

BEGIN
--pAccountID = lower(ppAccountID);
pAccountID = ppAccountID;
DELETE FROM currentuser WHERE mid=pAccountID;
INSERT INTO currentuser (mid,serverid,serverip,clientip,char_id,strcharid) VALUES (pAccountID,nWorldID,pServerIP,pClientIP,nCharID,pCharName);
SELECT INTO pMID,pfirstlogindate mid,firstlogindate FROM tb_user WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN
        IF pfirstlogindate is null THEN
                UPDATE tb_user SET firstlogindate=now() Where mid=pAccountID;
        END IF;

        UPDATE tb_user SET Status=1, lastlogindate=now() Where mid=pAccountID;
        return 0;
ELSE
        SELECT INTO v_uid id FROM id_actname WHERE username = pAccountID;
        INSERT INTO tb_user (mid, idnum,firstlogindate, lastlogindate,clientip) VALUES (pAccountID,v_uid,now(),now(),pClientIP);
        return 0;
END IF;
END;

$_$;


ALTER FUNCTION public.char_login(character varying, integer, character varying, character varying, integer, character varying) OWNER TO postgres;

--
-- Name: char_logout(character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION char_logout(character varying, integer, integer) RETURNS smallint
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
nNodeID ALIAS FOR $2;
nLevel ALIAS FOR $3;

-- update billing data when logout
pAccountID varchar(32);

pTimeLogin timestamp;
pDuring integer;
pServerID int2;
pServerIP varchar(15);
pClientIP varchar(15);
pstrCharID varchar(32);
pCharID integer;


integer_var integer;
BEGIN
pAccountID = ppAccountID;
SELECT INTO pTimeLogin,  pServerID, pServerIP,pClientIP,pstrCharID,pCharID  logindate, serverid, serverip,clientip,strcharid,char_id FROM currentuser WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;
RAISE NOTICE 'Variable an_integer was changed. %  and  % and %' ,pAccountID,pServerID, pClientIP;
IF(integer_var > 0) THEN


pDuring = CAST(EXTRACT(EPOCH FROM now()) - EXTRACT(EPOCH FROM pTimeLogin) as int4) / 60;

UPDATE tb_user SET status=0,clientip=pClientIP WHERE mid=pAccountID;

-- 
INSERT INTO game_log (mid,strcharid,logindate,logoutdate,nduring,serverid,serverip,clientip,char_id,node_id,char_level)
VALUES (pAccountID,pstrCharID,pTimeLogin,now(),pDuring,pServerID,pServerIP,pClientIP,pCharID,nNodeID,nLevel);

--INSERT INTO game_log (mid,strcharid,logindate,logoutdate,nduring,serverid,serverip,clientip)
--VALUES (pAccountID,pstrCharID,pTimeLogin,now(),pDuring,pServerID,pServerIP,pClientIP);

DELETE FROM currentuser WHERE mid=pAccountID;

return 1;

END IF;

return 1;
END;

$_$;


ALTER FUNCTION public.char_logout(character varying, integer, integer) OWNER TO spiritking;

--
-- Name: datediff(character varying, date, date); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION datediff(p_interval character varying, p_datefrom date, p_dateto date) RETURNS integer
    LANGUAGE plpgsql
    AS $$




BEGIN
if p_Interval = 'm' then
return ((date_part('y',p_DateTo) * 12) + date_part('month',p_DateTo))
- ((date_part('y',p_DateFrom) * 12) + date_part('month',p_DateFrom));
elseif p_Interval = 'y' then
return date_part('y',p_DateTo) - date_part('y',p_DateFrom);
else
raise exception 'Datediff: Interval not supported';
return 0;
end if;
END;
$$;


ALTER FUNCTION public.datediff(p_interval character varying, p_datefrom date, p_dateto date) OWNER TO spiritking;

--
-- Name: dblink(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink(text, text) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_record';


ALTER FUNCTION public.dblink(text, text) OWNER TO postgres;

--
-- Name: dblink(text, text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink(text, text, boolean) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_record';


ALTER FUNCTION public.dblink(text, text, boolean) OWNER TO postgres;

--
-- Name: dblink(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink(text) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_record';


ALTER FUNCTION public.dblink(text) OWNER TO postgres;

--
-- Name: dblink(text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink(text, boolean) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_record';


ALTER FUNCTION public.dblink(text, boolean) OWNER TO postgres;

--
-- Name: dblink_build_sql_delete(text, int2vector, integer, text[]); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_build_sql_delete(text, int2vector, integer, text[]) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_build_sql_delete';


ALTER FUNCTION public.dblink_build_sql_delete(text, int2vector, integer, text[]) OWNER TO postgres;

--
-- Name: dblink_build_sql_insert(text, int2vector, integer, text[], text[]); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_build_sql_insert(text, int2vector, integer, text[], text[]) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_build_sql_insert';


ALTER FUNCTION public.dblink_build_sql_insert(text, int2vector, integer, text[], text[]) OWNER TO postgres;

--
-- Name: dblink_build_sql_update(text, int2vector, integer, text[], text[]); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_build_sql_update(text, int2vector, integer, text[], text[]) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_build_sql_update';


ALTER FUNCTION public.dblink_build_sql_update(text, int2vector, integer, text[], text[]) OWNER TO postgres;

--
-- Name: dblink_cancel_query(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_cancel_query(text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_cancel_query';


ALTER FUNCTION public.dblink_cancel_query(text) OWNER TO postgres;

--
-- Name: dblink_close(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_close(text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_close';


ALTER FUNCTION public.dblink_close(text) OWNER TO postgres;

--
-- Name: dblink_close(text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_close(text, boolean) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_close';


ALTER FUNCTION public.dblink_close(text, boolean) OWNER TO postgres;

--
-- Name: dblink_close(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_close(text, text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_close';


ALTER FUNCTION public.dblink_close(text, text) OWNER TO postgres;

--
-- Name: dblink_close(text, text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_close(text, text, boolean) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_close';


ALTER FUNCTION public.dblink_close(text, text, boolean) OWNER TO postgres;

--
-- Name: dblink_connect(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_connect(text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_connect';


ALTER FUNCTION public.dblink_connect(text) OWNER TO postgres;

--
-- Name: dblink_connect(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_connect(text, text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_connect';


ALTER FUNCTION public.dblink_connect(text, text) OWNER TO postgres;

--
-- Name: dblink_connect_u(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_connect_u(text) RETURNS text
    LANGUAGE c STRICT SECURITY DEFINER
    AS '$libdir/dblink', 'dblink_connect';


ALTER FUNCTION public.dblink_connect_u(text) OWNER TO postgres;

--
-- Name: dblink_connect_u(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_connect_u(text, text) RETURNS text
    LANGUAGE c STRICT SECURITY DEFINER
    AS '$libdir/dblink', 'dblink_connect';


ALTER FUNCTION public.dblink_connect_u(text, text) OWNER TO postgres;

--
-- Name: dblink_current_query(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_current_query() RETURNS text
    LANGUAGE c
    AS '$libdir/dblink', 'dblink_current_query';


ALTER FUNCTION public.dblink_current_query() OWNER TO postgres;

--
-- Name: dblink_disconnect(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_disconnect() RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_disconnect';


ALTER FUNCTION public.dblink_disconnect() OWNER TO postgres;

--
-- Name: dblink_disconnect(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_disconnect(text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_disconnect';


ALTER FUNCTION public.dblink_disconnect(text) OWNER TO postgres;

--
-- Name: dblink_error_message(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_error_message(text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_error_message';


ALTER FUNCTION public.dblink_error_message(text) OWNER TO postgres;

--
-- Name: dblink_exec(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_exec(text, text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_exec';


ALTER FUNCTION public.dblink_exec(text, text) OWNER TO postgres;

--
-- Name: dblink_exec(text, text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_exec(text, text, boolean) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_exec';


ALTER FUNCTION public.dblink_exec(text, text, boolean) OWNER TO postgres;

--
-- Name: dblink_exec(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_exec(text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_exec';


ALTER FUNCTION public.dblink_exec(text) OWNER TO postgres;

--
-- Name: dblink_exec(text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_exec(text, boolean) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_exec';


ALTER FUNCTION public.dblink_exec(text, boolean) OWNER TO postgres;

--
-- Name: dblink_fetch(text, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_fetch(text, integer) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_fetch';


ALTER FUNCTION public.dblink_fetch(text, integer) OWNER TO postgres;

--
-- Name: dblink_fetch(text, integer, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_fetch(text, integer, boolean) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_fetch';


ALTER FUNCTION public.dblink_fetch(text, integer, boolean) OWNER TO postgres;

--
-- Name: dblink_fetch(text, text, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_fetch(text, text, integer) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_fetch';


ALTER FUNCTION public.dblink_fetch(text, text, integer) OWNER TO postgres;

--
-- Name: dblink_fetch(text, text, integer, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_fetch(text, text, integer, boolean) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_fetch';


ALTER FUNCTION public.dblink_fetch(text, text, integer, boolean) OWNER TO postgres;

--
-- Name: dblink_get_connections(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_get_connections() RETURNS text[]
    LANGUAGE c
    AS '$libdir/dblink', 'dblink_get_connections';


ALTER FUNCTION public.dblink_get_connections() OWNER TO postgres;

--
-- Name: dblink_get_pkey(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_get_pkey(text) RETURNS SETOF dblink_pkey_results
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_get_pkey';


ALTER FUNCTION public.dblink_get_pkey(text) OWNER TO postgres;

--
-- Name: dblink_get_result(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_get_result(text) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_get_result';


ALTER FUNCTION public.dblink_get_result(text) OWNER TO postgres;

--
-- Name: dblink_get_result(text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_get_result(text, boolean) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_get_result';


ALTER FUNCTION public.dblink_get_result(text, boolean) OWNER TO postgres;

--
-- Name: dblink_is_busy(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_is_busy(text) RETURNS integer
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_is_busy';


ALTER FUNCTION public.dblink_is_busy(text) OWNER TO postgres;

--
-- Name: dblink_open(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_open(text, text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_open';


ALTER FUNCTION public.dblink_open(text, text) OWNER TO postgres;

--
-- Name: dblink_open(text, text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_open(text, text, boolean) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_open';


ALTER FUNCTION public.dblink_open(text, text, boolean) OWNER TO postgres;

--
-- Name: dblink_open(text, text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_open(text, text, text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_open';


ALTER FUNCTION public.dblink_open(text, text, text) OWNER TO postgres;

--
-- Name: dblink_open(text, text, text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_open(text, text, text, boolean) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_open';


ALTER FUNCTION public.dblink_open(text, text, text, boolean) OWNER TO postgres;

--
-- Name: dblink_send_query(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_send_query(text, text) RETURNS integer
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_send_query';


ALTER FUNCTION public.dblink_send_query(text, text) OWNER TO postgres;

--
-- Name: game_login(character varying, integer, character varying); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION game_login(character varying, integer, character varying) RETURNS smallint
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
pServerID ALIAS FOR $2;
pServerIP ALIAS FOR $3;
pAccountID varchar(20);

pPValue int2;
pExpireDate timestamp;
pBillingRule int2;
pFree bit;
pDeduction int2;
pAddTime int2;
pTimeFormat char(2);
pMID char(20);
integer_var integer;
BEGIN
pAccountID = lower(ppAccountID);

DELETE FROM currentuser WHERE mid=pAccountID;

SELECT INTO pMID,pExpireDate mid,expiredate FROM tb_user WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN
INSERT INTO currentuser (mid,billingrule,serverid,serverip) VALUES (pAccountID,1,pServerID,pServerIP);
UPDATE tb_user SET Status=1, lastlogindate=now() Where mid=pAccountID;
   IF pExpireDate is null then 
          UPDATE tb_user SET expiredate=now() Where mid=pAccountID;
   END IF; 
-- Update user_aggregate - dsell@aeriagames.com
PERFORM age_createorupdate_accountactivity(pAccountID,CURRENT_TIMESTAMP);
return 1;   --ok
ELSE
return 4;
END IF;
END;
$_$;


ALTER FUNCTION public.game_login(character varying, integer, character varying) OWNER TO spiritking;

--
-- Name: get_point_info(character varying); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION get_point_info(character varying) RETURNS record
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
pAccountID varchar(20);
nPValues int;
nBonus int;
integer_var int;
nPoints record; --(nPValues,nBonus);
BEGIN
pAccountID = lower(ppAccountID);

SELECT INTO nPValues,nBonus pvalues,bonus FROM tb_user WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN
nPoints :=(nPValues,nBonus);
return nPoints;   --ok
ELSE
nPoints :=(0,0);
return nPoints; --false There is no Account.
END IF;
END;$_$;


ALTER FUNCTION public.get_point_info(character varying) OWNER TO spiritking;

--
-- Name: req_buy_item(character varying, character varying, integer, character varying, integer, character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: spiritking
--

CREATE FUNCTION req_buy_item(character varying, character varying, integer, character varying, integer, character varying, integer, integer) RETURNS record
    LANGUAGE plpgsql
    AS $_$DECLARE
ppAccountID ALIAS FOR $1;
pServerIP ALIAS FOR $2;
pItemID ALIAS FOR $3;
pCharName ALIAS FOR $4;
pBuyPoint ALIAS FOR $5;
pClientIP ALIAS FOR $6;
pBuyType ALIAS FOR $7;
pAmount ALIAS FOR $8;
pAccountID varchar(20);
integer_var int;
BonusRate smallint;
nPValues int;
nBonus int;
nPoints record; --(nPValues,nBonus); input values only use two type.

BEGIN
pAccountID = lower(ppAccountID);
BonusRate=5;
SELECT INTO nPValues,nBonus pvalues,bonus FROM tb_user WHERE mid=pAccountID;
GET DIAGNOSTICS integer_var = ROW_COUNT;

IF(integer_var > 0) THEN
--Type 1 model
IF (pBuyType=1 and nPValues >= pBuyPoint) THEN
nBonus=nBonus+floor(pBuyPoint/BonusRate);
nPValues=nPValues-pBuyPoint;
INSERT INTO web_itemmall_log (straccountid,strcharid,serverno,itemid,itemcount,buyprice,clientip,buytype,bonus,buytotal) Values (pAccountID,pCharName,pServerIP,pItemID,pAmount,pBuyPoint,pClientIP,pBuyType,floor(pBuyPoint/BonusRate),pBuyPoint);

update tb_user set pvalues = nPValues, bonus= nBonus where mid=pAccountID;
nPoints :=(nPvalues,nBonus);
return nPoints;   --Type 1 ok
--Type 2 model
ElSEIF (pBuyType=2 and nBonus >= pBuyPoint) THEN
nBonus=nBonus-(pBuyPoint);
INSERT INTO web_itemmall_log (straccountid,strcharid,serverno,itemid,itemcount,buyprice,clientip,buytype,bonus,buytotal) Values (pAccountID,pCharName,pServerIP,pItemID,pAmount,pBuyPoint,pClientIP,pBuyType,0,pBuyPoint);

update tb_user set bonus = nBonus where mid=pAccountID;
nPoints :=(nPvalues,nBonus);
return nPoints;    --Type 2 ok
ELSE
nPValues= -103;
nBonus= -103;
nPoints :=(nPvalues,nBonus);
return nPoints; 
END IF;
END IF;
nPValues= -101;
nBonus= -101;
nPoints :=(nPvalues,nBonus);
return nPoints; 
END;

$_$;


ALTER FUNCTION public.req_buy_item(character varying, character varying, integer, character varying, integer, character varying, integer, integer) OWNER TO spiritking;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: age_user_aggregate; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE age_user_aggregate (
    uid integer NOT NULL,
    first_activity timestamp with time zone DEFAULT now() NOT NULL,
    last_activity timestamp with time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.age_user_aggregate OWNER TO spiritking;

--
-- Name: currentuser; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE currentuser (
    mid character varying(50) NOT NULL,
    strcharid character varying(32),
    serverip character varying(15),
    clientip character varying(15),
    logindate timestamp with time zone DEFAULT now() NOT NULL,
    billingrule smallint,
    nduring integer,
    vps integer,
    serverid smallint,
    char_id integer
);


ALTER TABLE public.currentuser OWNER TO spiritking;

--
-- Name: game_log; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE game_log (
    id integer NOT NULL,
    mid character varying(50) NOT NULL,
    strcharid character varying(32),
    logindate timestamp with time zone DEFAULT now(),
    logoutdate timestamp with time zone DEFAULT now(),
    nduring integer,
    vps integer,
    serverid smallint,
    clientip character varying(15),
    serverip character varying(15),
    char_id integer,
    node_id integer,
    char_level integer
);


ALTER TABLE public.game_log OWNER TO spiritking;

--
-- Name: game_log_id_seq; Type: SEQUENCE; Schema: public; Owner: spiritking
--

CREATE SEQUENCE game_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.game_log_id_seq OWNER TO spiritking;

--
-- Name: game_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: spiritking
--

ALTER SEQUENCE game_log_id_seq OWNED BY game_log.id;


--
-- Name: gmip; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE gmip (
    ip character varying(15) NOT NULL,
    description character varying(50)
);


ALTER TABLE public.gmip OWNER TO spiritking;

--
-- Name: gmtool_log; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE gmtool_log (
    gameaccount character varying(50),
    gameserver character varying(32),
    itemid character varying(10),
    itemname character varying(50),
    itemcount integer,
    byuser character varying(50),
    regdate date DEFAULT now()
);


ALTER TABLE public.gmtool_log OWNER TO spiritking;

--
-- Name: id_actname; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW id_actname AS
    SELECT t1.id, t1.username FROM dblink('user=postgres dbname=FNAccount'::text, 'select id,username from accounts'::text) t1(id integer, username text);


ALTER TABLE public.id_actname OWNER TO postgres;

--
-- Name: powerupitem; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE powerupitem (
    item_id integer NOT NULL,
    cnname text DEFAULT ''::text,
    itemname text DEFAULT ''::text,
    stack_size integer
);


ALTER TABLE public.powerupitem OWNER TO postgres;

--
-- Name: pus_avg; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE pus_avg (
    buydate date DEFAULT now() NOT NULL,
    buyprice integer DEFAULT 0,
    buynum integer DEFAULT 0,
    buyavg integer DEFAULT 0
);


ALTER TABLE public.pus_avg OWNER TO spiritking;

--
-- Name: tb_user; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE tb_user (
    mid character varying(50) NOT NULL,
    password character varying(20),
    pwd character varying(32),
    idnum integer NOT NULL,
    byauthority smallint DEFAULT 0,
    pvalues integer DEFAULT 0,
    firstlogindate timestamp without time zone,
    billingrule smallint DEFAULT 0,
    status smallint DEFAULT 0,
    regdate timestamp with time zone DEFAULT now(),
    lastlogindate timestamp with time zone,
    memberid character varying(50),
    clientip character varying(20),
    updatetime timestamp without time zone DEFAULT now(),
    bonus integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.tb_user OWNER TO spiritking;

--
-- Name: tb_user_idnum_seq; Type: SEQUENCE; Schema: public; Owner: spiritking
--

CREATE SEQUENCE tb_user_idnum_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tb_user_idnum_seq OWNER TO spiritking;

--
-- Name: tb_user_idnum_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: spiritking
--

ALTER SEQUENCE tb_user_idnum_seq OWNED BY tb_user.idnum;


--
-- Name: web_itemmall_log; Type: TABLE; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE TABLE web_itemmall_log (
    idx integer NOT NULL,
    straccountid character varying(50) NOT NULL,
    strcharid character varying(32),
    serverno character(16) NOT NULL,
    itemid integer NOT NULL,
    itemcount smallint DEFAULT 1,
    buytime timestamp with time zone DEFAULT now() NOT NULL,
    buyprice integer,
    clientip character(20),
    buytype smallint DEFAULT 1 NOT NULL,
    bonus integer DEFAULT 0 NOT NULL,
    serverid character varying,
    buytotal integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.web_itemmall_log OWNER TO spiritking;

--
-- Name: web_itemmall_log_idx_seq; Type: SEQUENCE; Schema: public; Owner: spiritking
--

CREATE SEQUENCE web_itemmall_log_idx_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.web_itemmall_log_idx_seq OWNER TO spiritking;

--
-- Name: web_itemmall_log_idx_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: spiritking
--

ALTER SEQUENCE web_itemmall_log_idx_seq OWNED BY web_itemmall_log.idx;


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: spiritking
--

ALTER TABLE game_log ALTER COLUMN id SET DEFAULT nextval('game_log_id_seq'::regclass);


--
-- Name: idnum; Type: DEFAULT; Schema: public; Owner: spiritking
--

ALTER TABLE tb_user ALTER COLUMN idnum SET DEFAULT nextval('tb_user_idnum_seq'::regclass);


--
-- Name: idx; Type: DEFAULT; Schema: public; Owner: spiritking
--

ALTER TABLE web_itemmall_log ALTER COLUMN idx SET DEFAULT nextval('web_itemmall_log_idx_seq'::regclass);


--
-- Name: ccu_mid_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY currentuser
    ADD CONSTRAINT ccu_mid_pkey PRIMARY KEY (mid);


--
-- Name: gamelog_id_mid; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY game_log
    ADD CONSTRAINT gamelog_id_mid PRIMARY KEY (id, mid);


--
-- Name: pk_gmip; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY gmip
    ADD CONSTRAINT pk_gmip PRIMARY KEY (ip);


--
-- Name: pk_uid; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY age_user_aggregate
    ADD CONSTRAINT pk_uid PRIMARY KEY (uid);


--
-- Name: powerupitem_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY powerupitem
    ADD CONSTRAINT powerupitem_pkey PRIMARY KEY (item_id);


--
-- Name: pus_avg_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY pus_avg
    ADD CONSTRAINT pus_avg_pkey PRIMARY KEY (buydate);


--
-- Name: tb_user_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY tb_user
    ADD CONSTRAINT tb_user_pkey PRIMARY KEY (mid);


--
-- Name: web_itemmall_log_pkey; Type: CONSTRAINT; Schema: public; Owner: spiritking; Tablespace: 
--

ALTER TABLE ONLY web_itemmall_log
    ADD CONSTRAINT web_itemmall_log_pkey PRIMARY KEY (idx, straccountid, itemid, buytime);


--
-- Name: game_log_index; Type: INDEX; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE INDEX game_log_index ON game_log USING btree (logindate, logoutdate, serverid, clientip);


--
-- Name: index_tb_user_idnum; Type: INDEX; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE INDEX index_tb_user_idnum ON tb_user USING btree (idnum);


--
-- Name: ix_last_activity; Type: INDEX; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE INDEX ix_last_activity ON age_user_aggregate USING btree (last_activity);


--
-- Name: tb_user_index; Type: INDEX; Schema: public; Owner: spiritking; Tablespace: 
--

CREATE INDEX tb_user_index ON tb_user USING btree (regdate, lastlogindate, firstlogindate);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: age_create_gfaccount(character varying, integer, character varying); Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON FUNCTION age_create_gfaccount(p_name character varying, p_uid integer, p_passwd character varying) FROM PUBLIC;
REVOKE ALL ON FUNCTION age_create_gfaccount(p_name character varying, p_uid integer, p_passwd character varying) FROM postgres;
GRANT ALL ON FUNCTION age_create_gfaccount(p_name character varying, p_uid integer, p_passwd character varying) TO postgres;
GRANT ALL ON FUNCTION age_create_gfaccount(p_name character varying, p_uid integer, p_passwd character varying) TO PUBLIC;


--
-- Name: age_createorupdate_gfaccount(character varying, integer, character varying, timestamp without time zone); Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON FUNCTION age_createorupdate_gfaccount(p_name character varying, p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) FROM PUBLIC;
REVOKE ALL ON FUNCTION age_createorupdate_gfaccount(p_name character varying, p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) FROM postgres;
GRANT ALL ON FUNCTION age_createorupdate_gfaccount(p_name character varying, p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) TO postgres;
GRANT ALL ON FUNCTION age_createorupdate_gfaccount(p_name character varying, p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) TO PUBLIC;


--
-- Name: age_update_gfaccount(integer, character varying, timestamp without time zone); Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON FUNCTION age_update_gfaccount(p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) FROM PUBLIC;
REVOKE ALL ON FUNCTION age_update_gfaccount(p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) FROM postgres;
GRANT ALL ON FUNCTION age_update_gfaccount(p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) TO postgres;
GRANT ALL ON FUNCTION age_update_gfaccount(p_uid integer, p_passwd character varying, p_updatetime timestamp without time zone) TO PUBLIC;


--
-- Name: dblink_connect_u(text); Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON FUNCTION dblink_connect_u(text) FROM PUBLIC;
REVOKE ALL ON FUNCTION dblink_connect_u(text) FROM postgres;
GRANT ALL ON FUNCTION dblink_connect_u(text) TO postgres;


--
-- Name: dblink_connect_u(text, text); Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON FUNCTION dblink_connect_u(text, text) FROM PUBLIC;
REVOKE ALL ON FUNCTION dblink_connect_u(text, text) FROM postgres;
GRANT ALL ON FUNCTION dblink_connect_u(text, text) TO postgres;


--
-- Name: age_user_aggregate; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE age_user_aggregate FROM PUBLIC;
REVOKE ALL ON TABLE age_user_aggregate FROM spiritking;
GRANT ALL ON TABLE age_user_aggregate TO spiritking;


--
-- Name: currentuser; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE currentuser FROM PUBLIC;
REVOKE ALL ON TABLE currentuser FROM spiritking;
GRANT ALL ON TABLE currentuser TO spiritking;


--
-- Name: game_log; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE game_log FROM PUBLIC;
REVOKE ALL ON TABLE game_log FROM spiritking;
GRANT ALL ON TABLE game_log TO spiritking;


--
-- Name: game_log_id_seq; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON SEQUENCE game_log_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE game_log_id_seq FROM spiritking;
GRANT ALL ON SEQUENCE game_log_id_seq TO spiritking;


--
-- Name: gmip; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE gmip FROM PUBLIC;
REVOKE ALL ON TABLE gmip FROM spiritking;
GRANT ALL ON TABLE gmip TO spiritking;


--
-- Name: gmtool_log; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE gmtool_log FROM PUBLIC;
REVOKE ALL ON TABLE gmtool_log FROM spiritking;
GRANT ALL ON TABLE gmtool_log TO spiritking;


--
-- Name: powerupitem; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE powerupitem FROM PUBLIC;
REVOKE ALL ON TABLE powerupitem FROM postgres;
GRANT ALL ON TABLE powerupitem TO postgres;
GRANT ALL ON TABLE powerupitem TO spiritking;


--
-- Name: pus_avg; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE pus_avg FROM PUBLIC;
REVOKE ALL ON TABLE pus_avg FROM spiritking;
GRANT ALL ON TABLE pus_avg TO spiritking;


--
-- Name: tb_user; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE tb_user FROM PUBLIC;
REVOKE ALL ON TABLE tb_user FROM spiritking;
GRANT ALL ON TABLE tb_user TO spiritking;


--
-- Name: tb_user_idnum_seq; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON SEQUENCE tb_user_idnum_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tb_user_idnum_seq FROM spiritking;
GRANT ALL ON SEQUENCE tb_user_idnum_seq TO spiritking;


--
-- Name: web_itemmall_log; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON TABLE web_itemmall_log FROM PUBLIC;
REVOKE ALL ON TABLE web_itemmall_log FROM spiritking;
GRANT ALL ON TABLE web_itemmall_log TO spiritking;


--
-- Name: web_itemmall_log_idx_seq; Type: ACL; Schema: public; Owner: spiritking
--

REVOKE ALL ON SEQUENCE web_itemmall_log_idx_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE web_itemmall_log_idx_seq FROM spiritking;
GRANT ALL ON SEQUENCE web_itemmall_log_idx_seq TO spiritking;


--
-- PostgreSQL database dump complete
--

