#!/bin/bash
#===============================================================================
#
#          FILE: change_twolevel_mtime.sh
#
#         USAGE: change_twolevel_mtime.sh <Log File Prefix>
#
#   DESCRIPTION: Change time of last modification of the log files to yesterday
#
#       OPTIONS: <Log File Prefix>
#
#          BUGS:  ---
#        AUTHOR: xvincent.tu (Vincent Tu), xvincent.tu@x-legend.com.tw
#       COMPANY: X-LEGEND Entertainment Corp.
#       CREATED: Sat Sep 30 15:51:06 CST 2017
#      REVISION: 1.0
#
#          TODO:
#
#===============================================================================

#set -o nounset                              # Treat unset variables as an error
#set -m                                       # Enable job control

[ "$1" == "" ] && exec echo "Usage: $0 <Log File Prefix>"

yesterday_datetime=$(date -d "1 day ago" '+%Y-%m-%d')
yesterday_datetime_lastmin=$(date -d "1 day ago" '+%Y%m%d2359')
today_datetime_1stmin=$(date +"%Y-%m-%d 00:00:00")
today_unixtime_1stmin=$(date -d "${today_datetime_1stmin}" +%s)

filepath="$HOME/servers*/MissionServer*/"
if [ "$1" != "onelevel" -a "$1" != "twolevel" ]; then
        echo "Filename prefix error!"
        exit
else
        filename="$1.log.${yesterday_datetime}"
fi

if [ ! -f "${filepath}${filename}" ]; then
        echo "File not exist, please check filepath or filename prefix!"
        exit
fi

echo ${filepath}${filename}

file_modify_datetime=$(stat ${filepath}${filename} | egrep Modify | awk -F" " '{print $2" "$3}' | cut -c 1-19)
file_modify_unixtime=$(date -d "${file_modify_datetime}" +%s)

if [ ${file_modify_unixtime} -ge ${today_unixtime_1stmin} ]; then
        echo "Update File Modified Time ( ${filepath}${filename} )"
        touch -a -m -t ${yesterday_datetime_lastmin} ${filepath}${filename}
else
        echo "Nothing to do! ( ${filepath}${filename} )"
fi
