#!/usr/bin/env python33
# -*- coding: utf-8 -*-

"""

"""
#setting
automatic_calculation = True
attribute_fields = 25
# type (add only, do not modify)
numbers = r'([-0-9]+)'
anychars = r'(.+)'
anychars_or_zero = r'(.*)'
datetime = r'([0-9][0-9][0-9][0-9]/[0-9][0-9]/[0-9][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9])'
minusdatetime = r'([0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9])'
#running_number = r'\s([-0-9]+)'
running_number = r' {0,9}([-0-9]+)'
upper_case_only = r'([A-Z]+)'
ture_or_false = r'([TF])'
attribute = '(' + r':[-0-9 ]+' * attribute_fields + ')'
jsonfm = '({' + anychars + '})'


patterns_dict = {
# auction
"__auction_price__" : numbers,
"__auction_dur__" : numbers,
"__seller_id__" : numbers,
"__buyer_id__" : numbers,
"__buyer_gold__" : numbers,

# common
"__running_number__" : running_number,
"__datetime__" : datetime,
"__apex_datetime__" : minusdatetime,
"__apex_second_datetime__" : minusdatetime,
"__log_category__" : upper_case_only,
"__log_type__" : anychars,
"__account_name__" : anychars,
"__account_id__" : numbers,
"__ip_address__" : anychars,

# quantity
"__quantity_change__" : numbers,
"__get_quantity__" : numbers,
"__remain_quantity__" : numbers,

# gold
"__gold__" : numbers,

# anci
"__anci__" : numbers,

# direction
"__source__" : anychars,
"__to_target__" : anychars,

# item
"__item_id__" : numbers,
"__item_uid__" : numbers,
"__item_name__" : anychars_or_zero,
"__item_create_time__" : numbers,
"__item_attribute__" : attribute,
"__item_durability__" : numbers,
"__item_quality__" : numbers,
"__item_second_name__" : anychars_or_zero,

# monster
"__monster_name__" : anychars,

# character
"__char_id__" : numbers,
"__char_name__" : anychars,
"__char_level__" : numbers,

# location
"__node__" : numbers,
"__node_name__" : anychars_or_zero,
"__x__" : numbers,
"__y__" : numbers,

# mail
"__title__" : anychars,
"__sid__" : numbers,
"__rid__" : numbers,
"__mail_id__" : numbers,
"__send_time__" : numbers,
"__due_date__" : numbers,
"__action_type__" : anychars,
"__sender_name__" : anychars,
"__mail_gold__" : numbers,
"__mail_open__" : numbers,
"__mail_return__" : numbers,
"__mail_item_id__" : numbers,
"__mail_item_uid__" : numbers,
"__mail_item_dur__" : numbers,
"__mail_zid__" : numbers,
"__mail_item_id_2__" : numbers,
"__mail_item_uid_2__" : numbers,
"__mail_item_dur_2__" : numbers,
"__mail_item_id_3__" : numbers,
"__mail_item_uid_3__" : numbers,
"__mail_item_dur_3__" : numbers,
"__mail_item_id_4__" : numbers,
"__mail_item_uid_4__" : numbers,
"__mail_item_dur_4__" : numbers,
"__mail_item_id_5__" : numbers,
"__mail_item_uid_5__" : numbers,
"__mail_item_dur_5__" : numbers,
"__mail_item_id_6__" : numbers,
"__mail_item_uid_6__" : numbers,
"__mail_item_dur_6__" : numbers,
"__mail_others__" : anychars,

# pwd
"__secret__" : anychars,
"__pwd_state__" : anychars,

# vip
"__vip_level1__": numbers,
"__vip_level2__": numbers,
"__vip_points__": numbers,

# mission server blew date
"__ms_year__" : numbers,
"__ms_month__" : numbers,
"__ms_day__" : numbers,    

# others
"__gm_cmd__" : anychars,
"__true_or_false__" : ture_or_false,
"__unknown_string_1__" : anychars,
"__unknown_string_2__" : anychars,
"__unknown_string_3__" : anychars,
"__unknown_string_4__" : anychars,
"__unknown_string_5__" : anychars,
"__unknown_string_6__" : anychars,
"__unknown_number_1__" : numbers,
"__unknown_number_2__" : numbers,
"__unknown_number_3__" : numbers,
"__unknown_number_4__" : numbers,
"__unknown_number_5__" : numbers,
"__unknown_number_6__" : numbers,
"__apex_no__" : numbers,
"__apex_no2__" : numbers,
"__apex_note__" : anychars_or_zero,

"__lottery_tid__" : numbers,
"__lottery_plv__" : numbers,
"__lottery_coin_num1__" : numbers,
"__lottery_coin_num2__" : numbers,
"__lottery_coin_type__" : numbers,
# attribute (::$"__p1"__:$"__p2"__:$"__p3"__:$"__p4"__:$"__p5"__:$"__p6"__:$"__p7"__:$"__p8"__:$"__p9"__:$"__p10"__:$"__p11"__:$"__p12"__:$"__p13"__:$"__p14"__:$"__p15"__:$"__p16"__:$"__p17"__:$"__p18"__:$"__p19"__:$"__p20"__:$"__p21"__:$"__p22"__:$"__p23"__:$"__p24"__:$"__p25"__:$"__p26"__:$"__p27"__)
"__item_property__" :  attribute, 

# twolevel (mobile)
"__appkey__" : numbers,
"__version__" : anychars,
"__minusdatetime__" : minusdatetime,
"__normalversion__" : anychars,
"__step_num_id__" : anychars,
"__serverid__" : anychars,
"__gamechannel__" : anychars,
"__cause_id__" : numbers,
"__quantity__" : numbers,
"__total__" : numbers,
"__type_id__" : numbers,
"__vip_level__" : numbers,
"__location__" : numbers,
"__action__" : numbers,
#"__detail__" : jsonfm,
"__detail__" : anychars,
"__bind_money__" : numbers,
"__money_count__" : numbers,
"__money_type__" : numbers,
"__sp_type_id__" : anychars,
"__sp_item_id__" : anychars,

# kingdomwar (MissionServer)
"__kingdom_id__": numbers,
"__total_join__": numbers,
"__total_defense__": numbers,
"__total_attack__": numbers,
"__session__": numbers,
"__side__": numbers,
}
