import re
import sys

def find_special_title_logs(file_path):
    special_title_logs = []
    with open(file_path, 'r', encoding='utf-8') as file:
        for line in file:
            if "Title:" in line:
                # 排除包含 < 和 >、中文或日文字符的標題
                if '<' in line and '>' in line or re.search(r'[\u4e00-\u9fff\u3040-\u309F\u30A0-\u30FF]', line):
                    continue

                # 使用正則表達式來尋找不是英文字母、數字和常見標點的標題
                match = re.search(r"Title:([^A-Za-z0-9 ,.!?'\"]+)", line)
                if match:
                    special_title_logs.append(line.strip())

    return special_title_logs

if __name__ == "__main__":
    if len(sys.argv) < 2:
        print("Usage: python mail_title_filter.py <path_to_log_file>")
        sys.exit(1)

    file_path = sys.argv[1]
    logs_with_special_titles = find_special_title_logs(file_path)
    for log in logs_with_special_titles:
        print(log)

