/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v2;

import com.android.apksig.ApkVerifier;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.util.ByteBufferUtils;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import com.android.apksig.internal.util.X509CertificateUtils;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.RunnablesExecutor;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class V2SchemeVerifier {
    private static final int APK_SIGNATURE_SCHEME_V2_BLOCK_ID = 1896449818;

    private V2SchemeVerifier() {
    }

    public static ApkSigningBlockUtils.Result verify(RunnablesExecutor executor, DataSource apk, ApkUtils.ZipSections zipSections, Map<Integer, String> supportedApkSigSchemeNames, Set<Integer> foundSigSchemeIds, int minSdkVersion, int maxSdkVersion) throws IOException, ApkFormatException, NoSuchAlgorithmException, ApkSigningBlockUtils.SignatureNotFoundException {
        ApkSigningBlockUtils.Result result = new ApkSigningBlockUtils.Result(2);
        SignatureInfo signatureInfo = ApkSigningBlockUtils.findSignature(apk, zipSections, 1896449818, result);
        DataSource beforeApkSigningBlock = apk.slice(0L, signatureInfo.apkSigningBlockOffset);
        DataSource centralDir = apk.slice(signatureInfo.centralDirOffset, signatureInfo.eocdOffset - signatureInfo.centralDirOffset);
        ByteBuffer eocd = signatureInfo.eocd;
        V2SchemeVerifier.verify(executor, beforeApkSigningBlock, signatureInfo.signatureBlock, centralDir, eocd, supportedApkSigSchemeNames, foundSigSchemeIds, minSdkVersion, maxSdkVersion, result);
        return result;
    }

    private static void verify(RunnablesExecutor executor, DataSource beforeApkSigningBlock, ByteBuffer apkSignatureSchemeV2Block, DataSource centralDir, ByteBuffer eocd, Map<Integer, String> supportedApkSigSchemeNames, Set<Integer> foundSigSchemeIds, int minSdkVersion, int maxSdkVersion, ApkSigningBlockUtils.Result result) throws IOException, NoSuchAlgorithmException {
        HashSet<ContentDigestAlgorithm> contentDigestsToVerify = new HashSet<ContentDigestAlgorithm>(1);
        V2SchemeVerifier.parseSigners(apkSignatureSchemeV2Block, contentDigestsToVerify, supportedApkSigSchemeNames, foundSigSchemeIds, minSdkVersion, maxSdkVersion, result);
        if (result.containsErrors()) {
            return;
        }
        ApkSigningBlockUtils.verifyIntegrity(executor, beforeApkSigningBlock, centralDir, eocd, contentDigestsToVerify, result);
        if (!result.containsErrors()) {
            result.verified = true;
        }
    }

    public static void parseSigners(ByteBuffer apkSignatureSchemeV2Block, Set<ContentDigestAlgorithm> contentDigestsToVerify, Map<Integer, String> supportedApkSigSchemeNames, Set<Integer> foundApkSigSchemeIds, int minSdkVersion, int maxSdkVersion, ApkSigningBlockUtils.Result result) throws NoSuchAlgorithmException {
        CertificateFactory certFactory;
        ByteBuffer signers;
        try {
            signers = ApkSigningBlockUtils.getLengthPrefixedSlice(apkSignatureSchemeV2Block);
        }
        catch (ApkFormatException e5) {
            result.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_SIGNERS, new Object[0]);
            return;
        }
        if (!signers.hasRemaining()) {
            result.addError(ApkVerifier.Issue.V2_SIG_NO_SIGNERS, new Object[0]);
            return;
        }
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e6) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", e6);
        }
        int signerCount = 0;
        while (signers.hasRemaining()) {
            int signerIndex = signerCount++;
            ApkSigningBlockUtils.Result.SignerInfo signerInfo = new ApkSigningBlockUtils.Result.SignerInfo();
            signerInfo.index = signerIndex;
            result.signers.add(signerInfo);
            try {
                ByteBuffer signer = ApkSigningBlockUtils.getLengthPrefixedSlice(signers);
                V2SchemeVerifier.parseSigner(signer, certFactory, signerInfo, contentDigestsToVerify, supportedApkSigSchemeNames, foundApkSigSchemeIds, minSdkVersion, maxSdkVersion);
            }
            catch (ApkFormatException | BufferUnderflowException e7) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_SIGNER, new Object[0]);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void parseSigner(ByteBuffer signerBlock, CertificateFactory certFactory, ApkSigningBlockUtils.Result.SignerInfo result, Set<ContentDigestAlgorithm> contentDigestsToVerify, Map<Integer, String> supportedApkSigSchemeNames, Set<Integer> foundApkSigSchemeIds, int minSdkVersion, int maxSdkVersion) throws ApkFormatException, NoSuchAlgorithmException {
        int id;
        byte[] certificatePublicKeyBytes;
        SignatureAlgorithm signatureAlgorithm;
        ByteBuffer signedData = ApkSigningBlockUtils.getLengthPrefixedSlice(signerBlock);
        byte[] signedDataBytes = new byte[signedData.remaining()];
        signedData.get(signedDataBytes);
        signedData.flip();
        result.signedData = signedDataBytes;
        ByteBuffer signatures = ApkSigningBlockUtils.getLengthPrefixedSlice(signerBlock);
        byte[] publicKeyBytes = ApkSigningBlockUtils.readLengthPrefixedByteArray(signerBlock);
        int signatureCount = 0;
        ArrayList<ApkSigningBlockUtils.SupportedSignature> supportedSignatures = new ArrayList<ApkSigningBlockUtils.SupportedSignature>(1);
        while (signatures.hasRemaining()) {
            ++signatureCount;
            try {
                ByteBuffer signature = ApkSigningBlockUtils.getLengthPrefixedSlice(signatures);
                int sigAlgorithmId = signature.getInt();
                byte[] sigBytes = ApkSigningBlockUtils.readLengthPrefixedByteArray(signature);
                result.signatures.add(new ApkSigningBlockUtils.Result.SignerInfo.Signature(sigAlgorithmId, sigBytes));
                signatureAlgorithm = SignatureAlgorithm.findById(sigAlgorithmId);
                if (signatureAlgorithm == null) {
                    result.addWarning(ApkVerifier.Issue.V2_SIG_UNKNOWN_SIG_ALGORITHM, sigAlgorithmId);
                    continue;
                }
                supportedSignatures.add(new ApkSigningBlockUtils.SupportedSignature(signatureAlgorithm, sigBytes));
            }
            catch (ApkFormatException | BufferUnderflowException e5) {
                result.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_SIGNATURE, signatureCount);
                return;
            }
        }
        if (result.signatures.isEmpty()) {
            result.addError(ApkVerifier.Issue.V2_SIG_NO_SIGNATURES, new Object[0]);
            return;
        }
        List<ApkSigningBlockUtils.SupportedSignature> signaturesToVerify = null;
        try {
            signaturesToVerify = ApkSigningBlockUtils.getSignaturesToVerify(supportedSignatures, minSdkVersion, maxSdkVersion);
        }
        catch (ApkSigningBlockUtils.NoSupportedSignaturesException e6) {
            result.addError(ApkVerifier.Issue.V2_SIG_NO_SUPPORTED_SIGNATURES, e6);
            return;
        }
        for (ApkSigningBlockUtils.SupportedSignature signature : signaturesToVerify) {
            PublicKey publicKey;
            signatureAlgorithm = signature.algorithm;
            String jcaSignatureAlgorithm = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getFirst();
            AlgorithmParameterSpec jcaSignatureAlgorithmParams = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getSecond();
            String keyAlgorithm = signatureAlgorithm.getJcaKeyAlgorithm();
            try {
                publicKey = KeyFactory.getInstance(keyAlgorithm).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            }
            catch (Exception e7) {
                result.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_PUBLIC_KEY, e7);
                return;
            }
            try {
                Signature sig = Signature.getInstance(jcaSignatureAlgorithm);
                sig.initVerify(publicKey);
                if (jcaSignatureAlgorithmParams != null) {
                    sig.setParameter(jcaSignatureAlgorithmParams);
                }
                signedData.position(0);
                sig.update(signedData);
                byte[] sigBytes = signature.signature;
                if (!sig.verify(sigBytes)) {
                    result.addError(ApkVerifier.Issue.V2_SIG_DID_NOT_VERIFY, new Object[]{signatureAlgorithm});
                    return;
                }
                result.verifiedSignatures.put(signatureAlgorithm, sigBytes);
                contentDigestsToVerify.add(signatureAlgorithm.getContentDigestAlgorithm());
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | SignatureException e8) {
                result.addError(ApkVerifier.Issue.V2_SIG_VERIFY_EXCEPTION, new Object[]{signatureAlgorithm, e8});
                return;
            }
        }
        signedData.position(0);
        ByteBuffer digests = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        ByteBuffer certificates = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        ByteBuffer additionalAttributes = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        int certificateIndex = -1;
        while (certificates.hasRemaining()) {
            X509Certificate certificate;
            ++certificateIndex;
            byte[] encodedCert = ApkSigningBlockUtils.readLengthPrefixedByteArray(certificates);
            try {
                certificate = X509CertificateUtils.generateCertificate(encodedCert, certFactory);
            }
            catch (CertificateException e9) {
                result.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_CERTIFICATE, certificateIndex, certificateIndex + 1, e9);
                return;
            }
            certificate = new GuaranteedEncodedFormX509Certificate(certificate, encodedCert);
            result.certs.add(certificate);
        }
        if (result.certs.isEmpty()) {
            result.addError(ApkVerifier.Issue.V2_SIG_NO_CERTIFICATES, new Object[0]);
            return;
        }
        X509Certificate mainCertificate = result.certs.get(0);
        try {
            certificatePublicKeyBytes = ApkSigningBlockUtils.encodePublicKey(mainCertificate.getPublicKey());
        }
        catch (InvalidKeyException e10) {
            System.out.println("Caught an exception encoding the public key: " + e10);
            e10.printStackTrace();
            certificatePublicKeyBytes = mainCertificate.getPublicKey().getEncoded();
        }
        if (!Arrays.equals(publicKeyBytes, certificatePublicKeyBytes)) {
            result.addError(ApkVerifier.Issue.V2_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD, ApkSigningBlockUtils.toHex(certificatePublicKeyBytes), ApkSigningBlockUtils.toHex(publicKeyBytes));
            return;
        }
        int digestCount = 0;
        while (digests.hasRemaining()) {
            ++digestCount;
            try {
                ByteBuffer digest = ApkSigningBlockUtils.getLengthPrefixedSlice(digests);
                int sigAlgorithmId = digest.getInt();
                byte[] byArray = ApkSigningBlockUtils.readLengthPrefixedByteArray(digest);
                result.contentDigests.add(new ApkSigningBlockUtils.Result.SignerInfo.ContentDigest(sigAlgorithmId, byArray));
            }
            catch (ApkFormatException | BufferUnderflowException e11) {
                result.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_DIGEST, digestCount);
                return;
            }
        }
        ArrayList<Integer> sigAlgsFromSignaturesRecord = new ArrayList<Integer>(result.signatures.size());
        for (ApkSigningBlockUtils.Result.SignerInfo.Signature signature : result.signatures) {
            sigAlgsFromSignaturesRecord.add(signature.getAlgorithmId());
        }
        ArrayList<Integer> sigAlgsFromDigestsRecord = new ArrayList<Integer>(result.contentDigests.size());
        for (ApkSigningBlockUtils.Result.SignerInfo.ContentDigest digest : result.contentDigests) {
            sigAlgsFromDigestsRecord.add(digest.getSignatureAlgorithmId());
        }
        if (!sigAlgsFromSignaturesRecord.equals(sigAlgsFromDigestsRecord)) {
            result.addError(ApkVerifier.Issue.V2_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS, sigAlgsFromSignaturesRecord, sigAlgsFromDigestsRecord);
            return;
        }
        boolean bl = false;
        Set<Integer> supportedApkSigSchemeIds = supportedApkSigSchemeNames.keySet();
        HashSet<Integer> supportedExpectedApkSigSchemeIds = new HashSet<Integer>(1);
        block25: while (additionalAttributes.hasRemaining()) {
            void var24_41;
            ++var24_41;
            try {
                ByteBuffer attribute = ApkSigningBlockUtils.getLengthPrefixedSlice(additionalAttributes);
                id = attribute.getInt();
                byte[] value = ByteBufferUtils.toByteArray(attribute);
                result.additionalAttributes.add(new ApkSigningBlockUtils.Result.SignerInfo.AdditionalAttribute(id, value));
                switch (id) {
                    case -1091571699: {
                        int foundId = ByteBuffer.wrap(value).order(ByteOrder.LITTLE_ENDIAN).getInt();
                        if (supportedApkSigSchemeIds.contains(foundId)) {
                            supportedExpectedApkSigSchemeIds.add(foundId);
                            continue block25;
                        }
                        result.addWarning(ApkVerifier.Issue.V2_SIG_UNKNOWN_APK_SIG_SCHEME_ID, result.index, foundId);
                        continue block25;
                    }
                }
                result.addWarning(ApkVerifier.Issue.V2_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE, id);
            }
            catch (ApkFormatException | BufferUnderflowException e12) {
                result.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE, (int)var24_41);
                return;
            }
        }
        Iterator iterator2 = supportedExpectedApkSigSchemeIds.iterator();
        while (iterator2.hasNext()) {
            id = (Integer)iterator2.next();
            if (foundApkSigSchemeIds.contains(id)) continue;
            String apkSigSchemeName = supportedApkSigSchemeNames.get(id);
            result.addError(ApkVerifier.Issue.V2_SIG_MISSING_APK_SIG_REFERENCED, result.index, apkSigSchemeName);
        }
    }
}

