/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.util;

import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSource;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileChannelDataSource
implements DataSource {
    private static final int MAX_READ_CHUNK_SIZE = 0x100000;
    private final FileChannel mChannel;
    private final long mOffset;
    private final long mSize;

    public FileChannelDataSource(FileChannel channel) {
        this.mChannel = channel;
        this.mOffset = 0L;
        this.mSize = -1L;
    }

    public FileChannelDataSource(FileChannel channel, long offset, long size) {
        if (offset < 0L) {
            throw new IndexOutOfBoundsException("offset: " + size);
        }
        if (size < 0L) {
            throw new IndexOutOfBoundsException("size: " + size);
        }
        this.mChannel = channel;
        this.mOffset = offset;
        this.mSize = size;
    }

    @Override
    public long size() {
        if (this.mSize == -1L) {
            try {
                return this.mChannel.size();
            }
            catch (IOException e5) {
                return 0L;
            }
        }
        return this.mSize;
    }

    @Override
    public FileChannelDataSource slice(long offset, long size) {
        long sourceSize = this.size();
        FileChannelDataSource.checkChunkValid(offset, size, sourceSize);
        if (offset == 0L && size == sourceSize) {
            return this;
        }
        return new FileChannelDataSource(this.mChannel, this.mOffset + offset, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feed(long offset, long size, DataSink sink) throws IOException {
        int chunkSize;
        long remaining;
        long sourceSize = this.size();
        FileChannelDataSource.checkChunkValid(offset, size, sourceSize);
        if (size == 0L) {
            return;
        }
        long chunkOffsetInFile = this.mOffset + offset;
        ByteBuffer buf = ByteBuffer.allocateDirect((int)Math.min(remaining, 0x100000L));
        for (remaining = size; remaining > 0L; remaining -= (long)chunkSize) {
            buf.limit(chunkSize);
            FileChannel fileChannel = this.mChannel;
            synchronized (fileChannel) {
                int read;
                this.mChannel.position(chunkOffsetInFile);
                for (int chunkRemaining = chunkSize = (int)Math.min(remaining, (long)buf.capacity()); chunkRemaining > 0; chunkRemaining -= read) {
                    read = this.mChannel.read(buf);
                    if (read >= 0) continue;
                    throw new IOException("Unexpected EOF encountered");
                }
            }
            buf.flip();
            sink.consume(buf);
            buf.clear();
            chunkOffsetInFile += (long)chunkSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(long offset, int size, ByteBuffer dest) throws IOException {
        long sourceSize = this.size();
        FileChannelDataSource.checkChunkValid(offset, size, sourceSize);
        if (size == 0) {
            return;
        }
        if (size > dest.remaining()) {
            throw new BufferOverflowException();
        }
        long offsetInFile = this.mOffset + offset;
        int prevLimit = dest.limit();
        try {
            int chunkSize;
            dest.limit(dest.position() + size);
            for (int remaining = size; remaining > 0; remaining -= chunkSize) {
                FileChannel fileChannel = this.mChannel;
                synchronized (fileChannel) {
                    this.mChannel.position(offsetInFile);
                    chunkSize = this.mChannel.read(dest);
                }
                offsetInFile += (long)chunkSize;
            }
        }
        finally {
            dest.limit(prevLimit);
        }
    }

    @Override
    public ByteBuffer getByteBuffer(long offset, int size) throws IOException {
        if (size < 0) {
            throw new IndexOutOfBoundsException("size: " + size);
        }
        ByteBuffer result = ByteBuffer.allocate(size);
        this.copyTo(offset, size, result);
        result.flip();
        return result;
    }

    private static void checkChunkValid(long offset, long size, long sourceSize) {
        if (offset < 0L) {
            throw new IndexOutOfBoundsException("offset: " + offset);
        }
        if (size < 0L) {
            throw new IndexOutOfBoundsException("size: " + size);
        }
        if (offset > sourceSize) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") > source size (" + sourceSize + ")");
        }
        long endOffset = offset + size;
        if (endOffset < offset) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") overflow");
        }
        if (endOffset > sourceSize) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") > source size (" + sourceSize + ")");
        }
    }
}

